/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.selector;

import flex.messaging.MessageException;
import flex.messaging.messages.Message;
import flex.messaging.services.messaging.selector.JMSSelector;
import flex.messaging.services.messaging.selector.NumericValue;
import flex.messaging.services.messaging.selector.ParseException;
import flex.messaging.services.messaging.selector.PropertyValueComparator;
import flex.messaging.services.messaging.selector.SQLParserConstants;
import flex.messaging.services.messaging.selector.SQLParserTokenManager;
import flex.messaging.services.messaging.selector.SimpleCharStream;
import flex.messaging.services.messaging.selector.Token;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class SQLParser
implements SQLParserConstants {
    Message msg = null;
    JMSSelector selector;
    PropertyValueComparator comparator = PropertyValueComparator.getInstance();
    public SQLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[19];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[13];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public SQLParser(JMSSelector selector, InputStream stream) {
        this(stream);
        this.selector = selector;
    }

    public void setMessage(Message msg) {
        this.msg = msg;
    }

    public final boolean match(Message msg) throws ParseException {
        boolean matchResult = false;
        Object res = null;
        if (msg == null) {
            throw new MessageException("Null Message for Selector");
        }
        this.msg = msg;
        res = this.SQLOrExpr();
        if (res != null) {
            if (!(res instanceof Boolean)) {
                throw new ParseException("Selector must evaluate to a java.lang.Boolean. Instead evaluated to a " + res.getClass().getName());
            }
            matchResult = (Boolean)res;
        }
        return matchResult;
    }

    public final Object SQLOrExpr() throws ParseException {
        Object res1 = null;
        Object res2 = null;
        res1 = this.SQLAndExpr();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(13);
            res2 = this.SQLAndExpr();
            if (res1 != null && !(res1 instanceof Boolean) || res2 != null && !(res2 instanceof Boolean)) {
                throw new ParseException("SQLOrExpr requires java.lang.Boolean for opearnds of OR operation");
            }
            if (res1 != null && res2 != null) {
                res1 = (Boolean)res1 != false || (Boolean)res2 != false;
                continue;
            }
            if (res1 == null && res2 == null) {
                res1 = null;
                continue;
            }
            Boolean notUnknownValue = (Boolean)(res1 == null ? res2 : res1);
            if (notUnknownValue.booleanValue()) {
                res1 = notUnknownValue;
                continue;
            }
            res1 = null;
        }
        return res1;
    }

    public final Object SQLAndExpr() throws ParseException {
        Object res1 = null;
        Object res2 = null;
        res1 = this.SQLNotExpr();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(6);
            res2 = this.SQLNotExpr();
            if (res1 != null && !(res1 instanceof Boolean) || res2 != null && !(res2 instanceof Boolean)) {
                throw new ParseException("SQLAndExpr requires java.lang.Boolean for operands of AND operation");
            }
            if (res1 != null && res2 != null) {
                res1 = (Boolean)res1 != false && (Boolean)res2 != false;
                continue;
            }
            if (res1 == null && res2 == null) {
                res1 = null;
                continue;
            }
            Boolean notUnknownValue = (Boolean)(res1 == null ? res2 : res1);
            if (notUnknownValue.booleanValue()) {
                res1 = null;
                continue;
            }
            res1 = notUnknownValue;
        }
        return res1;
    }

    public final Object SQLNotExpr() throws ParseException {
        boolean isNot = false;
        Object res = null;
        Object obj = null;
        if (this.jj_2_1(2)) {
            this.jj_consume_token(11);
            isNot = true;
        }
        res = this.SQLCompareExpr();
        if (isNot) {
            if (res == null) {
                return res;
            }
            if (!(res instanceof Boolean)) {
                throw new ParseException("The NOT operator requires a Boolean to be returned by SQLCompareExpr");
            }
            res = (Boolean)res == false;
        }
        return res;
    }

    public final Object SQLCompareExpr() throws ParseException {
        Object res = null;
        if (this.jj_2_2(2)) {
            res = this.SQLIsClause();
        } else {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 29: 
                case 33: 
                case 34: {
                    res = this.SQLSumExpr();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: 
                        case 8: 
                        case 10: 
                        case 11: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: {
                            res = this.SQLCompareExprRight(res);
                            break block0;
                        }
                    }
                    this.jj_la1[2] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return res;
    }

    public final Boolean SQLCompareExprRight(Object obj1) throws ParseException {
        Boolean res = null;
        Object obj2 = null;
        if (obj1 == null) {
            // empty if block
        }
        if (this.jj_2_3(2)) {
            res = this.SQLLikeClause(obj1);
        } else if (this.jj_2_4(4)) {
            res = this.SQLInClause(obj1);
        } else if (this.jj_2_5(2)) {
            res = this.SQLBetweenClause(obj1);
        } else if (this.jj_2_6(2)) {
            this.jj_consume_token(27);
            obj2 = this.SQLSumExpr();
            if (obj1 == null) {
                return null;
            }
            res = this.comparator.compare(obj1, obj2) == 0;
        } else if (this.jj_2_7(2)) {
            this.jj_consume_token(28);
            obj2 = this.SQLSumExpr();
            if (obj1 == null) {
                return null;
            }
            res = this.comparator.compare(obj1, obj2) != 0;
        } else if (this.jj_2_8(2)) {
            this.jj_consume_token(25);
            obj2 = this.SQLSumExpr();
            if (obj1 instanceof String || obj2 instanceof String || obj1 instanceof Boolean || obj2 instanceof Boolean) {
                throw new ParseException("Cannot use > with String or Boolean types");
            }
            if (obj1 == null) {
                return null;
            }
            res = this.comparator.compare(obj1, obj2) > 0;
        } else if (this.jj_2_9(2)) {
            this.jj_consume_token(26);
            obj2 = this.SQLSumExpr();
            if (obj1 instanceof String || obj2 instanceof String || obj1 instanceof Boolean || obj2 instanceof Boolean) {
                throw new ParseException("Cannot use >= with String or Boolean types");
            }
            if (obj1 == null) {
                return null;
            }
            res = this.comparator.compare(obj1, obj2) >= 0;
        } else if (this.jj_2_10(2)) {
            this.jj_consume_token(23);
            obj2 = this.SQLSumExpr();
            if (obj1 instanceof String || obj2 instanceof String || obj1 instanceof Boolean || obj2 instanceof Boolean) {
                throw new ParseException("Cannot use < with String or Boolean types");
            }
            if (obj1 == null) {
                return null;
            }
            int i2 = this.comparator.compare(obj1, obj2);
            if (i2 != -100) {
                res = i2 < 0;
            }
        } else if (this.jj_2_11(2)) {
            this.jj_consume_token(24);
            obj2 = this.SQLSumExpr();
            if (obj1 instanceof String || obj2 instanceof String || obj1 instanceof Boolean || obj2 instanceof Boolean) {
                throw new ParseException("Cannot use <= with String or Boolean types");
            }
            if (obj1 == null) {
                return null;
            }
            int i3 = this.comparator.compare(obj1, obj2);
            if (i3 != -100) {
                res = i3 <= 0;
            }
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return res;
    }

    public final Object SQLSumExpr() throws ParseException {
        Object res1 = null;
        Object res2 = null;
        NumericValue num1 = null;
        NumericValue num2 = null;
        boolean doAdd = true;
        res1 = this.SQLProductExpr();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: 
                case 34: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    this.jj_consume_token(33);
                    doAdd = true;
                    break;
                }
                case 34: {
                    this.jj_consume_token(34);
                    doAdd = false;
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            res2 = this.SQLProductExpr();
            num1 = new NumericValue(res1);
            num2 = new NumericValue(res2);
            if (doAdd) {
                res1 = num1.add(num2);
                continue;
            }
            res1 = num1.subtract(num2);
        }
        return res1;
    }

    public final Object SQLProductExpr() throws ParseException {
        Object res1 = null;
        Object res2 = null;
        NumericValue num1 = null;
        NumericValue num2 = null;
        boolean doMultiply = true;
        res1 = this.SQLUnaryExpr();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: 
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: {
                    this.jj_consume_token(31);
                    doMultiply = true;
                    break;
                }
                case 32: {
                    this.jj_consume_token(32);
                    doMultiply = false;
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            res2 = this.SQLUnaryExpr();
            num1 = new NumericValue(res1);
            num2 = new NumericValue(res2);
            if (doMultiply) {
                res1 = num1.multiply(num2);
                continue;
            }
            res1 = num1.divide(num2);
        }
        return res1;
    }

    public final Object SQLUnaryExpr() throws ParseException {
        Object res1 = null;
        NumericValue num1 = null;
        boolean negate = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: 
            case 34: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 33: {
                        this.jj_consume_token(33);
                        break block0;
                    }
                    case 34: {
                        this.jj_consume_token(34);
                        negate = true;
                        break block0;
                    }
                }
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        res1 = this.SQLTerm();
        if (negate) {
            num1 = new NumericValue(res1);
            res1 = num1.negate();
        }
        return res1;
    }

    public final String SQLColRef() throws ParseException {
        String colName = new String("");
        Token x2 = this.jj_consume_token(20);
        colName = x2.image;
        return colName;
    }

    public final Object SQLTerm() throws ParseException {
        Object res = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                res = this.SQLOrExpr();
                this.jj_consume_token(30);
                return res;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                res = this.SQLLiteral();
                return res;
            }
            case 20: {
                String colName = this.SQLColRef();
                try {
                    res = this.msg.getHeader(colName);
                    if (res instanceof Byte || res instanceof Short || res instanceof Integer) {
                        res = new Long(((Number)res).longValue());
                    } else if (res instanceof Float) {
                        res = new Double(((Number)res).doubleValue());
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new MessageException(e2.getMessage());
                }
                return res;
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object SQLLiteral() throws ParseException {
        Token x2 = null;
        Object obj = null;
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    x2 = this.jj_consume_token(18);
                    obj = this.selector.processStringLiteral(x2.image);
                    break;
                }
                case 15: {
                    x2 = this.jj_consume_token(15);
                    obj = new NumericValue(x2.image, 4);
                    break;
                }
                case 16: {
                    x2 = this.jj_consume_token(16);
                    obj = new NumericValue(x2.image, 5);
                    break;
                }
                case 19: {
                    x2 = this.jj_consume_token(19);
                    obj = Boolean.valueOf(x2.image.toLowerCase());
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return obj;
        }
        catch (Exception e2) {
            throw this.generateParseException();
        }
    }

    public final Boolean SQLLikeClause(Object obj1) throws ParseException {
        Boolean res = null;
        boolean isLike = false;
        boolean isNot = false;
        Object propVal = null;
        char escapeChar = '\u0000';
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                isNot = true;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(10);
        String pattern = this.SQLPattern();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                escapeChar = this.EscapeChar();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        if (pattern != null && !(pattern instanceof String)) {
            throw new ParseException("The LIKE target must be a string. Found " + pattern.getClass());
        }
        if (obj1 instanceof String) {
            isLike = this.selector.matchPattern(pattern, (String)obj1, escapeChar);
            if (isNot) {
                isLike = !isLike;
            }
            res = isLike;
        }
        return res;
    }

    public final String SQLPattern() throws ParseException {
        Token x2 = this.jj_consume_token(18);
        String res = x2.image;
        return this.selector.processStringLiteral(res);
    }

    public final char EscapeChar() throws ParseException {
        String escapeCharStr = null;
        Token x2 = this.jj_consume_token(18);
        escapeCharStr = x2.image;
        if (escapeCharStr.length() != 3) {
            throw new ParseException("Expected single escape character for SQL pattern. Found " + escapeCharStr);
        }
        char escapeChar = escapeCharStr.charAt(1);
        return escapeChar;
    }

    public final Boolean SQLIsClause() throws ParseException {
        boolean isNull = false;
        boolean notNull = false;
        Boolean res = null;
        String colName = this.SQLColRef();
        this.jj_consume_token(9);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                notNull = true;
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        this.jj_consume_token(12);
        try {
            isNull = !this.msg.headerExists(colName);
        }
        catch (Exception e2) {
            throw this.generateParseException();
        }
        if (notNull) {
            isNull = !isNull;
        }
        res = isNull;
        return res;
    }

    public final Boolean SQLInClause(Object obj1) throws ParseException {
        boolean found = false;
        boolean negate = false;
        Boolean res = null;
        ArrayList list = null;
        Object element = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                negate = true;
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        this.jj_consume_token(8);
        this.jj_consume_token(29);
        list = this.SQLLValueList();
        this.jj_consume_token(30);
        if (list != null) {
            Iterator iter = list.iterator();
            try {
                while (iter.hasNext()) {
                    element = iter.next();
                    String str = (String)element;
                }
            }
            catch (ClassCastException cce) {
                throw new ParseException("All TARGETS of a IN clause must be a String. Found a " + element.getClass());
            }
            if (obj1 == null) {
                return null;
            }
            if (!(obj1 instanceof String)) {
                throw new ParseException("Source of IN clause must be a String. Found a " + obj1.getClass().getName());
            }
            found = list.contains(obj1);
        }
        if (negate) {
            found = !found;
        }
        res = found;
        return res;
    }

    public final ArrayList SQLLValueList() throws ParseException {
        Object elem = null;
        ArrayList<Object> list = new ArrayList<Object>();
        elem = this.SQLLValueElement();
        list.add(elem);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(36);
            elem = this.SQLLValueElement();
            list.add(elem);
        }
        return list;
    }

    public final Object SQLLValueElement() throws ParseException {
        Object res = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                if (this.jj_2_12(3)) {
                    res = this.SQLSumExpr();
                    break;
                }
                if (this.jj_2_13(3)) {
                    res = this.SQLOrExpr();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (res instanceof NumericValue) {
            res = ((NumericValue)res).getValue();
        }
        return res;
    }

    public final Boolean SQLBetweenClause(Object obj1) throws ParseException {
        boolean between = false;
        boolean negate = false;
        Object res1 = null;
        Object res2 = null;
        Object list = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                negate = true;
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        this.jj_consume_token(7);
        res1 = this.SQLSumExpr();
        this.jj_consume_token(6);
        res2 = this.SQLSumExpr();
        if (obj1 instanceof NumericValue) {
            obj1 = ((NumericValue)obj1).getValue();
        }
        if (obj1 != null && !(obj1 instanceof Comparable)) {
            throw new ParseException("The LValue for BETWEEN must be a java.lang.Comparable. Found " + obj1);
        }
        if (res1 != null && (res1 instanceof String || res1 instanceof Boolean)) {
            throw new ParseException("The START target for BETWEEN must be a numeric value. Found " + res1.getClass());
        }
        if (res2 != null && (res2 instanceof String || res2 instanceof Boolean)) {
            throw new ParseException("The END target for BETWEEN must be a numeric value. Found " + res2.getClass());
        }
        if (res1 instanceof NumericValue) {
            res1 = ((NumericValue)res1).getValue();
        }
        if (res2 instanceof NumericValue) {
            res2 = ((NumericValue)res2).getValue();
        }
        try {
            if (((Comparable)obj1).compareTo(res1) >= 0 && ((Comparable)obj1).compareTo(res2) <= 0) {
                between = true;
            }
        }
        catch (Throwable t2) {
            return null;
        }
        if (negate) {
            between = !between;
        }
        res1 = between;
        return (Boolean)res1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            Object var5_4 = null;
            this.jj_save(0, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(0, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(0, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            Object var5_4 = null;
            this.jj_save(1, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(1, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(1, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            Object var5_4 = null;
            this.jj_save(2, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(2, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(2, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            Object var5_4 = null;
            this.jj_save(3, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(3, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(3, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            Object var5_4 = null;
            this.jj_save(4, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(4, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(4, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            Object var5_4 = null;
            this.jj_save(5, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(5, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(5, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            Object var5_4 = null;
            this.jj_save(6, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(6, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(6, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            Object var5_4 = null;
            this.jj_save(7, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(7, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(7, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            Object var5_4 = null;
            this.jj_save(8, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(8, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(8, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            Object var5_4 = null;
            this.jj_save(9, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(9, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(9, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            Object var5_4 = null;
            this.jj_save(10, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(10, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(10, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            Object var5_4 = null;
            this.jj_save(11, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(11, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(11, xla);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            Object var5_4 = null;
            this.jj_save(12, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                boolean bl = true;
                Object var5_5 = null;
                this.jj_save(12, xla);
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.jj_save(12, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_3R_35() {
        return this.jj_scan_token(34);
    }

    private final boolean jj_3R_13() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_13()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private final boolean jj_3R_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(33)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_35()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_15() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3_11() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3R_11() {
        Token xsp;
        if (this.jj_3R_20()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_21());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_15()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_3R_16()) {
            return true;
        }
        return this.jj_scan_token(30);
    }

    private final boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_31();
    }

    private final boolean jj_3R_45() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3_1() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_1()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_34();
    }

    private final boolean jj_3R_44() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3R_43() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_33() {
        return this.jj_scan_token(32);
    }

    private final boolean jj_3R_17() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_32() {
        return this.jj_scan_token(31);
    }

    private final boolean jj_3R_42() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                return true;
            }
        }
        return this.jj_3R_24();
    }

    private final boolean jj_3R_46() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_43()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_44()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_45()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_6() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(12);
    }

    private final boolean jj_3_13() {
        return this.jj_3R_11();
    }

    private final boolean jj_3_8() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3R_18() {
        Token xsp;
        if (this.jj_3R_24()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_25());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_12() {
        return this.jj_3R_10();
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_3_12()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_13()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private final boolean jj_3R_27() {
        return this.jj_scan_token(34);
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_28();
    }

    private final boolean jj_3_5() {
        return this.jj_3R_9();
    }

    private final boolean jj_3_4() {
        return this.jj_3R_8();
    }

    private final boolean jj_3R_23() {
        return this.jj_scan_token(36);
    }

    private final boolean jj_3R_41() {
        return this.jj_3R_47();
    }

    private final boolean jj_3R_26() {
        return this.jj_scan_token(33);
    }

    private final boolean jj_3R_38() {
        return this.jj_3R_12();
    }

    private final boolean jj_3R_20() {
        Token xsp;
        if (this.jj_3R_28()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_29());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_3() {
        return this.jj_3R_7();
    }

    private final boolean jj_3R_16() {
        Token xsp;
        if (this.jj_3R_22()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_23());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_37() {
        return this.jj_3R_40();
    }

    private final boolean jj_3R_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_26()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_27()) {
                return true;
            }
        }
        return this.jj_3R_18();
    }

    private final boolean jj_3R_36() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_3R_11()) {
            return true;
        }
        return this.jj_scan_token(30);
    }

    private final boolean jj_3R_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_36()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_37()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_38()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_14() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_47() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_4()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_5()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_6()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_7()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_8()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_9()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_10()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_11()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_10() {
        Token xsp;
        if (this.jj_3R_18()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_19());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_21() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private final boolean jj_3R_39() {
        if (this.jj_3R_10()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3_2() {
        return this.jj_3R_6();
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_39()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{8192, 64, 528485760, 538804224, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 538804224, 884736, 2048, 16384, 2048, 2048, 0, 4096, 2048};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 6, 6, 6, 1, 1, 6, 6, 0, 0, 0, 0, 0, 0, 16, 0, 0};
    }

    public SQLParser(InputStream stream) {
        int i2;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i2;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    public SQLParser(Reader stream) {
        int i2;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i2;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    public SQLParser(SQLParserTokenManager tm) {
        int i2;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    public void ReInit(SQLParserTokenManager tm) {
        int i2;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i2 = 0; i2 < 19; ++i2) {
            this.jj_la1[i2] = -1;
        }
        for (i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
            this.jj_2_rtns[i2] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i2 = 0; i2 < this.jj_2_rtns.length; ++i2) {
                    JJCalls c2 = this.jj_2_rtns[i2];
                    while (c2 != null) {
                        if (c2.gen < this.jj_gen) {
                            c2.first = null;
                        }
                        c2 = c2.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i2 = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i2;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i2);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t2 = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i2 = 0; i2 < index; ++i2) {
            t2 = t2.next != null ? t2.next : (t2.next = this.token_source.getNextToken());
        }
        return t2;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i2 = 0; i2 < this.jj_endpos; ++i2) {
                this.jj_expentry[i2] = this.jj_lasttokens[i2];
            }
            boolean exists = false;
            Enumeration e2 = this.jj_expentries.elements();
            while (e2.hasMoreElements()) {
                int[] oldentry = (int[])e2.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i3 = 0; i3 < this.jj_expentry.length; ++i3) {
                    if (oldentry[i3] == this.jj_expentry[i3]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i2;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[37];
        for (i2 = 0; i2 < 37; ++i2) {
            la1tokens[i2] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i2 = 0; i2 < 19; ++i2) {
            if (this.jj_la1[i2] != this.jj_gen) continue;
            for (int j2 = 0; j2 < 32; ++j2) {
                if ((jj_la1_0[i2] & 1 << j2) != 0) {
                    la1tokens[j2] = true;
                }
                if ((jj_la1_1[i2] & 1 << j2) == 0) continue;
                la1tokens[32 + j2] = true;
            }
        }
        for (i2 = 0; i2 < 37; ++i2) {
            if (!la1tokens[i2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i3 = 0; i3 < this.jj_expentries.size(); ++i3) {
            exptokseq[i3] = (int[])this.jj_expentries.elementAt(i3);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i2 = 0; i2 < 13; ++i2) {
            JJCalls p2 = this.jj_2_rtns[i2];
            do {
                if (p2.gen <= this.jj_gen) continue;
                this.jj_la = p2.arg;
                this.jj_lastpos = this.jj_scanpos = p2.first;
                switch (i2) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                    }
                }
            } while ((p2 = p2.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p2 = this.jj_2_rtns[index];
        while (p2.gen > this.jj_gen) {
            if (p2.next == null) {
                p2 = p2.next = new JJCalls();
                break;
            }
            p2 = p2.next;
        }
        p2.gen = this.jj_gen + xla - this.jj_la;
        p2.first = this.token;
        p2.arg = xla;
    }

    static {
        SQLParser.jj_la1_0();
        SQLParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

