/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.messaging.selector;

import java.lang.reflect.Constructor;

public class NumericValue {
    Number value = null;
    String image = null;
    int imageType = 0;
    private static final int ByteValue = 0;
    private static final int ShortValue = 1;
    private static final int IntValue = 2;
    private static final int FloatValue = 3;
    static final int LongValue = 4;
    static final int DoubleValue = 5;
    private static String[] indexToTypeMap = new String[]{"java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Float", "java.lang.Long", "java.lang.Double"};
    private static final int[][] returnTypes = new int[][]{{0, 1, 2, 3, 4, 5}, {1, 1, 2, 3, 4, 5}, {2, 2, 2, 3, 4, 5}, {3, 3, 3, 3, 3, 5}, {4, 4, 4, 3, 4, 5}, {5, 5, 5, 5, 5, 5}};

    public NumericValue(Object obj) throws ClassCastException {
        if (this.value != null && !(obj instanceof Number)) {
            throw new ClassCastException();
        }
        if (obj instanceof NumericValue) {
            NumericValue n2 = (NumericValue)obj;
            this.value = n2.value;
            this.image = n2.image;
            this.imageType = n2.imageType;
        } else {
            this.value = (Number)obj;
        }
    }

    public NumericValue(String image, int imageType) {
        this.image = image;
        this.imageType = imageType;
        this.value = null;
    }

    public Number getValue() {
        if (this.value == null && this.image != null) {
            switch (this.imageType) {
                case 5: {
                    this.value = new Double(this.image);
                    break;
                }
                case 4: {
                    this.value = Long.decode(this.image);
                    break;
                }
            }
            this.image = null;
            this.imageType = -1;
        }
        return this.value;
    }

    private int getIndexForType(Number obj) {
        int index = -1;
        String typeName = obj.getClass().getName();
        if (typeName.equals("java.lang.Byte")) {
            index = 0;
        } else if (typeName.equals("java.lang.Short")) {
            index = 1;
        } else if (typeName.equals("java.lang.Integer")) {
            index = 2;
        } else if (typeName.equals("java.lang.Float")) {
            index = 3;
        } else if (typeName.equals("java.lang.Long")) {
            index = 4;
        } else if (typeName.equals("java.lang.Double")) {
            index = 5;
        }
        return index;
    }

    int getUnifiedTypeIndex(Number val1, Number val2) {
        int index = -1;
        if (val1 != null && val2 != null) {
            int index1 = this.getIndexForType(val1);
            int index2 = this.getIndexForType(val2);
            index = returnTypes[index1][index2];
        }
        return index;
    }

    private Number convertNumber(Number val, int typeIndex) {
        Number newVal = null;
        String newClassName = indexToTypeMap[typeIndex];
        try {
            Class<?> newClass = Class.forName(newClassName);
            Class[] paramTypes = new Class[]{Class.forName("java.lang.String")};
            Constructor<?> constr = newClass.getDeclaredConstructor(paramTypes);
            Object[] args = new Object[]{val.toString()};
            newVal = (Number)constr.newInstance(args);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return newVal;
    }

    public Number add(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = new Byte((byte)(val1.byteValue() + val2.byteValue()));
                    break;
                }
                case 1: {
                    result = new Short((short)(val1.shortValue() + val2.shortValue()));
                    break;
                }
                case 2: {
                    result = new Integer(val1.intValue() + val2.intValue());
                    break;
                }
                case 3: {
                    result = new Float(val1.floatValue() + val2.floatValue());
                    break;
                }
                case 4: {
                    result = new Long(val1.longValue() + val2.longValue());
                    break;
                }
                case 5: {
                    result = new Double(val1.doubleValue() + val2.doubleValue());
                    break;
                }
            }
        }
        return result;
    }

    public Number subtract(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = new Byte((byte)(val1.byteValue() - val2.byteValue()));
                    break;
                }
                case 1: {
                    result = new Short((short)(val1.shortValue() - val2.shortValue()));
                    break;
                }
                case 2: {
                    result = new Integer(val1.intValue() - val2.intValue());
                    break;
                }
                case 3: {
                    result = new Float(val1.floatValue() - val2.floatValue());
                    break;
                }
                case 4: {
                    result = new Long(val1.longValue() - val2.longValue());
                    break;
                }
                case 5: {
                    result = new Double(val1.doubleValue() - val2.doubleValue());
                    break;
                }
            }
        }
        return result;
    }

    public Number multiply(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = new Byte((byte)(val1.byteValue() * val2.byteValue()));
                    break;
                }
                case 1: {
                    result = new Short((short)(val1.shortValue() * val2.shortValue()));
                    break;
                }
                case 2: {
                    result = new Integer(val1.intValue() * val2.intValue());
                    break;
                }
                case 3: {
                    result = new Float(val1.floatValue() * val2.floatValue());
                    break;
                }
                case 4: {
                    result = new Long(val1.longValue() * val2.longValue());
                    break;
                }
                case 5: {
                    result = new Double(val1.doubleValue() * val2.doubleValue());
                    break;
                }
            }
        }
        return result;
    }

    public Number divide(NumericValue num) {
        Number result = null;
        if (this.getValue() != null && num != null) {
            Number value2 = num.getValue();
            int typeIndex = this.getUnifiedTypeIndex(this.value, value2);
            Number val1 = this.convertNumber(this.value, typeIndex);
            Number val2 = this.convertNumber(value2, typeIndex);
            switch (typeIndex) {
                case 0: {
                    result = new Byte((byte)(val1.byteValue() / val2.byteValue()));
                    break;
                }
                case 1: {
                    result = new Short((short)(val1.shortValue() / val2.shortValue()));
                    break;
                }
                case 2: {
                    result = new Integer(val1.intValue() / val2.intValue());
                    break;
                }
                case 3: {
                    result = new Float(val1.floatValue() / val2.floatValue());
                    break;
                }
                case 4: {
                    result = new Long(val1.longValue() / val2.longValue());
                    break;
                }
                case 5: {
                    result = new Double(val1.doubleValue() / val2.doubleValue());
                    break;
                }
            }
        }
        return result;
    }

    public Number negate() {
        Number result = null;
        if (this.image != null) {
            this.image = "-" + this.image;
            return this.getValue();
        }
        if (this.getValue() != null) {
            int typeIndex = this.getIndexForType(this.value);
            switch (typeIndex) {
                case 0: {
                    result = new Byte(-this.value.byteValue());
                    break;
                }
                case 1: {
                    result = new Short(-this.value.shortValue());
                    break;
                }
                case 2: {
                    result = new Integer(-this.value.intValue());
                    break;
                }
                case 3: {
                    result = new Float(-this.value.floatValue());
                    break;
                }
                case 4: {
                    result = new Long(-this.value.longValue());
                    break;
                }
                case 5: {
                    result = new Double(-this.value.doubleValue());
                    break;
                }
            }
        }
        return result;
    }

    public String toString() {
        String str = "null";
        if (this.getValue() != null) {
            str = this.value.toString();
        }
        return str;
    }

    public static void main(String[] args) {
        NumericValue num1 = new NumericValue(new Float(3.65));
        NumericValue num2 = new NumericValue(new Long(100L));
        System.err.println(num1 + "+" + num2 + " = " + num1.add(num2));
        System.err.println(num2 + "+" + num1 + " = " + num2.add(num1));
        System.err.println(num1 + "-" + num2 + " = " + num1.subtract(num2));
        System.err.println(num2 + "-" + num1 + " = " + num2.subtract(num1));
        System.err.println(num1 + "*" + num2 + " = " + num1.multiply(num2));
        System.err.println(num2 + "*" + num1 + " = " + num2.multiply(num1));
        System.err.println(num1 + "/" + num2 + " = " + num1.divide(num2));
        System.err.println(num2 + "/" + num1 + " = " + num2.divide(num1));
        System.err.println("-" + num1 + " = " + num1.negate());
        System.err.println("-" + num2 + " = " + num2.negate());
        System.exit(0);
    }
}

