/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessageExt;
import flex.messaging.messages.Message;
import flex.messaging.util.UUIDUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommandMessage
extends AsyncMessage {
    public static final String LOG_CATEGORY = "Message.Command";
    public static final int SUBSCRIBE_OPERATION = 0;
    public static final int UNSUBSCRIBE_OPERATION = 1;
    public static final int POLL_OPERATION = 2;
    public static final int CLIENT_SYNC_OPERATION = 4;
    public static final int CLIENT_PING_OPERATION = 5;
    public static final int CLUSTER_REQUEST_OPERATION = 7;
    public static final int LOGIN_OPERATION = 8;
    public static final int LOGOUT_OPERATION = 9;
    public static final int SUBSCRIPTION_INVALIDATE_OPERATION = 10;
    public static final int MULTI_SUBSCRIBE_OPERATION = 11;
    public static final int DISCONNECT_OPERATION = 12;
    public static final int TRIGGER_CONNECT_OPERATION = 13;
    public static final int UNKNOWN_OPERATION = 10000;
    public static final String MESSAGING_VERSION = "DSMessagingVersion";
    public static final String SELECTOR_HEADER = "DSSelector";
    public static final String SUBSCRIPTION_INVALIDATED_HEADER = "DSSubscriptionInvalidated";
    public static final String PRESERVE_DURABLE_HEADER = "DSPreserveDurable";
    public static final String NEEDS_CONFIG_HEADER = "DSNeedsConfig";
    public static final String ADD_SUBSCRIPTIONS = "DSAddSub";
    public static final String REMOVE_SUBSCRIPTIONS = "DSRemSub";
    public static final String SUBTOPIC_SEPARATOR = "_;_";
    public static final String POLL_WAIT_HEADER = "DSPollWait";
    public static final String NO_OP_POLL_HEADER = "DSNoOpPoll";
    public static final String SUPPRESS_POLL_WAIT_HEADER = "DSSuppressPollWait";
    public static final String CREDENTIALS_CHARSET_HEADER = "DSCredentialsCharset";
    private static byte OPERATION_FLAG = 1;
    private static final long serialVersionUID = -4026438615587526303L;
    static final String[] operationNames = new String[]{"subscribe", "unsubscribe", "poll", "unused3", "client_sync", "client_ping", "unused6", "cluster_request", "login", "logout", "subscription_invalidate", "multi_subscribe", "disconnect", "trigger_connect"};
    private int operation = 10000;

    public CommandMessage() {
        this.messageId = UUIDUtils.createUUID();
        this.timestamp = System.currentTimeMillis();
    }

    public CommandMessage(int operation) {
        this();
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public Message getSmallMessage() {
        if (this.operation == 2) {
            return new CommandMessageExt(this);
        }
        return null;
    }

    public static String operationToString(int operation) {
        if (operation < 0 || operation >= operationNames.length) {
            return "invalid." + operation + "";
        }
        return operationNames[operation];
    }

    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readExternal(input);
        short[] flagsArray = this.readFlags(input);
        for (int i2 = 0; i2 < flagsArray.length; ++i2) {
            short flags = flagsArray[i2];
            int reservedPosition = 0;
            if (i2 == 0) {
                if ((flags & OPERATION_FLAG) != 0) {
                    this.operation = ((Number)input.readObject()).intValue();
                }
                reservedPosition = 1;
            }
            if (flags >> reservedPosition == 0) continue;
            for (int j2 = reservedPosition; j2 < 6; j2 = (int)((short)(j2 + 1))) {
                if ((flags >> j2 & 1) == 0) continue;
                input.readObject();
            }
        }
    }

    protected String toStringFields(int indentLevel) {
        String sep = this.getFieldSeparator(indentLevel);
        String s2 = sep + "operation = " + CommandMessage.operationToString(this.operation);
        if (this.operation == 0) {
            s2 = s2 + sep + "selector = " + this.getHeader(SELECTOR_HEADER);
        }
        if (this.operation != 8) {
            s2 = s2 + super.toStringFields(indentLevel);
        } else {
            s2 = s2 + sep + "clientId =  " + this.clientId;
            s2 = s2 + sep + "destination =  " + this.destination;
            s2 = s2 + sep + "messageId =  " + this.messageId;
            s2 = s2 + sep + "timestamp =  " + this.timestamp;
            s2 = s2 + sep + "timeToLive =  " + this.timeToLive;
            s2 = s2 + sep + "***not printing credentials***";
        }
        return s2;
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        super.writeExternal(output);
        short flags = 0;
        if (this.operation != 0) {
            flags = (short)(flags | OPERATION_FLAG);
        }
        output.writeByte(flags);
        if (this.operation != 0) {
            output.writeObject(new Integer(this.operation));
        }
    }

    public String logCategory() {
        return "Message.Command." + CommandMessage.operationToString(this.operation);
    }
}

