/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.messages;

import flex.messaging.messages.AcknowledgeMessageExt;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.UUIDUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AcknowledgeMessage
extends AsyncMessage {
    private static final long serialVersionUID = 228072709981643313L;

    public AcknowledgeMessage() {
        this.messageId = UUIDUtils.createUUID(false);
        this.timestamp = System.currentTimeMillis();
    }

    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readExternal(input);
        short[] flagsArray = this.readFlags(input);
        for (int i2 = 0; i2 < flagsArray.length; ++i2) {
            short flags = flagsArray[i2];
            int reservedPosition = 0;
            if (flags >> reservedPosition == 0) continue;
            for (int j2 = reservedPosition; j2 < 6; j2 = (int)((short)(j2 + 1))) {
                if ((flags >> j2 & 1) == 0) continue;
                input.readObject();
            }
        }
    }

    public Message getSmallMessage() {
        if (this.getClass() == AcknowledgeMessage.class) {
            return new AcknowledgeMessageExt(this);
        }
        return null;
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        super.writeExternal(output);
        int flags = 0;
        output.writeByte(flags);
    }
}

