/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf.translator.decoder;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.translator.TranslationException;
import flex.messaging.io.amf.translator.decoder.ActionScriptDecoder;
import flex.messaging.io.amf.translator.decoder.DecoderFactory;
import flex.messaging.util.ClassUtil;
import java.util.List;

public class TypedObjectDecoder
extends ActionScriptDecoder {
    public boolean hasShell() {
        return true;
    }

    public Object createShell(Object encodedObject, Class desiredClass) {
        Class cls;
        Object shell = null;
        String type = TypeMarshallingContext.getType(encodedObject);
        if (type != null) {
            TypeMarshallingContext context = TypeMarshallingContext.getTypeMarshallingContext();
            cls = ClassUtil.createClass(type, context.getClassLoader());
        } else {
            cls = desiredClass;
        }
        shell = ClassUtil.createDefaultInstance(cls, null);
        return shell;
    }

    public Object decodeObject(Object shell, Object encodedObject, Class desiredClass) {
        Object bean = shell;
        if (bean == null) {
            return null;
        }
        return this.decodeTypedObject(bean, encodedObject);
    }

    protected Object decodeTypedObject(Object bean, Object encodedObject) {
        PropertyProxy beanProxy = PropertyProxyRegistry.getProxyAndRegister(bean);
        PropertyProxy encodedProxy = PropertyProxyRegistry.getProxyAndRegister(encodedObject);
        List propertyNames = beanProxy.getPropertyNames(bean);
        if (propertyNames != null) {
            for (String propName : propertyNames) {
                Class wClass = beanProxy.getType(bean, propName);
                Object value = encodedProxy.getValue(encodedObject, propName);
                Object decodedObject = null;
                try {
                    if (value != null) {
                        ActionScriptDecoder decoder = DecoderFactory.getDecoder(value, wClass);
                        decodedObject = decoder.decodeObject(value, wClass);
                    }
                    if (decodedObject == null && wClass.isPrimitive()) {
                        decodedObject = TypedObjectDecoder.getDefaultPrimitiveValue(wClass);
                    }
                    beanProxy.setValue(bean, propName, decodedObject);
                }
                catch (Exception e2) {
                    TranslationException ex = new TranslationException("Could not set object " + decodedObject + " on " + bean.getClass() + "'s " + propName);
                    ex.setCode("Server.Processing");
                    ex.setRootCause(e2);
                    throw ex;
                }
            }
        }
        return bean;
    }
}

