/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TraitsInfo {
    private final String className;
    private final boolean dynamic;
    private final boolean externalizable;
    private List properties;

    public TraitsInfo(String className) {
        this(className, false, false, 10);
    }

    public TraitsInfo(String className, int initialCount) {
        this(className, false, false, initialCount);
    }

    public TraitsInfo(String className, boolean dynamic, boolean externalizable, int initialCount) {
        this(className, dynamic, externalizable, new ArrayList(initialCount));
    }

    public TraitsInfo(String className, boolean dynamic, boolean externalizable, List properties) {
        if (className == null) {
            className = "";
        }
        this.className = className;
        if (properties == null) {
            properties = new ArrayList();
        }
        this.properties = properties;
        this.dynamic = dynamic;
        this.externalizable = externalizable;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    public int length() {
        return this.properties.size();
    }

    public String getClassName() {
        return this.className;
    }

    public void addProperty(String name) {
        this.properties.add(name);
    }

    public void addAllProperties(Collection props) {
        this.properties.addAll(props);
    }

    public String getProperty(int i2) {
        return (String)this.properties.get(i2);
    }

    public List getProperties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TraitsInfo) {
            TraitsInfo other = (TraitsInfo)obj;
            if (!this.className.equals(other.className)) {
                return false;
            }
            if (this.dynamic != other.dynamic) {
                return false;
            }
            List thisProperties = this.properties;
            List otherProperties = other.properties;
            if (thisProperties != otherProperties) {
                int thisCount = thisProperties.size();
                if (thisCount != otherProperties.size()) {
                    return false;
                }
                for (int i2 = 0; i2 < thisCount; ++i2) {
                    Object thisProp = thisProperties.get(i2);
                    Object otherProp = otherProperties.get(i2);
                    if (thisProp == null || otherProp == null || thisProp.equals(otherProp)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int c2 = this.className.hashCode();
        c2 = this.dynamic ? c2 << 2 : c2 << 1;
        return c2 |= this.properties.size() << 24;
    }
}

