/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.io.AbstractProxy;
import flex.messaging.io.ClassAliasRegistry;
import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.UnknownTypeException;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.AbstractAmfInput;
import flex.messaging.io.amf.Amf3Types;
import flex.messaging.io.amf.TraitsInfo;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.Trace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class Amf3Input
extends AbstractAmfInput
implements Amf3Types {
    protected List objectTable;
    protected List stringTable = new ArrayList(64);
    protected List traitsTable;

    public Amf3Input(SerializationContext context) {
        super(context);
        this.objectTable = new ArrayList(64);
        this.traitsTable = new ArrayList(10);
    }

    public void reset() {
        super.reset();
        this.stringTable.clear();
        this.objectTable.clear();
        this.traitsTable.clear();
    }

    public Object saveObjectTable() {
        List table = this.objectTable;
        this.objectTable = new ArrayList(64);
        return table;
    }

    public void restoreObjectTable(Object table) {
        this.objectTable = (ArrayList)table;
    }

    public Object saveTraitsTable() {
        List table = this.traitsTable;
        this.traitsTable = new ArrayList(10);
        return table;
    }

    public void restoreTraitsTable(Object table) {
        this.traitsTable = (ArrayList)table;
    }

    public Object saveStringTable() {
        List table = this.stringTable;
        this.stringTable = new ArrayList(64);
        return table;
    }

    public void restoreStringTable(Object table) {
        this.stringTable = (ArrayList)table;
    }

    public Object readObject() throws ClassNotFoundException, IOException {
        byte type = this.in.readByte();
        Object value = this.readObjectValue(type);
        return value;
    }

    protected Object readObjectValue(int type) throws ClassNotFoundException, IOException {
        Object value = null;
        switch (type) {
            case 6: {
                value = this.readString();
                if (!this.isDebug) break;
                this.trace.writeString((String)value);
                break;
            }
            case 10: {
                value = this.readScriptObject();
                break;
            }
            case 9: {
                value = this.readArray();
                break;
            }
            case 2: {
                value = Boolean.FALSE;
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 3: {
                value = Boolean.TRUE;
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 4: {
                int i2 = this.readUInt29();
                i2 = i2 << 3 >> 3;
                value = new Integer(i2);
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 5: {
                value = new Double(this.in.readDouble());
                if (!this.isDebug) break;
                this.trace.write(value);
                break;
            }
            case 0: {
                if (!this.isDebug) break;
                this.trace.writeUndefined();
                break;
            }
            case 1: {
                if (!this.isDebug) break;
                this.trace.writeNull();
                break;
            }
            case 7: 
            case 11: {
                value = this.readXml();
                break;
            }
            case 8: {
                value = this.readDate();
                if (!this.isDebug) break;
                this.trace.write(value.toString());
                break;
            }
            case 12: {
                value = this.readByteArray();
                break;
            }
            default: {
                UnknownTypeException ex = new UnknownTypeException();
                ex.setMessage(10301, new Object[]{new Integer(type)});
                throw ex;
            }
        }
        return value;
    }

    protected String readString() throws IOException {
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getStringReference(ref >> 1);
        }
        int len = ref >> 1;
        if (0 == len) {
            return "";
        }
        String str = this.readUTF(len);
        this.stringTable.add(str);
        return str;
    }

    protected Date readDate() throws IOException {
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return (Date)this.getObjectReference(ref >> 1);
        }
        long time = (long)this.in.readDouble();
        Date d2 = new Date(time);
        this.objectTable.add(d2);
        if (this.isDebug) {
            this.trace.write(d2);
        }
        return d2;
    }

    protected Object readArray() throws ClassNotFoundException, IOException {
        Object item;
        String name;
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getObjectReference(ref >> 1);
        }
        int len = ref >> 1;
        Object array = null;
        HashMap<String, Object> map = null;
        while ((name = this.readString()) != null && name.length() != 0) {
            if (map == null) {
                map = new HashMap<String, Object>();
                array = map;
                this.objectTable.add(array);
                if (this.isDebug) {
                    this.trace.startECMAArray(this.objectTable.size() - 1);
                }
            }
            Object value = this.readObject();
            map.put(name, value);
        }
        if (map == null) {
            if (this.context.legacyCollection) {
                ArrayList<Object> list = new ArrayList<Object>(len);
                array = list;
                this.objectTable.add(array);
                if (this.isDebug) {
                    this.trace.startAMFArray(this.objectTable.size() - 1);
                }
                for (int i2 = 0; i2 < len; ++i2) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i2);
                    }
                    Object item2 = this.readObject();
                    list.add(i2, item2);
                }
            } else {
                array = new Object[len];
                this.objectTable.add(array);
                if (this.isDebug) {
                    this.trace.startAMFArray(this.objectTable.size() - 1);
                }
                for (int i3 = 0; i3 < len; ++i3) {
                    if (this.isDebug) {
                        this.trace.arrayElement(i3);
                    }
                    item = this.readObject();
                    Array.set(array, i3, item);
                }
            }
        } else {
            for (int i4 = 0; i4 < len; ++i4) {
                if (this.isDebug) {
                    this.trace.arrayElement(i4);
                }
                item = this.readObject();
                map.put(Integer.toString(i4), item);
            }
        }
        if (this.isDebug) {
            this.trace.endAMFArray();
        }
        return array;
    }

    protected Object readScriptObject() throws ClassNotFoundException, IOException {
        Object newObj;
        Object object;
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return this.getObjectReference(ref >> 1);
        }
        TraitsInfo ti = this.readTraits(ref);
        String className = ti.getClassName();
        boolean externalizable = ti.isExternalizable();
        PropertyProxy proxy = null;
        String aliasedClass = ClassAliasRegistry.getRegistry().getClassName(className);
        if (aliasedClass != null) {
            className = aliasedClass;
        }
        if (className == null || className.length() == 0) {
            object = new ASObject();
        } else if (className.startsWith(">")) {
            object = new ASObject();
            ((ASObject)object).setType(className);
        } else if (this.context.instantiateTypes || className.startsWith("flex.")) {
            Class desiredClass = AbstractProxy.getClassFromClassName(className, this.context.createASObjectForMissingType);
            proxy = PropertyProxyRegistry.getRegistry().getProxyAndRegister(desiredClass);
            object = proxy == null ? ClassUtil.createDefaultInstance(desiredClass, null) : proxy.createInstance(className);
        } else {
            object = new ASObject();
            ((ASObject)object).setType(className);
        }
        if (proxy == null) {
            proxy = PropertyProxyRegistry.getProxyAndRegister(object);
        }
        int objectId = this.objectTable.size();
        this.objectTable.add(object);
        if (externalizable) {
            this.readExternalizable(className, object);
        } else {
            if (this.isDebug) {
                this.trace.startAMFObject(className, this.objectTable.size() - 1);
            }
            int len = ti.getProperties().size();
            for (int i2 = 0; i2 < len; ++i2) {
                String propName = ti.getProperty(i2);
                if (this.isDebug) {
                    this.trace.namedElement(propName);
                }
                Object value = this.readObject();
                proxy.setValue(object, propName, value);
            }
            if (ti.isDynamic()) {
                String name;
                while ((name = this.readString()) != null && name.length() != 0) {
                    if (this.isDebug) {
                        this.trace.namedElement(name);
                    }
                    Object value = this.readObject();
                    proxy.setValue(object, name, value);
                }
            }
        }
        if (this.isDebug) {
            this.trace.endAMFObject();
        }
        if ((newObj = proxy.instanceComplete(object)) != object) {
            this.objectTable.set(objectId, newObj);
            object = newObj;
        }
        return object;
    }

    protected void readExternalizable(String className, Object object) throws ClassNotFoundException, IOException {
        if (object instanceof Externalizable) {
            if (this.isDebug) {
                this.trace.startExternalizableObject(className, this.objectTable.size() - 1);
            }
        } else {
            SerializationException ex = new SerializationException();
            ex.setMessage(10305, new Object[]{object.getClass().getName()});
            throw ex;
        }
        ((Externalizable)object).readExternal(this);
    }

    protected byte[] readByteArray() throws IOException {
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            return (byte[])this.getObjectReference(ref >> 1);
        }
        int len = ref >> 1;
        byte[] ba2 = new byte[len];
        this.objectTable.add(ba2);
        this.in.readFully(ba2, 0, len);
        if (this.isDebug) {
            this.trace.startByteArray(this.objectTable.size() - 1, len);
        }
        return ba2;
    }

    protected TraitsInfo readTraits(int ref) throws IOException {
        if ((ref & 3) == 1) {
            return this.getTraitReference(ref >> 2);
        }
        boolean externalizable = (ref & 4) == 4;
        boolean dynamic = (ref & 8) == 8;
        int count = ref >> 4;
        String className = this.readString();
        TraitsInfo ti = new TraitsInfo(className, dynamic, externalizable, count);
        this.traitsTable.add(ti);
        for (int i2 = 0; i2 < count; ++i2) {
            String propName = this.readString();
            ti.addProperty(propName);
        }
        return ti;
    }

    protected String readUTF(int utflen) throws IOException {
        char[] charr = this.getTempCharArray(utflen);
        byte[] bytearr = this.getTempByteArray(utflen);
        int count = 0;
        int chCount = 0;
        this.in.readFully(bytearr, 0, utflen);
        while (count < utflen) {
            int c2 = bytearr[count] & 0xFF;
            switch (c2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    charr[chCount] = (char)c2;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charr[chCount] = (char)((c2 & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    charr[chCount] = (char)((c2 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
            ++chCount;
        }
        return new String(charr, 0, chCount);
    }

    protected int readUInt29() throws IOException {
        int b2 = this.in.readByte() & 0xFF;
        if (b2 < 128) {
            return b2;
        }
        int value = (b2 & 0x7F) << 7;
        b2 = this.in.readByte() & 0xFF;
        if (b2 < 128) {
            return value | b2;
        }
        value = (value | b2 & 0x7F) << 7;
        b2 = this.in.readByte() & 0xFF;
        if (b2 < 128) {
            return value | b2;
        }
        value = (value | b2 & 0x7F) << 8;
        b2 = this.in.readByte() & 0xFF;
        return value | b2;
    }

    protected Object readXml() throws IOException {
        String xml = null;
        int ref = this.readUInt29();
        if ((ref & 1) == 0) {
            xml = (String)this.getObjectReference(ref >> 1);
        } else {
            int len = ref >> 1;
            xml = 0 == len ? "" : this.readUTF(len);
            this.objectTable.add(xml);
            if (this.isDebug) {
                this.trace.write(xml);
            }
        }
        return this.stringToDocument(xml);
    }

    protected Object getObjectReference(int ref) {
        if (this.isDebug) {
            this.trace.writeRef(ref);
        }
        return this.objectTable.get(ref);
    }

    protected String getStringReference(int ref) {
        String str = (String)this.stringTable.get(ref);
        if (Trace.amf && this.isDebug) {
            this.trace.writeStringRef(ref);
        }
        return str;
    }

    protected TraitsInfo getTraitReference(int ref) {
        if (Trace.amf && this.isDebug) {
            this.trace.writeTraitsInfoRef(ref);
        }
        return (TraitsInfo)this.traitsTable.get(ref);
    }
}

