/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.PropertyProxyRegistry;
import flex.messaging.io.SerializationDescriptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;

public class ArrayCollection
extends ArrayList
implements Externalizable {
    private static final long serialVersionUID = 8037277879661457358L;
    private SerializationDescriptor descriptor = null;

    public ArrayCollection() {
    }

    public ArrayCollection(Collection c2) {
        super(c2);
    }

    public ArrayCollection(int initialCapacity) {
        super(initialCapacity);
    }

    public Object[] getSource() {
        return this.toArray();
    }

    public void setDescriptor(SerializationDescriptor desc) {
        this.descriptor = desc;
    }

    public void setSource(Object[] s2) {
        if (s2 != null) {
            if (this.size() > 0) {
                this.clear();
            }
            for (int i2 = 0; i2 < s2.length; ++i2) {
                this.add(s2[i2]);
            }
        } else {
            this.clear();
        }
    }

    public void setSource(Collection s2) {
        this.addAll(s2);
    }

    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        Object[] s2 = input.readObject();
        if (s2 instanceof Collection) {
            s2 = ((Collection)s2).toArray();
        }
        Object[] source = s2;
        this.setSource(source);
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        if (this.descriptor == null) {
            output.writeObject(this.getSource());
        } else {
            Object[] source = this.getSource();
            if (source == null) {
                output.writeObject(null);
            } else {
                for (int i2 = 0; i2 < source.length; ++i2) {
                    Object item = source[i2];
                    if (item == null) {
                        source[i2] = null;
                        continue;
                    }
                    PropertyProxy proxy = PropertyProxyRegistry.getProxy(item);
                    proxy = (PropertyProxy)proxy.clone();
                    proxy.setDescriptor(this.descriptor);
                    proxy.setDefaultInstance(item);
                    source[i2] = proxy;
                }
                output.writeObject(source);
            }
        }
    }
}

