/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.io.amf.ActionContext;
import java.io.IOException;

public abstract class SuspendableAMFFilter {
    public static final int DIRECTION_INBOUND = 0;
    public static final int DIRECTION_OUTBOUND = 1;
    protected boolean inboundAborted;
    protected ActionContext context;
    protected int direction = 0;
    protected SuspendableAMFFilter next;
    protected SuspendableAMFFilter previous;
    protected SuspendableAMFFilter suspendedFilter;

    public static SuspendableAMFFilter buildChain(SuspendableAMFFilter[] members) {
        if (members == null || members.length == 0) {
            throw new IllegalArgumentException();
        }
        int n2 = members.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                members[i2].setPrevious(members[i2 - 1]);
            }
            if (i2 >= n2 - 1) continue;
            members[i2].setNext(members[i2 + 1]);
        }
        return members[0];
    }

    public boolean isInboundAborted() {
        return this.inboundAborted;
    }

    public void setInboundAborted(boolean value) {
        this.inboundAborted = value;
    }

    public ActionContext getContext() {
        return this.context;
    }

    public void setContext(ActionContext value) {
        this.context = value;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int value) {
        this.direction = value;
    }

    public SuspendableAMFFilter getNext() {
        return this.next;
    }

    public void setNext(SuspendableAMFFilter value) {
        this.next = value;
    }

    public SuspendableAMFFilter getPrevious() {
        return this.previous;
    }

    public void setPrevious(SuspendableAMFFilter value) {
        this.previous = value;
    }

    public boolean isSuspended() {
        return this.getSuspendedFilter() != null;
    }

    public SuspendableAMFFilter getSuspendedFilter() {
        return this.suspendedFilter;
    }

    public void setSuspendedFilter(SuspendableAMFFilter value) {
        this.suspendedFilter = value;
    }

    public void invoke(ActionContext context) throws IOException {
        if (this.isSuspended()) {
            throw new IllegalStateException();
        }
        this.setContext(context);
        this.setDirection(0);
        this.executeChain(this, true);
    }

    public void resume() throws IOException {
        if (!this.isSuspended()) {
            throw new IllegalStateException();
        }
        SuspendableAMFFilter suspensionPoint = this.getSuspendedFilter();
        SuspendableAMFFilter chainMember = this;
        chainMember.setSuspendedFilter(null);
        while ((chainMember = chainMember.getPrevious()) != null) {
            chainMember.setSuspendedFilter(null);
        }
        chainMember = this;
        while ((chainMember = chainMember.getNext()) != null) {
            chainMember.setSuspendedFilter(null);
        }
        this.executeChain(suspensionPoint, true);
    }

    protected abstract void doInboundFilter(ActionContext var1) throws IOException;

    protected abstract void doOutboundFilter(ActionContext var1) throws IOException;

    protected void executeChain(SuspendableAMFFilter executionPoint, boolean executePreviousOutboundFilters) throws IOException {
        SuspendableAMFFilter completionPoint = !executePreviousOutboundFilters ? executionPoint : null;
        SuspendableAMFFilter previous = executionPoint;
        int direction = executionPoint.getDirection();
        if (direction == 0) {
            while (true) {
                previous = executionPoint;
                executionPoint.doInboundFilter(this.context);
                if (this.isSuspended()) {
                    return;
                }
                if (executionPoint.isInboundAborted()) {
                    executionPoint.setInboundAborted(false);
                    executionPoint.setDirection(1);
                    break;
                }
                executionPoint.setDirection(1);
                executionPoint = executionPoint.getNext();
                if (executionPoint == null) break;
                executionPoint.setContext(this.context);
                executionPoint.setDirection(0);
            }
        }
        if ((direction = previous.getDirection()) == 1) {
            do {
                previous.doOutboundFilter(this.context);
                if (this.isSuspended()) {
                    return;
                }
                if (previous != completionPoint) continue;
                return;
            } while ((previous = previous.getPrevious()) != null);
        }
    }

    protected void reinvoke() throws IOException {
        this.setDirection(0);
        this.executeChain(this, false);
    }

    protected void suspend() {
        if (this.isSuspended()) {
            throw new IllegalStateException();
        }
        SuspendableAMFFilter chainMember = this;
        chainMember.setSuspendedFilter(this);
        while ((chainMember = chainMember.getPrevious()) != null) {
            chainMember.setSuspendedFilter(this);
        }
        chainMember = this;
        while ((chainMember = chainMember.getNext()) != null) {
            chainMember.setSuspendedFilter(this);
        }
    }
}

