/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.FlexContext;
import flex.messaging.MessageException;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationException;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceInfo;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.List;
import javax.servlet.ServletInputStream;

public class SerializationFilter
extends AMFFilter {
    private static final int UNHANDLED_ERROR = 10306;
    private static final int REQUEST_ERROR = 10307;
    private static final int RESPONSE_ERROR = 10308;
    private boolean isDebug = Log.isDebug();
    private Logger logger;

    public SerializationFilter(String logCategory) {
        if (logCategory == null) {
            logCategory = "Endpoint.General";
        }
        this.logger = Log.getLogger(logCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(ActionContext context) throws IOException {
        ActionMessage respMesg2;
        ByteArrayOutputStream outBuffer2;
        SerializationContext sc2;
        AmfTrace debugTrace;
        block44: {
            block43: {
                boolean success;
                block42: {
                    success = false;
                    debugTrace = this.isDebug ? new AmfTrace() : null;
                    context.setResponseMessage(new ActionMessage());
                    sc2 = SerializationContext.getSerializationContext();
                    try {
                        try {
                            MessageDeserializer deserializer = sc2.newMessageDeserializer();
                            ServletInputStream in = FlexContext.getHttpRequest().getInputStream();
                            deserializer.initialize(sc2, (InputStream)in, debugTrace);
                            int reqLen = FlexContext.getHttpRequest().getContentLength();
                            context.setDeserializedBytes(reqLen);
                            if (context.isMPIenabled()) {
                                MessagePerformanceInfo mpi = new MessagePerformanceInfo();
                                mpi.recordMessageSizes = context.isRecordMessageSizes();
                                mpi.recordMessageTimes = context.isRecordMessageTimes();
                                if (context.isRecordMessageTimes()) {
                                    mpi.receiveTime = System.currentTimeMillis();
                                }
                                if (context.isRecordMessageSizes()) {
                                    mpi.messageSize = reqLen;
                                }
                                context.setMPII(mpi);
                            }
                            ActionMessage m2 = new ActionMessage();
                            context.setRequestMessage(m2);
                            deserializer.readMessage(m2, context);
                            success = true;
                        }
                        catch (EOFException eof) {
                            context.setStatus(2);
                            Object var10_14 = null;
                            ActionMessage respMsg = context.getResponseMessage();
                            respMsg.setVersion(context.getVersion());
                            if (this.isDebug) {
                                this.logger.debug(debugTrace.toString());
                            }
                            break block42;
                        }
                        catch (IOException exc) {
                            if (!this.isDebug) throw exc;
                            this.logger.debug("IOException reading message - client closed socket before sending the message?");
                            throw exc;
                        }
                        catch (Throwable t2) {
                            this.deserializationError(context, t2);
                            Object var10_15 = null;
                            ActionMessage respMsg = context.getResponseMessage();
                            respMsg.setVersion(context.getVersion());
                            if (this.isDebug) {
                                this.logger.debug(debugTrace.toString());
                            }
                        }
                        Object var10_13 = null;
                        ActionMessage respMsg = context.getResponseMessage();
                        respMsg.setVersion(context.getVersion());
                        if (this.isDebug) {
                            this.logger.debug(debugTrace.toString());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        ActionMessage respMsg = context.getResponseMessage();
                        respMsg.setVersion(context.getVersion());
                        if (!this.isDebug) throw throwable;
                        this.logger.debug(debugTrace.toString());
                        throw throwable;
                    }
                }
                if (!success) break block43;
                this.next.invoke(context);
            }
            Object var13_22 = null;
            if (context.getStatus() == 2) return;
            outBuffer2 = new ByteArrayOutputStream();
            respMesg2 = context.getResponseMessage();
            if (!this.isDebug) break block44;
            debugTrace = new AmfTrace();
        }
        try {
            try {
                block45: {
                    long serializationOverhead = 0L;
                    if (context.isRecordMessageTimes()) {
                        context.getMPIO().sendTime = System.currentTimeMillis();
                        if (context.isRecordMessageSizes()) {
                            serializationOverhead = System.currentTimeMillis();
                        }
                    }
                    MessageSerializer serializer = sc2.newMessageSerializer();
                    serializer.initialize(sc2, outBuffer2, debugTrace);
                    serializer.writeMessage(respMesg2);
                    context.setSerializedBytes(outBuffer2.size());
                    if (context.isRecordMessageSizes()) {
                        try {
                            context.getMPIO().messageSize = outBuffer2.size();
                            if (context.isRecordMessageTimes()) {
                                serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                context.getMPIO().addToOverhead(serializationOverhead);
                                context.getMPIO().sendTime = System.currentTimeMillis();
                            }
                            outBuffer2 = new ByteArrayOutputStream();
                            respMesg2 = context.getResponseMessage();
                            serializer = sc2.newMessageSerializer();
                            serializer.initialize(sc2, outBuffer2, debugTrace);
                            serializer.writeMessage(respMesg2);
                        }
                        catch (Exception e2) {
                            if (!this.isDebug) break block45;
                            this.logger.debug("MPI set up error: " + e2.toString());
                        }
                    }
                }
                context.setResponseOutput(outBuffer2);
            }
            catch (Exception e3) {
                this.serializationError(context, e3);
                Object var21_44 = null;
                if (!this.isDebug) return;
                this.logger.debug(debugTrace.toString());
                return;
            }
            Object var21_43 = null;
            if (!this.isDebug) return;
            this.logger.debug(debugTrace.toString());
            return;
        }
        catch (Throwable throwable) {
            Object var21_45 = null;
            if (!this.isDebug) throw throwable;
            this.logger.debug(debugTrace.toString());
            throw throwable;
        }
        {
            catch (Throwable t3) {
                this.unhandledError(context, t3);
                Object var13_23 = null;
                if (context.getStatus() == 2) return;
                ByteArrayOutputStream outBuffer2 = new ByteArrayOutputStream();
                ActionMessage respMesg2 = context.getResponseMessage();
                if (this.isDebug) {
                    debugTrace = new AmfTrace();
                }
                try {
                    try {
                        block46: {
                            long serializationOverhead = 0L;
                            if (context.isRecordMessageTimes()) {
                                context.getMPIO().sendTime = System.currentTimeMillis();
                                if (context.isRecordMessageSizes()) {
                                    serializationOverhead = System.currentTimeMillis();
                                }
                            }
                            MessageSerializer serializer = sc2.newMessageSerializer();
                            serializer.initialize(sc2, outBuffer2, debugTrace);
                            serializer.writeMessage(respMesg2);
                            context.setSerializedBytes(outBuffer2.size());
                            if (context.isRecordMessageSizes()) {
                                try {
                                    context.getMPIO().messageSize = outBuffer2.size();
                                    if (context.isRecordMessageTimes()) {
                                        serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                        context.getMPIO().addToOverhead(serializationOverhead);
                                        context.getMPIO().sendTime = System.currentTimeMillis();
                                    }
                                    outBuffer2 = new ByteArrayOutputStream();
                                    respMesg2 = context.getResponseMessage();
                                    serializer = sc2.newMessageSerializer();
                                    serializer.initialize(sc2, outBuffer2, debugTrace);
                                    serializer.writeMessage(respMesg2);
                                }
                                catch (Exception e2) {
                                    if (!this.isDebug) break block46;
                                    this.logger.debug("MPI set up error: " + e2.toString());
                                }
                            }
                        }
                        context.setResponseOutput(outBuffer2);
                    }
                    catch (Exception e3) {
                        this.serializationError(context, e3);
                        Object var21_47 = null;
                        if (!this.isDebug) return;
                        this.logger.debug(debugTrace.toString());
                        return;
                    }
                    Object var21_46 = null;
                    if (!this.isDebug) return;
                    this.logger.debug(debugTrace.toString());
                    return;
                }
                catch (Throwable throwable) {
                    Object var21_48 = null;
                    if (!this.isDebug) throw throwable;
                    this.logger.debug(debugTrace.toString());
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_24 = null;
            if (context.getStatus() == 2) throw throwable;
            ByteArrayOutputStream outBuffer2 = new ByteArrayOutputStream();
            ActionMessage respMesg2 = context.getResponseMessage();
            if (this.isDebug) {
                debugTrace = new AmfTrace();
            }
            try {
                try {
                    block47: {
                        long serializationOverhead = 0L;
                        if (context.isRecordMessageTimes()) {
                            context.getMPIO().sendTime = System.currentTimeMillis();
                            if (context.isRecordMessageSizes()) {
                                serializationOverhead = System.currentTimeMillis();
                            }
                        }
                        MessageSerializer serializer = sc2.newMessageSerializer();
                        serializer.initialize(sc2, outBuffer2, debugTrace);
                        serializer.writeMessage(respMesg2);
                        context.setSerializedBytes(outBuffer2.size());
                        if (context.isRecordMessageSizes()) {
                            try {
                                context.getMPIO().messageSize = outBuffer2.size();
                                if (context.isRecordMessageTimes()) {
                                    serializationOverhead = System.currentTimeMillis() - serializationOverhead;
                                    context.getMPIO().addToOverhead(serializationOverhead);
                                    context.getMPIO().sendTime = System.currentTimeMillis();
                                }
                                outBuffer2 = new ByteArrayOutputStream();
                                respMesg2 = context.getResponseMessage();
                                serializer = sc2.newMessageSerializer();
                                serializer.initialize(sc2, outBuffer2, debugTrace);
                                serializer.writeMessage(respMesg2);
                            }
                            catch (Exception e2) {
                                if (!this.isDebug) break block47;
                                this.logger.debug("MPI set up error: " + e2.toString());
                            }
                        }
                    }
                    context.setResponseOutput(outBuffer2);
                }
                catch (Exception e3) {
                    this.serializationError(context, e3);
                    Object var21_50 = null;
                    if (!this.isDebug) throw throwable;
                    this.logger.debug(debugTrace.toString());
                    throw throwable;
                }
                Object var21_49 = null;
                if (!this.isDebug) throw throwable;
                this.logger.debug(debugTrace.toString());
                throw throwable;
            }
            catch (Throwable throwable2) {
                Object var21_51 = null;
                if (!this.isDebug) throw throwable2;
                this.logger.debug(debugTrace.toString());
                throw throwable2;
            }
        }
    }

    private void deserializationError(ActionContext context, Throwable t2) {
        String message;
        MessageException methodResult;
        context.setStatus(1);
        MessageBody responseBody = new MessageBody();
        if (context.getMessageNumber() < context.getRequestMessage().getBodyCount()) {
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        }
        if (context.getVersion() == 0) {
            context.setVersion(3);
        }
        context.getResponseMessage().addBody(responseBody);
        if (t2 instanceof MessageException) {
            methodResult = (MessageException)t2;
            message = methodResult.getMessage();
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10307);
            methodResult.setRootCause(t2);
            message = methodResult.getMessage();
        }
        responseBody.setData(methodResult.createErrorMessage());
        responseBody.setReplyMethod("/onStatus");
        if (Log.isError()) {
            this.logger.error(message + StringUtils.NEWLINE + ExceptionUtil.toString(t2));
        }
    }

    private void unhandledError(ActionContext context, Throwable t2) {
        MessageException methodResult;
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        MessageBody responseBody = new MessageBody();
        responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
        context.getResponseMessage().addBody(responseBody);
        if (t2 instanceof MessageException) {
            methodResult = (MessageException)t2;
        } else {
            methodResult = new SerializationException();
            methodResult.setMessage(10306);
            methodResult.setRootCause(t2);
        }
        responseBody.setData(methodResult);
        responseBody.setReplyMethod("/onStatus");
        this.logger.info(t2.getMessage());
    }

    private void serializationError(ActionContext context, Throwable t2) {
        ActionMessage responseMessage = new ActionMessage();
        context.setResponseMessage(responseMessage);
        int bodyCount = context.getRequestMessage().getBodyCount();
        context.setMessageNumber(0);
        while (context.getMessageNumber() < bodyCount) {
            Object methodResult;
            MessageBody responseBody = new MessageBody();
            responseBody.setTargetURI(context.getRequestMessageBody().getResponseURI());
            context.getResponseMessage().addBody(responseBody);
            if (t2 instanceof MessageException) {
                methodResult = ((MessageException)t2).createErrorMessage();
            } else {
                String message = "An error occurred while serializing server response(s).";
                if (t2.getMessage() != null && (message = t2.getMessage()) == null) {
                    message = t2.toString();
                }
                methodResult = new MessageException(message, t2).createErrorMessage();
            }
            if (context.isLegacy()) {
                if (methodResult instanceof ErrorMessage) {
                    ErrorMessage error = methodResult;
                    ASObject aso = new ASObject();
                    aso.put("message", error.faultString);
                    aso.put("code", error.faultCode);
                    aso.put("details", error.faultDetail);
                    aso.put("rootCause", error.rootCause);
                    methodResult = aso;
                } else if (methodResult instanceof Message) {
                    methodResult = ((Message)methodResult).getBody();
                }
            } else {
                Object data = context.getRequestMessageBody().getData();
                if (data instanceof List) {
                    data = ((List)data).get(0);
                } else if (data.getClass().isArray()) {
                    data = Array.get(data, 0);
                }
                if (data instanceof Message) {
                    Message inMessage = (Message)data;
                    if (inMessage.getClientId() != null) {
                        ((ErrorMessage)methodResult).setClientId(inMessage.getClientId().toString());
                    }
                    if (inMessage.getMessageId() != null) {
                        ((ErrorMessage)methodResult).setCorrelationId(inMessage.getMessageId());
                        ((ErrorMessage)methodResult).setDestination(inMessage.getDestination());
                    }
                }
            }
            responseBody.setData(methodResult);
            responseBody.setReplyMethod("/onStatus");
            context.incrementMessageNumber();
        }
        if (Log.isError()) {
            this.logger.error("Exception occurred during serialization: " + ExceptionUtil.toString(t2));
        }
        SerializationContext sc2 = SerializationContext.getSerializationContext();
        MessageSerializer serializer = sc2.newMessageSerializer();
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        AmfTrace debugTrace = this.isDebug ? new AmfTrace() : null;
        serializer.initialize(sc2, outBuffer, debugTrace);
        try {
            serializer.writeMessage(context.getResponseMessage());
            context.setResponseOutput(outBuffer);
        }
        catch (IOException e2) {
            MessageException ex = new MessageException();
            ex.setMessage(10308);
            ex.setRootCause(e2);
            throw ex;
        }
    }
}

