/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints;

import flex.management.runtime.messaging.endpoints.EndpointControl;
import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.HttpFlexSession;
import flex.messaging.MessageClient;
import flex.messaging.client.FlexClient;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.DuplicateSessionException;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.SettingsReplaceUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseHTTPEndpoint
extends AbstractEndpoint {
    private static final String ADD_NO_CACHE_HEADERS = "add-no-cache-headers";
    private static final String REDIRECT_URL = "redirect-url";
    private static final String INVALIDATE_SESSION_ON_DISCONNECT = "invalidate-session-on-disconnect";
    private static final int ERR_MSG_DUPLICATE_SESSIONS_DETECTED = 10035;
    private static final String REQUEST_ATTR_DUPLICATE_SESSION_FLAG = "flex.messaging.request.DuplicateSessionDetected";
    protected EndpointControl controller;
    protected AMFFilter filterChain;
    protected boolean addNoCacheHeaders = true;
    protected boolean loginAfterDisconnect;
    protected boolean invalidateSessionOnDisconnect;
    protected String redirectURL;

    public BaseHTTPEndpoint() {
        this(false);
    }

    public BaseHTTPEndpoint(boolean enableManagement) {
        super(enableManagement);
    }

    public void initialize(String id2, ConfigMap properties) {
        super.initialize(id2, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.addNoCacheHeaders = properties.getPropertyAsBoolean(ADD_NO_CACHE_HEADERS, true);
        this.redirectURL = properties.getPropertyAsString(REDIRECT_URL, null);
        this.invalidateSessionOnDisconnect = properties.getPropertyAsBoolean(INVALIDATE_SESSION_ON_DISCONNECT, false);
        this.loginAfterDisconnect = properties.getPropertyAsBoolean("login-after-disconnect", false);
        this.validateEndpointProtocol();
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        this.filterChain = this.createFilterChain();
    }

    public boolean isAddNoCacheHeaders() {
        return this.addNoCacheHeaders;
    }

    public void setAddNoCacheHeaders(boolean addNoCacheHeaders) {
        this.addNoCacheHeaders = addNoCacheHeaders;
    }

    public boolean isInvalidateSessionOnDisconnect() {
        return this.invalidateSessionOnDisconnect;
    }

    public void setInvalidateSessionOnDisconnect(boolean value) {
        this.invalidateSessionOnDisconnect = value;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest req, HttpServletResponse res) {
        super.service(req, res);
        try {
            try {
                this.setThreadLocals();
                ActionContext context = new ActionContext();
                context.setRecordMessageSizes(this.isRecordMessageSizes());
                context.setRecordMessageTimes(this.isRecordMessageTimes());
                this.filterChain.invoke(context);
                if (this.isManaged()) {
                    this.controller.addToBytesDeserialized(context.getDeserializedBytes());
                    this.controller.addToBytesSerialized(context.getSerializedBytes());
                }
                if (context.getStatus() != 2) {
                    if (this.addNoCacheHeaders) {
                        BaseHTTPEndpoint.addNoCacheHeaders(req, res);
                    }
                    ByteArrayOutputStream outBuffer = context.getResponseOutput();
                    res.setContentType(this.getResponseContentType());
                    res.setContentLength(outBuffer.size());
                    outBuffer.writeTo((OutputStream)res.getOutputStream());
                    res.flushBuffer();
                } else if (this.redirectURL != null) {
                    try {
                        this.redirectURL = SettingsReplaceUtil.replaceContextPath(this.redirectURL, req.getContextPath());
                        res.sendRedirect(this.redirectURL);
                    }
                    catch (IllegalStateException alreadyFlushed) {
                    }
                }
                Object var6_8 = null;
            }
            catch (IOException ioe) {
                this.log.info(ioe.getMessage());
                Object var6_9 = null;
                this.clearThreadLocals();
                return;
            }
            catch (Throwable t2) {
                this.log.error(t2.getMessage(), t2);
                Object var6_10 = null;
                this.clearThreadLocals();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.clearThreadLocals();
            throw throwable;
        }
        this.clearThreadLocals();
    }

    public ConfigMap describeEndpoint() {
        ConfigMap endpointConfig = super.describeEndpoint();
        boolean createdProperties = false;
        ConfigMap properties = endpointConfig.getPropertyAsMap("properties", null);
        if (properties == null) {
            properties = new ConfigMap();
            createdProperties = true;
        }
        if (this.loginAfterDisconnect) {
            ConfigMap loginAfterDisconnect = new ConfigMap();
            loginAfterDisconnect.addProperty("", "true");
            properties.addProperty("login-after-disconnect", loginAfterDisconnect);
        }
        if (createdProperties && properties.size() > 0) {
            endpointConfig.addProperty("properties", properties);
        }
        return endpointConfig;
    }

    public FlexClient setupFlexClient(String id2) {
        List sessions;
        int n2;
        boolean duplicateSessionDetected;
        FlexClient flexClient = super.setupFlexClient(id2);
        boolean bl = duplicateSessionDetected = FlexContext.getHttpRequest().getAttribute(REQUEST_ATTR_DUPLICATE_SESSION_FLAG) != null;
        if (!duplicateSessionDetected && (n2 = (sessions = flexClient.getFlexSessions()).size()) > 1) {
            int count = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (sessions.get(i2) instanceof HttpFlexSession) {
                    ++count;
                }
                if (count <= 1) continue;
                FlexContext.getHttpRequest().setAttribute(REQUEST_ATTR_DUPLICATE_SESSION_FLAG, (Object)Boolean.TRUE);
                duplicateSessionDetected = true;
                break;
            }
        }
        if (duplicateSessionDetected) {
            sessions = flexClient.getFlexSessions();
            for (FlexSession session : sessions) {
                if (!(session instanceof HttpFlexSession)) continue;
                session.invalidate();
            }
            DuplicateSessionException e2 = new DuplicateSessionException();
            e2.setMessage(10035);
            throw e2;
        }
        return flexClient;
    }

    protected abstract AMFFilter createFilterChain();

    protected abstract String getResponseContentType();

    protected Message handleChannelDisconnect(CommandMessage disconnectCommand) {
        HttpFlexSession session = (HttpFlexSession)FlexContext.getFlexSession();
        FlexClient flexClient = FlexContext.getFlexClient();
        if (flexClient.isValid()) {
            String endpointId = this.getId();
            List messageClients = flexClient.getMessageClients();
            for (MessageClient messageClient : messageClients) {
                if (!messageClient.getEndpointId().equals(endpointId)) continue;
                messageClient.setClientChannelDisconnected(true);
                messageClient.invalidate();
            }
        }
        if (session.isValid() && this.isInvalidateSessionOnDisconnect()) {
            session.invalidate(false);
        }
        return super.handleChannelDisconnect(disconnectCommand);
    }

    protected void validateEndpointProtocol() {
        if (this.isSecure() && !this.url.startsWith("https:")) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11100, new Object[]{this.url, "https"});
            throw ce;
        }
    }
}

