/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.LocalizedException;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import flex.messaging.config.ConfigurationManager;
import flex.messaging.config.ConfigurationParser;
import flex.messaging.config.LocalFileResolver;
import flex.messaging.config.MessagingConfiguration;
import flex.messaging.config.ServletResourceResolver;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.Trace;
import java.io.File;
import javax.servlet.ServletConfig;

public class FlexConfigurationManager
implements ConfigurationManager {
    static final String DEFAULT_CONFIG_PATH = "/WEB-INF/flex/services-config.xml";
    protected String configurationPath = null;
    protected ConfigurationFileResolver configurationResolver = null;
    protected ConfigurationParser parser = null;

    public MessagingConfiguration getMessagingConfiguration(ServletConfig servletConfig) {
        MessagingConfiguration config = new MessagingConfiguration();
        if (servletConfig != null) {
            String serverInfo = servletConfig.getServletContext().getServerInfo();
            config.getSecuritySettings().setServerInfo(serverInfo);
        }
        this.verifyMinimumJavaVersion();
        this.parser = this.getConfigurationParser(servletConfig);
        if (this.parser == null) {
            LocalizedException lme = new LocalizedException();
            lme.setMessage(10138);
            throw lme;
        }
        this.setupConfigurationPathAndResolver(servletConfig);
        this.parser.parse(this.configurationPath, this.configurationResolver, config);
        if (servletConfig != null) {
            config.getSystemSettings().setPaths(servletConfig.getServletContext());
        }
        return config;
    }

    public void reportTokens() {
        this.parser.reportTokens();
    }

    protected ConfigurationParser getConfigurationParser(ServletConfig servletConfig) {
        ConfigurationParser parser;
        block12: {
            String className;
            Class parserClass;
            block11: {
                block10: {
                    String p2;
                    parser = null;
                    parserClass = null;
                    className = null;
                    if (servletConfig != null && (p2 = servletConfig.getInitParameter("services.configuration.parser")) != null) {
                        className = p2.trim();
                        try {
                            parserClass = ClassUtil.createClass(className);
                            parser = (ConfigurationParser)parserClass.newInstance();
                        }
                        catch (Throwable t2) {
                            if (!Trace.config) break block10;
                            Trace.trace("Could not load configuration parser as: " + className);
                        }
                    }
                }
                if (parser == null) {
                    try {
                        ClassUtil.createClass("org.apache.xpath.CachedXPathAPI");
                        className = "flex.messaging.config.ApacheXPathServerConfigurationParser";
                        parserClass = ClassUtil.createClass(className);
                        parser = (ConfigurationParser)parserClass.newInstance();
                    }
                    catch (Throwable t3) {
                        if (!Trace.config) break block11;
                        Trace.trace("Could not load configuration parser as: " + className);
                    }
                }
            }
            if (parser == null) {
                try {
                    className = "flex.messaging.config.XPathServerConfigurationParser";
                    parserClass = ClassUtil.createClass(className);
                    ClassUtil.createClass("javax.xml.xpath.XPathExpressionException");
                    parser = (ConfigurationParser)parserClass.newInstance();
                }
                catch (Throwable t4) {
                    if (!Trace.config) break block12;
                    Trace.trace("Could not load configuration parser as: " + className);
                }
            }
        }
        if (Trace.config && parser != null) {
            Trace.trace("Services Configuration Parser: " + parser.getClass().getName());
        }
        return parser;
    }

    protected void setupConfigurationPathAndResolver(ServletConfig servletConfig) {
        if (servletConfig != null) {
            String p2 = servletConfig.getInitParameter("services.configuration.file");
            if (p2 == null || p2.trim().length() == 0) {
                this.configurationPath = DEFAULT_CONFIG_PATH;
                this.configurationResolver = new ServletResourceResolver(servletConfig.getServletContext());
            } else {
                ServletResourceResolver resolver;
                boolean available;
                boolean isServletResource;
                this.configurationPath = p2.trim();
                boolean isWindows = File.separator.equals("\\");
                boolean bl = isServletResource = isWindows && this.configurationPath.startsWith("/");
                this.configurationResolver = isServletResource || !isWindows ? ((available = (resolver = new ServletResourceResolver(servletConfig.getServletContext())).isAvailable(this.configurationPath, isServletResource)) ? resolver : new LocalFileResolver(LocalFileResolver.SERVER)) : new LocalFileResolver(LocalFileResolver.SERVER);
            }
        } else {
            this.configurationPath = DEFAULT_CONFIG_PATH;
            this.configurationResolver = new ServletResourceResolver(servletConfig.getServletContext());
        }
    }

    protected void verifyMinimumJavaVersion() throws ConfigurationException {
        block18: {
            try {
                boolean minimum = false;
                String version = System.getProperty("java.version");
                String vendor = System.getProperty("java.vendor");
                version = version.replace('.', ':');
                version = version.replace('_', ':');
                String[] split = version.split(":");
                int first = Integer.parseInt(split[0]);
                if (first > 1) {
                    minimum = true;
                } else if (first == 1) {
                    int second = Integer.parseInt(split[1]);
                    if (second > 4) {
                        minimum = true;
                    } else if (second == 4) {
                        int third = Integer.parseInt(split[2]);
                        if (third > 2) {
                            minimum = true;
                        } else if (third == 2) {
                            if (vendor != null && vendor.indexOf("Sun") != -1) {
                                int fourth = Integer.parseInt(split[3]);
                                if (fourth >= 6) {
                                    minimum = true;
                                }
                            } else {
                                minimum = true;
                            }
                        }
                    }
                }
                if (!minimum) {
                    ConfigurationException cx = new ConfigurationException();
                    if (vendor != null && vendor.indexOf("Sun") != -1) {
                        cx.setMessage(10139, new Object[]{System.getProperty("java.version")});
                    } else {
                        cx.setMessage(10140, new Object[]{System.getProperty("java.version")});
                    }
                    throw cx;
                }
            }
            catch (Throwable t2) {
                if (t2 instanceof ConfigurationException) {
                    throw (ConfigurationException)t2;
                }
                if (!Trace.config) break block18;
                Trace.trace("Could not verified required java version. version=" + System.getProperty("java.version"));
            }
        }
    }
}

