/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import flex.management.ManageableComponent;
import flex.management.runtime.messaging.MessageBrokerControl;
import flex.management.runtime.messaging.log.LogManager;
import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.FlexFactory;
import flex.messaging.FlexRemoteCredentials;
import flex.messaging.FlexSession;
import flex.messaging.MessageClient;
import flex.messaging.MessageException;
import flex.messaging.Server;
import flex.messaging.ServiceValidationListener;
import flex.messaging.SessionMetricsTracker;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlexClientManager;
import flex.messaging.cluster.ClusterManager;
import flex.messaging.config.ChannelSettings;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.config.SecuritySettings;
import flex.messaging.config.SystemSettings;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.factories.JavaFactory;
import flex.messaging.log.Log;
import flex.messaging.messages.AbstractMessage;
import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import flex.messaging.security.LoginManager;
import flex.messaging.security.SecurityException;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceException;
import flex.messaging.util.Base64;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.RedeployManager;
import flex.messaging.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public final class MessageBroker
extends ManageableComponent {
    public static final String LOG_CATEGORY = "Message.General";
    public static final String LOG_CATEGORY_STARTUP_SERVICE = "Startup.Service";
    public static final String TYPE = "MessageBroker";
    private static final String LOG_MANAGER_ID = "log";
    private static final int NULL_ENDPOINT_URL = 10128;
    private static final int SERVICE_TYPE_EXISTS = 11113;
    private static final int NO_SERVICE_FOR_DEST = 10004;
    private static final int SERVICE_CMD_NOT_SUPPORTED = 10451;
    private static final int DESTINATION_UNACCESSIBLE = 10005;
    private static final int UNKNOWN_REMOTE_CREDENTIALS_FORMAT = 10020;
    private static final int URI_ALREADY_REGISTERED = 11109;
    private static final int NULL_MESSAGE_ID = 10029;
    private static final Integer INTEGER_ONE = new Integer(1);
    private InternalPathResolver internalPathResolver;
    private Map attributes;
    private Map endpoints;
    private Map services;
    private Map servers;
    private Map factories;
    private Map registeredEndpoints;
    private ClusterManager clusterManager;
    private Map destinationToService;
    private FlexClientManager flexClientManager;
    private LoginManager loginManager;
    private RedeployManager redeployManager;
    private Map channelSettings;
    private List defaultChannels;
    private SecuritySettings securitySettings;
    private SessionMetricsTracker sessionMetricsTracker;
    private FlexClientSettings flexClientSettings;
    private static ThreadLocal systemSettingsThreadLocal = new ThreadLocal();
    private SystemSettings systemSettings;
    private ServletContext initServletContext;
    private final ConcurrentHashMap serviceValidationListeners = new ConcurrentHashMap();
    private ClassLoader classLoader;
    private Log log;
    private LogManager logManager;
    static final String DEFAULT_BROKER_ID = "__default__";
    static Map messageBrokers = new HashMap();
    private MessageBrokerControl controller;
    private Map attributeIdRefCounts = new HashMap();

    public MessageBroker() {
        this(true, null);
    }

    public MessageBroker(boolean enableManagement) {
        this(enableManagement, null);
    }

    public MessageBroker(boolean enableManagement, String mbid) {
        this(enableManagement, mbid, MessageBroker.class.getClassLoader());
    }

    public MessageBroker(boolean enableManagement, String mbid, ClassLoader loader) {
        super(enableManagement);
        this.classLoader = loader;
        this.attributes = new ConcurrentHashMap();
        this.destinationToService = new HashMap();
        this.endpoints = new LinkedHashMap();
        this.services = new LinkedHashMap();
        this.servers = new LinkedHashMap();
        this.factories = new HashMap();
        this.registeredEndpoints = new HashMap();
        this.addFactory("java", new JavaFactory());
        this.setId(mbid);
        this.log = Log.createLog();
        this.clusterManager = new ClusterManager(this);
        this.systemSettings = new SystemSettings();
        systemSettingsThreadLocal.set(this.systemSettings);
        this.clusterManager = new ClusterManager(this);
        this.sessionMetricsTracker = new SessionMetricsTracker(this);
        if (this.isManaged()) {
            this.controller = new MessageBrokerControl(this);
            this.controller.register();
            this.setControl(this.controller);
            this.logManager = new LogManager();
            this.logManager.setLog(this.log);
            this.logManager.setParent(this);
            this.logManager.setupLogControl();
            this.logManager.initialize(LOG_MANAGER_ID, null);
        }
        this.flexClientManager = new FlexClientManager(this.isManaged(), this);
    }

    public void setId(String id2) {
        if (id2 == null) {
            id2 = DEFAULT_BROKER_ID;
        }
        super.setId(id2);
    }

    public static MessageBroker getMessageBroker(String id2) {
        if (id2 == null) {
            id2 = DEFAULT_BROKER_ID;
        }
        return (MessageBroker)messageBrokers.get(id2);
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (Log.isDebug()) {
            StringBuffer sb2 = new StringBuffer();
            if (this.classLoader == MessageBroker.class.getClassLoader()) {
                sb2.append(" the MessageBroker's class loader");
            }
            if (this.classLoader == Thread.currentThread().getContextClassLoader()) {
                if (sb2.length() > 0) {
                    sb2.append(" and");
                }
                sb2.append(" the context class loader");
            }
            if (sb2.length() == 0) {
                sb2.append(" not the context or the message broker's class loader");
            }
            Log.getLogger("Configuration").debug("MessageBroker id: " + this.getId() + " classLoader is:" + sb2.toString() + " (" + "classLoader " + ClassUtil.classLoaderToString(this.classLoader));
        }
        try {
            this.setStarted(true);
            this.registerMessageBroker();
            this.sessionMetricsTracker.start();
            this.flexClientManager.start();
            this.startServices();
            this.loginManager.start();
            this.startEndpoints();
            this.startServers();
            this.redeployManager.start();
        }
        catch (Exception e2) {
            if (Log.isError()) {
                Log.getLogger("Configuration").error("MessageBroker failed to start: " + ExceptionUtil.exceptionFollowedByRootCausesToString(e2));
            }
            RuntimeException re = new RuntimeException(e2.getMessage(), e2);
            throw re;
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        if (Log.isDebug()) {
            Log.getLogger("Configuration").debug("MessageBroker stopping: " + this.getId());
        }
        this.serviceValidationListeners.clear();
        this.sessionMetricsTracker.stop();
        this.flexClientManager.stop();
        this.stopServers();
        this.stopEndpoints();
        FlexContext.setThreadLocalObjects(null, null, this);
        this.stopServices();
        FlexContext.setThreadLocalObjects(null, null, null);
        if (this.loginManager != null) {
            this.loginManager.stop();
        }
        try {
            if (this.redeployManager != null) {
                this.redeployManager.stop();
            }
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        this.clusterManager.destroyClusters();
        super.stop();
        this.unRegisterMessageBroker();
        this.systemSettings.clear();
        this.systemSettings = null;
        systemSettingsThreadLocal.remove();
        if (Log.isDebug()) {
            Log.getLogger("Configuration").debug("MessageBroker stopped: " + this.getId());
        }
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setInternalPathResolver(InternalPathResolver internalPathResolver) {
        this.internalPathResolver = internalPathResolver;
    }

    public InputStream resolveInternalPath(String filename) throws IOException {
        return this.internalPathResolver.resolve(filename);
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void addServer(Server server) {
        if (server == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11110, new Object[]{"Server", TYPE});
            throw ex;
        }
        String id2 = server.getId();
        if (id2 == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{"Server", TYPE});
            throw ex;
        }
        Server currentServer = this.getServer(id2);
        if (currentServer == server) {
            return;
        }
        if (currentServer != null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11112, new Object[]{"Server", id2, TYPE});
            throw ex;
        }
        this.servers.put(id2, server);
    }

    public Server getServer(String id2) {
        return (Server)this.servers.get(id2);
    }

    public Server removeServer(String id2) {
        Server server = (Server)this.servers.get(id2);
        if (server != null) {
            server.stop();
            this.servers.remove(id2);
        }
        return server;
    }

    public Endpoint createEndpoint(String id2, String url, String className) {
        Class endpointClass = ClassUtil.createClass(className, this.getClassLoader());
        Endpoint endpoint = (Endpoint)ClassUtil.createDefaultInstance(endpointClass, Endpoint.class);
        endpoint.setId(id2);
        endpoint.setUrl(url);
        endpoint.setManaged(this.isManaged());
        endpoint.setMessageBroker(this);
        return endpoint;
    }

    public void addEndpoint(Endpoint endpoint) {
        if (endpoint == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11110, new Object[]{"Endpoint", TYPE});
            throw ex;
        }
        String id2 = endpoint.getId();
        if (id2 == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{"Endpoint", TYPE});
            throw ex;
        }
        if (this.getEndpoint(id2) == endpoint) {
            return;
        }
        if (this.getEndpoint(id2) != null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11112, new Object[]{"Endpoint", id2, TYPE});
            throw ex;
        }
        this.checkEndpointUrl(id2, endpoint.getUrl());
        this.endpoints.put(id2, endpoint);
    }

    private void checkEndpointUrl(String id2, String endpointUrl) {
        if (endpointUrl == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(10128, new Object[]{"Endpoint", TYPE});
            throw ex;
        }
        String parsedEndpointURI = ChannelSettings.removeTokens(endpointUrl);
        if (this.registeredEndpoints.containsKey(parsedEndpointURI)) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11109, new Object[]{id2, parsedEndpointURI, this.registeredEndpoints.get(parsedEndpointURI)});
            throw ce;
        }
        this.registeredEndpoints.put(parsedEndpointURI, id2);
        int nextSlash = parsedEndpointURI.indexOf(47, 1);
        if (nextSlash > 0) {
            String parsedEndpointURI2 = parsedEndpointURI.substring(nextSlash);
            if (this.registeredEndpoints.containsKey(parsedEndpointURI2)) {
                ConfigurationException ce = new ConfigurationException();
                ce.setMessage(11109, new Object[]{parsedEndpointURI2, id2, this.registeredEndpoints.get(parsedEndpointURI2)});
                throw ce;
            }
            this.registeredEndpoints.put(parsedEndpointURI2, id2);
        }
    }

    public Endpoint getEndpoint(String id2) {
        return (Endpoint)this.endpoints.get(id2);
    }

    public Map getEndpoints() {
        return this.endpoints;
    }

    public Endpoint getEndpoint(String path, String contextPath) {
        for (Object id2 : this.endpoints.keySet()) {
            Endpoint e2 = (Endpoint)this.endpoints.get(id2);
            if (!this.matchEndpoint(path, contextPath, e2)) continue;
            return e2;
        }
        MessageException lme = new MessageException();
        lme.setMessage(10003, new Object[]{path});
        throw lme;
    }

    public Endpoint removeEndpoint(String id2) {
        Endpoint endpoint = this.getEndpoint(id2);
        if (endpoint != null) {
            endpoint.stop();
            this.endpoints.remove(id2);
        }
        return endpoint;
    }

    private boolean matchEndpoint(String path, String contextPath, Endpoint endpoint) {
        boolean match = false;
        String channelEndpoint = endpoint.getParsedUrl(contextPath);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.equalsIgnoreCase(channelEndpoint)) {
            match = true;
        }
        return match;
    }

    public FlexFactory getFactory(String id2) {
        return (FlexFactory)this.factories.get(id2);
    }

    public Map getFactories() {
        return this.factories;
    }

    public void addFactory(String id2, FlexFactory factory) {
        if (id2 == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{"FlexFactory", TYPE});
            throw ex;
        }
        if (this.getFactory(id2) == factory) {
            return;
        }
        if (this.getFactory(id2) != null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11112, new Object[]{"FlexFactory", id2, TYPE});
            throw ex;
        }
        this.factories.put(id2, factory);
    }

    public FlexFactory removeFactory(String id2) {
        FlexFactory factory = this.getFactory(id2);
        if (factory != null) {
            this.factories.remove(id2);
        }
        return factory;
    }

    public Service getService(String id2) {
        return (Service)this.services.get(id2);
    }

    public Service getServiceByType(String type) {
        for (Service svc : this.services.values()) {
            if (!svc.getClass().getName().equals(type)) continue;
            return svc;
        }
        return null;
    }

    public Map getServices() {
        return this.services;
    }

    public ConfigMap describeServices(Endpoint endpoint) {
        if (!this.serviceValidationListeners.isEmpty()) {
            Enumeration iter = this.serviceValidationListeners.elements();
            while (iter.hasMoreElements()) {
                ((ServiceValidationListener)iter.nextElement()).validateServices();
            }
        }
        ConfigMap servicesConfig = new ConfigMap();
        ArrayList<String> channelIds = new ArrayList<String>();
        channelIds.add(endpoint.getId());
        if (this.defaultChannels != null) {
            ConfigMap defaultChannelsMap = new ConfigMap();
            for (String id2 : this.defaultChannels) {
                ConfigMap channelConfig = new ConfigMap();
                channelConfig.addProperty("ref", id2);
                defaultChannelsMap.addProperty("channel", channelConfig);
                if (channelIds.contains(id2)) continue;
                channelIds.add(id2);
            }
            if (defaultChannelsMap.size() > 0) {
                servicesConfig.addProperty("default-channels", defaultChannelsMap);
            }
        }
        for (Service service : this.services.values()) {
            ConfigMap serviceConfig = service.describeService(endpoint);
            if (serviceConfig == null || serviceConfig.size() <= 0) continue;
            servicesConfig.addProperty("service", serviceConfig);
        }
        ConfigMap channels = new ConfigMap();
        for (String id2 : channelIds) {
            Endpoint currentEndpoint = this.getEndpoint(id2);
            ConfigMap channel = currentEndpoint.describeEndpoint();
            if (channel.size() <= 0) continue;
            channels.addProperty("channel", channel);
        }
        if (channels.size() > 0) {
            servicesConfig.addProperty("channels", channels);
        }
        if (Log.isDebug()) {
            Log.getLogger("Configuration").debug("Returning service description for endpoint: " + endpoint + " config: " + servicesConfig);
        }
        return servicesConfig;
    }

    public void addServiceValidationListener(String id2, ServiceValidationListener listener) {
        if (listener != null) {
            this.serviceValidationListeners.putIfAbsent((Object)id2, (Object)listener);
        }
    }

    public void removeServiceValidationListener(String id2) {
        if (this.serviceValidationListeners.containsKey((Object)id2)) {
            this.serviceValidationListeners.remove((Object)id2);
        }
    }

    public Service createService(String id2, String className) {
        Class svcClass = ClassUtil.createClass(className, this.getClassLoader());
        Service service = (Service)ClassUtil.createDefaultInstance(svcClass, Service.class);
        service.setId(id2);
        service.setManaged(this.isManaged());
        service.setMessageBroker(this);
        return service;
    }

    public void addService(Service service) {
        if (service == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11110, new Object[]{"Service", TYPE});
            throw ex;
        }
        String id2 = service.getId();
        if (id2 == null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11111, new Object[]{"Service", TYPE});
            throw ex;
        }
        if (this.getService(id2) == service) {
            return;
        }
        if (this.getService(id2) != null) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11112, new Object[]{"Service", id2, TYPE});
            throw ex;
        }
        String type = service.getClass().getName();
        if (this.getServiceByType(type) != null) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(11113, new Object[]{type});
            throw ce;
        }
        this.services.put(id2, service);
        if (service.getMessageBroker() == null || service.getMessageBroker() != this) {
            service.setMessageBroker(this);
        }
    }

    public Service removeService(String id2) {
        Service service = this.getService(id2);
        if (service != null) {
            service.stop();
            this.services.remove(id2);
        }
        return service;
    }

    public Log getLog() {
        return this.log;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public void setLoginManager(LoginManager loginManager) {
        if (this.loginManager != null && this.loginManager.isStarted()) {
            this.loginManager.stop();
        }
        this.loginManager = loginManager;
        if (this.isStarted()) {
            loginManager.start();
        }
    }

    public FlexClientManager getFlexClientManager() {
        return this.flexClientManager;
    }

    public void setFlexClientManager(FlexClientManager value) {
        this.flexClientManager = value;
    }

    public RedeployManager getRedeployManager() {
        return this.redeployManager;
    }

    public void setRedeployManager(RedeployManager redeployManager) {
        if (this.redeployManager != null && this.redeployManager.isStarted()) {
            this.redeployManager.stop();
        }
        this.redeployManager = redeployManager;
        if (this.isStarted()) {
            redeployManager.start();
        }
    }

    public List getChannelIds() {
        return this.endpoints == null || this.endpoints.size() == 0 ? null : new ArrayList(this.endpoints.keySet());
    }

    public ChannelSettings getChannelSettings(String ref) {
        return (ChannelSettings)this.channelSettings.get(ref);
    }

    public Map getAllChannelSettings() {
        return this.channelSettings;
    }

    public void setChannelSettings(Map channelSettings) {
        this.channelSettings = channelSettings;
    }

    public List getDefaultChannels() {
        return this.defaultChannels;
    }

    public void addDefaultChannel(String id2) {
        if (this.defaultChannels == null) {
            this.defaultChannels = new ArrayList();
        } else if (this.defaultChannels.contains(id2)) {
            return;
        }
        List channelIds = this.getChannelIds();
        if (channelIds == null || !channelIds.contains(id2)) {
            if (Log.isWarn()) {
                Log.getLogger(LOG_CATEGORY).warn("No channel with id '{0}' is known by the MessageBroker. Not adding the channel.", new Object[]{id2});
            }
            return;
        }
        this.defaultChannels.add(id2);
    }

    public void setDefaultChannels(List ids) {
        if (ids != null) {
            List channelIds = this.getChannelIds();
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                String id2 = (String)iter.next();
                if (channelIds != null && channelIds.contains(id2)) continue;
                iter.remove();
                if (!Log.isWarn()) continue;
                Log.getLogger(LOG_CATEGORY).warn("No channel with id '{0}' is known by the MessageBroker. Not adding the channel.", new Object[]{id2});
            }
        }
        this.defaultChannels = ids;
    }

    public boolean removeDefaultChannel(String id2) {
        if (this.defaultChannels == null) {
            return false;
        }
        return this.defaultChannels.remove(id2);
    }

    public SecurityConstraint getSecurityConstraint(String ref) {
        return this.getSecuritySettings().getConstraint(ref);
    }

    public ServletContext getInitServletContext() {
        return this.initServletContext;
    }

    protected void setInitServletContext(ServletContext initServletContext) {
        this.initServletContext = initServletContext;
    }

    public SecuritySettings getSecuritySettings() {
        return this.securitySettings;
    }

    public void setSecuritySettings(SecuritySettings securitySettings) {
        this.securitySettings = securitySettings;
    }

    public SystemSettings getLocalSystemSettings() {
        return this.systemSettings;
    }

    public static SystemSettings getSystemSettings() {
        SystemSettings ss = (SystemSettings)systemSettingsThreadLocal.get();
        if (ss == null) {
            ss = new SystemSettings();
            systemSettingsThreadLocal.set(ss);
        }
        return ss;
    }

    public void setSystemSettings(SystemSettings l2) {
        if (l2 != null) {
            systemSettingsThreadLocal.set(l2);
            this.systemSettings = l2;
        }
    }

    public void clearSystemSettingsThreadLocal() {
        systemSettingsThreadLocal.remove();
    }

    public static void releaseThreadLocalObjects() {
        systemSettingsThreadLocal = null;
    }

    public static void createThreadLocalObjects() {
        if (systemSettingsThreadLocal == null) {
            systemSettingsThreadLocal = new ThreadLocal();
        }
    }

    public FlexClientSettings getFlexClientSettings() {
        return this.flexClientSettings;
    }

    public void setFlexClientSettings(FlexClientSettings value) {
        this.flexClientSettings = value;
    }

    public void initThreadLocals() {
        this.setSystemSettings(this.systemSettings);
    }

    private void startServers() {
        Iterator iter = this.servers.entrySet().iterator();
        while (iter.hasNext()) {
            Server server = (Server)iter.next().getValue();
            server.start();
        }
    }

    private void stopServers() {
        Iterator iter = this.servers.entrySet().iterator();
        while (iter.hasNext()) {
            Server server = (Server)iter.next().getValue();
            server.stop();
        }
    }

    private void startEndpoints() {
        for (Endpoint endpoint : this.endpoints.values()) {
            endpoint.start();
        }
    }

    private void stopEndpoints() {
        for (Endpoint endpoint : this.endpoints.values()) {
            endpoint.stop();
        }
    }

    private void startServices() {
        for (Service svc : this.services.values()) {
            long timeBeforeStartup = 0L;
            if (Log.isDebug()) {
                timeBeforeStartup = System.currentTimeMillis();
                Log.getLogger(LOG_CATEGORY_STARTUP_SERVICE).debug("Service with id '{0}' is starting.", new Object[]{svc.getId()});
            }
            svc.start();
            if (!Log.isDebug()) continue;
            long timeAfterStartup = System.currentTimeMillis();
            Long diffMillis = new Long(timeAfterStartup - timeBeforeStartup);
            Log.getLogger(LOG_CATEGORY_STARTUP_SERVICE).debug("Service with id '{0}' is ready (startup time: '{1}' ms)", new Object[]{svc.getId(), diffMillis});
        }
    }

    private void stopServices() {
        for (Service svc : this.services.values()) {
            svc.stop();
        }
    }

    public AcknowledgeMessage routeMessageToService(Message message, Endpoint endpoint) {
        this.checkMessageId(message);
        Object serviceResult = null;
        boolean serviced = false;
        Service service = null;
        String destId = message.getDestination();
        try {
            String serviceId = (String)this.destinationToService.get(destId);
            if (serviceId == null && destId != null && !this.serviceValidationListeners.isEmpty()) {
                Enumeration iter = this.serviceValidationListeners.elements();
                while (iter.hasMoreElements()) {
                    ((ServiceValidationListener)iter.nextElement()).validateDestination(destId);
                }
                serviceId = (String)this.destinationToService.get(destId);
            }
            if (serviceId != null) {
                service = (Service)this.services.get(serviceId);
                serviced = true;
                Destination destination = service.getDestination(destId);
                this.inspectOperation(message, destination);
                if (message.headerExists("DSValidateEndpoint")) {
                    message.getHeaders().remove("DSValidateEndpoint");
                }
                if (Log.isDebug()) {
                    Log.getLogger(this.getLogCategory(message)).debug("Before invoke service: " + service.getId() + StringUtils.NEWLINE + "  incomingMessage: " + message + StringUtils.NEWLINE);
                }
                this.extractRemoteCredentials(service, message);
                serviceResult = service.serviceMessage(message);
            }
            if (!serviced) {
                MessageException lme = new MessageException();
                lme.setMessage(10004, new Object[]{destId});
                throw lme;
            }
            if (Log.isDebug()) {
                String debugServiceResult = Log.getPrettyPrinter().prettify(serviceResult);
                Log.getLogger(this.getLogCategory(message)).debug("After invoke service: " + service.getId() + StringUtils.NEWLINE + "  reply: " + debugServiceResult + StringUtils.NEWLINE);
            }
            AcknowledgeMessage ack = null;
            if (serviceResult instanceof AcknowledgeMessage) {
                ack = (AcknowledgeMessage)serviceResult;
            } else {
                ack = new AcknowledgeMessage();
                ack.setBody(serviceResult);
            }
            ack.setCorrelationId(message.getMessageId());
            ack.setClientId(message.getClientId());
            return ack;
        }
        catch (MessageException exc) {
            exc.logAtHingePoint(message, null, "Exception when invoking service '" + (service == null ? "(none)" : service.getId()) + "': ");
            throw exc;
        }
        catch (RuntimeException exc) {
            Log.getLogger(LOG_CATEGORY).error("Exception when invoking service: " + (service == null ? "(none)" : service.getId()) + StringUtils.NEWLINE + "  with message: " + message + StringUtils.NEWLINE + ExceptionUtil.exceptionFollowedByRootCausesToString(exc) + StringUtils.NEWLINE);
            throw exc;
        }
        catch (Error exc) {
            Log.getLogger(LOG_CATEGORY).error("Error when invoking service: " + (service == null ? "(none)" : service.getId()) + StringUtils.NEWLINE + "  with message: " + message + StringUtils.NEWLINE + ExceptionUtil.exceptionFollowedByRootCausesToString(exc) + StringUtils.NEWLINE);
            throw exc;
        }
    }

    public AsyncMessage routeCommandToService(CommandMessage command, Endpoint endpoint) {
        this.checkMessageId(command);
        String destId = command.getDestination();
        AsyncMessage replyMessage = null;
        Service service = null;
        String serviceId = null;
        Object commandResult = null;
        boolean serviced = false;
        serviceId = command.getOperation() == 8 || command.getOperation() == 9 ? "authentication-service" : (String)this.destinationToService.get(destId);
        service = (Service)this.services.get(serviceId);
        if (service != null) {
            Destination destination = service.getDestination(destId);
            if (destination != null) {
                this.inspectOperation(command, destination);
            }
            try {
                this.extractRemoteCredentials(service, command);
                commandResult = service.serviceCommand(command);
                serviced = true;
            }
            catch (UnsupportedOperationException e2) {
                ServiceException se = new ServiceException();
                se.setMessage(10451, new Object[]{service.getClass().getName()});
                throw se;
            }
            catch (SecurityException se) {
                if (serviceId.equals("authentication-service")) {
                    commandResult = se.createErrorMessage();
                    if (Log.isDebug()) {
                        Log.getLogger(LOG_CATEGORY).debug("Security error for message: " + se.toString() + StringUtils.NEWLINE + "  incomingMessage: " + command + StringUtils.NEWLINE + "  errorReply: " + commandResult);
                    }
                    serviced = true;
                }
                throw se;
            }
        }
        if (commandResult == null) {
            replyMessage = new AcknowledgeMessage();
        } else if (commandResult instanceof AsyncMessage) {
            replyMessage = (AsyncMessage)commandResult;
        } else {
            replyMessage = new AcknowledgeMessage();
            replyMessage.setBody(commandResult);
        }
        if (command.getOperation() == 5 || command.getOperation() == 8) {
            FlexClient flexClient;
            double msgVersion;
            ConfigMap serverConfig;
            boolean needsConfig = false;
            if (command.getHeader("DSNeedsConfig") != null) {
                needsConfig = (Boolean)command.getHeader("DSNeedsConfig");
            }
            if (needsConfig && (serverConfig = this.describeServices(endpoint)).size() > 0) {
                replyMessage.setBody(serverConfig);
            }
            if ((msgVersion = endpoint.getMessagingVersion()) > 0.0) {
                replyMessage.setHeader("DSMessagingVersion", new Double(msgVersion));
            }
            if ((flexClient = FlexContext.getFlexClient()) != null) {
                replyMessage.setHeader("DSId", flexClient.getId());
            }
        } else if (!serviced) {
            MessageException lme = new MessageException();
            lme.setMessage(10004, new Object[]{destId});
            throw lme;
        }
        replyMessage.setCorrelationId(command.getMessageId());
        replyMessage.setClientId(command.getClientId());
        if (replyMessage.getBody() instanceof List) {
            replyMessage.setBody(((List)replyMessage.getBody()).toArray());
        }
        if (Log.isDebug()) {
            Log.getLogger(this.getLogCategory(command)).debug("Executed command: " + (service == null ? "(default service)" : "service=" + service.getId()) + StringUtils.NEWLINE + "  commandMessage: " + command + StringUtils.NEWLINE + "  replyMessage: " + replyMessage + StringUtils.NEWLINE);
        }
        return replyMessage;
    }

    public void routeMessageToMessageClient(Message message, MessageClient messageClient) {
        this.checkMessageId(message);
        FlexClient requestFlexClient = FlexContext.getFlexClient();
        FlexSession requestFlexSession = FlexContext.getFlexSession();
        FlexClient pushFlexClient = messageClient.getFlexClient();
        FlexContext.setThreadLocalFlexClient(pushFlexClient);
        FlexContext.setThreadLocalSession(null);
        pushFlexClient.push(message, messageClient);
        FlexContext.setThreadLocalFlexClient(requestFlexClient);
        FlexContext.setThreadLocalSession(requestFlexSession);
    }

    private void checkMessageId(Message message) {
        if (message.getMessageId() == null) {
            MessageException lme = new MessageException();
            lme.setMessage(10029);
            throw lme;
        }
    }

    public void inspectOperation(Message message, Destination destination) {
        this.inspectChannel(message, destination);
        this.loginManager.checkConstraint(destination.getSecurityConstraint());
    }

    public void inspectChannel(Message message, Destination destination) {
        if (message.getHeader("DSValidateEndpoint") != null) {
            String messageChannel = (String)message.getHeader("DSEndpoint");
            for (String channelId : destination.getChannels()) {
                if (!channelId.equals(messageChannel)) continue;
                return;
            }
            MessageException lme = new MessageException();
            lme.setMessage(10005, new Object[]{destination.getId(), messageChannel});
            throw lme;
        }
    }

    protected void extractRemoteCredentials(Service service, Message message) {
        if (message.headerExists("DSRemoteCredentials")) {
            boolean setting = false;
            String username = null;
            String credentials = null;
            if (message.getHeader("DSRemoteCredentials") instanceof String) {
                String encoded = (String)message.getHeader("DSRemoteCredentials");
                if (encoded.length() > 0) {
                    setting = true;
                    Base64.Decoder decoder = new Base64.Decoder();
                    decoder.decode(encoded);
                    byte[] decodedBytes = decoder.drain();
                    String decoded = "";
                    String charset = (String)message.getHeader("DSRemoteCredentialsCharset");
                    if (charset != null) {
                        try {
                            decoded = new String(decodedBytes, charset);
                        }
                        catch (UnsupportedEncodingException ex) {
                            MessageException lme = new MessageException();
                            lme.setMessage(10020);
                            throw lme;
                        }
                    } else {
                        decoded = new String(decodedBytes);
                    }
                    int colon = decoded.indexOf(":");
                    if (colon > 0 && colon < decoded.length() - 1) {
                        username = decoded.substring(0, colon);
                        credentials = decoded.substring(colon + 1);
                    }
                }
            } else {
                MessageException lme = new MessageException();
                lme.setMessage(10020);
                throw lme;
            }
            if (setting) {
                FlexContext.getFlexSession().putRemoteCredentials(new FlexRemoteCredentials(service.getId(), message.getDestination(), username, credentials));
            } else {
                FlexContext.getFlexSession().clearRemoteCredentials(service.getId(), message.getDestination());
            }
        }
    }

    public String getLogCategory(Message message) {
        if (message instanceof AbstractMessage) {
            return ((AbstractMessage)message).logCategory();
        }
        return LOG_CATEGORY;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void registerDestination(String destId, String svcId) {
        if (this.destinationToService.containsKey(destId)) {
            ConfigurationException ex = new ConfigurationException();
            ex.setMessage(11119, new Object[]{destId, svcId, this.destinationToService.get(destId)});
            throw ex;
        }
        this.destinationToService.put(destId, svcId);
    }

    public void unregisterDestination(String destId) {
        this.destinationToService.remove(destId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMessageBroker() {
        String mbid = this.getId();
        Map map = messageBrokers;
        synchronized (map) {
            if (messageBrokers.get(mbid) != null) {
                ConfigurationException ce = new ConfigurationException();
                ce.setMessage(10137, new Object[]{this.getId() == null ? "(no value supplied)" : mbid});
                throw ce;
            }
            messageBrokers.put(mbid, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterMessageBroker() {
        String mbid = this.getId();
        Map map = messageBrokers;
        synchronized (map) {
            messageBrokers.remove(mbid);
        }
    }

    protected String getLogCategory() {
        return LOG_CATEGORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementAttributeIdRefCount(String attributeId) {
        Map map = this.attributeIdRefCounts;
        synchronized (map) {
            Integer currentCount = (Integer)this.attributeIdRefCounts.get(attributeId);
            if (currentCount == null) {
                this.attributeIdRefCounts.put(attributeId, INTEGER_ONE);
            } else {
                this.attributeIdRefCounts.put(attributeId, new Integer(currentCount + 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrementAttributeIdRefCount(String attributeId) {
        Map map = this.attributeIdRefCounts;
        synchronized (map) {
            Integer currentCount = (Integer)this.attributeIdRefCounts.get(attributeId);
            if (currentCount == null) {
                return 0;
            }
            int newValue = currentCount - 1;
            this.attributeIdRefCounts.put(attributeId, new Integer(newValue));
            return newValue;
        }
    }

    public static interface InternalPathResolver {
        public InputStream resolve(String var1) throws IOException;
    }
}

