/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.Destination;
import flex.messaging.DestructibleFlexFactory;
import flex.messaging.FactoryInstance;
import flex.messaging.FlexFactory;
import flex.messaging.MessageBroker;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;

public abstract class FactoryDestination
extends Destination {
    private static final String FACTORY = "factory";
    private static final String DEFAULT_FACTORY = "java";
    private static int INVALID_FACTORY = 11103;
    private static int FACTORY_CANNOT_BE_RETURNED = 11118;
    private FlexFactory factory;
    private String source;
    private String scope = "request";
    private String factoryId = "java";
    private FactoryInstance factoryInstance;
    private ConfigMap factoryProperties;

    public FactoryDestination() {
        this(false);
    }

    public FactoryDestination(boolean enableManagement) {
        super(enableManagement);
    }

    public void initialize(String id2, ConfigMap properties) {
        super.initialize(id2, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.factoryProperties = properties;
        this.factoryId = properties.getPropertyAsString(FACTORY, this.factoryId);
        this.scope = properties.getPropertyAsString("scope", this.scope);
        this.source = properties.getPropertyAsString("source", this.source);
        if (this.source == null) {
            this.source = this.getId();
        }
    }

    protected void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
        if (this.factory == null) {
            MessageBroker broker;
            FlexFactory f2;
            if (this.factoryId == null) {
                this.factoryId = DEFAULT_FACTORY;
            }
            if ((f2 = (broker = this.getService().getMessageBroker()).getFactory(this.factoryId)) == null) {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(INVALID_FACTORY, new Object[]{this.getId(), this.factoryId});
                throw ex;
            }
            this.factory = f2;
        }
        if (this.scope == null) {
            this.scope = "request";
        }
        if (this.source == null) {
            this.source = this.getId();
        }
    }

    public FlexFactory getFactory() {
        if (this.factory == null) {
            if (this.factoryId == null) {
                this.factoryId = DEFAULT_FACTORY;
            }
            if (this.getService() == null) {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(FACTORY_CANNOT_BE_RETURNED, new Object[]{"Service"});
                throw ex;
            }
            if (this.getService().getMessageBroker() == null) {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(FACTORY_CANNOT_BE_RETURNED, new Object[]{"MessageBroker"});
                throw ex;
            }
            MessageBroker broker = this.getService().getMessageBroker();
            FlexFactory f2 = broker.getFactory(this.factoryId);
            if (f2 == null) {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(INVALID_FACTORY, new Object[]{this.getId(), this.factoryId});
                throw ex;
            }
            this.factory = f2;
        }
        return this.factory;
    }

    public void setFactory(String id2) {
        if (this.isStarted()) {
            MessageBroker broker = this.getService().getMessageBroker();
            FlexFactory factory = broker.getFactory(id2);
            if (factory == null) {
                ConfigurationException ex = new ConfigurationException();
                ex.setMessage(INVALID_FACTORY, new Object[]{this.getId(), factory});
                throw ex;
            }
            this.setFactory(factory);
        }
        this.factoryId = id2;
    }

    public void setFactory(FlexFactory factory) {
        this.factory = factory;
    }

    public FactoryInstance getFactoryInstance() {
        return this.getFactoryInstance(this.factoryProperties);
    }

    private FactoryInstance getFactoryInstance(ConfigMap properties) {
        if (this.factoryInstance == null) {
            this.factoryInstance = this.createFactoryInstance(properties);
        }
        return this.factoryInstance;
    }

    private FactoryInstance createFactoryInstance(ConfigMap properties) {
        if (properties == null) {
            properties = new ConfigMap();
        }
        properties.put("source", this.source);
        properties.put("scope", this.scope);
        FactoryInstance factoryInstance = this.getFactory().createFactoryInstance(this.getId(), properties);
        return factoryInstance;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (this.factoryInstance != null) {
            if ("application".equals(this.scope) && !"application".equals(scope)) {
                if (Log.isWarn()) {
                    Log.getLogger(this.getLogCategory()).warn("Current scope is application and it cannot be changed to " + scope + " once factory instance is initialized.");
                }
                return;
            }
            if (!"application".equals(this.scope) && "application".equals(scope)) {
                if (Log.isWarn()) {
                    Log.getLogger(this.getLogCategory()).warn("Current scope is " + this.scope + " and it cannot be changed to " + "application" + " once factory instance is initialized.");
                }
                return;
            }
            this.factoryInstance.setScope(scope);
        }
        this.scope = scope;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        if (this.factoryInstance != null) {
            if ("application".equals(this.scope)) {
                if (Log.isWarn()) {
                    Log.getLogger(this.getLogCategory()).warn("Source of the destination cannot be changed once factory instance is already initialized and it has application scope");
                }
                return;
            }
            this.factoryInstance.setSource(source);
        }
        this.source = source;
    }

    public void stop() {
        super.stop();
        if (this.factory != null && this.factory instanceof DestructibleFlexFactory) {
            ((DestructibleFlexFactory)((Object)this.factory)).destroyFactoryInstance(this.factoryInstance);
        }
    }
}

