/*
 * Decompiled with CFR 0.152.
 */
package flex.management;

import flex.management.MBeanServerLocator;
import flex.messaging.log.Log;
import flex.messaging.util.ClassUtil;

public class MBeanServerLocatorFactory {
    private static MBeanServerLocator locator;

    public static synchronized MBeanServerLocator getMBeanServerLocator() {
        if (locator == null) {
            MBeanServerLocatorFactory.instantiateLocator("flex.management.WebSphereMBeanServerLocator", new String[]{"com.ibm.websphere.management.AdminServiceFactory"});
            if (locator == null) {
                MBeanServerLocatorFactory.instantiateLocator("flex.management.PlatformMBeanServerLocator", new String[]{"java.lang.management.ManagementFactory"});
            }
            if (locator == null) {
                MBeanServerLocatorFactory.instantiateLocator("flex.management.DefaultMBeanServerLocator", null);
            }
            if (Log.isDebug()) {
                Log.getLogger("Management.General").debug("Using MBeanServerLocator: " + locator.getClass().getName());
            }
        }
        return locator;
    }

    public static void clear() {
        locator = null;
    }

    private static void instantiateLocator(String locatorClassName, String[] dependencyClassNames) {
        block4: {
            try {
                if (dependencyClassNames != null) {
                    for (int i2 = 0; i2 < dependencyClassNames.length; ++i2) {
                        ClassUtil.createClass(dependencyClassNames[i2]);
                    }
                }
                Class locatorClass = ClassUtil.createClass(locatorClassName);
                locator = (MBeanServerLocator)locatorClass.newInstance();
            }
            catch (Throwable t2) {
                if (!Log.isDebug()) break block4;
                Log.getLogger("Management.MBeanServer").debug("Not using MBeanServerLocator: " + locatorClassName + ". Reason: " + t2.getMessage());
            }
        }
    }

    private MBeanServerLocatorFactory() {
    }
}

