/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSCharsetRuleImpl
implements CSSCharsetRule,
Serializable {
    CSSStyleSheetImpl _parentStyleSheet = null;
    CSSRule _parentRule = null;
    String _encoding = null;

    public CSSCharsetRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, String encoding) {
        this._parentStyleSheet = parentStyleSheet;
        this._parentRule = parentRule;
        this._encoding = encoding;
    }

    public short getType() {
        return 2;
    }

    public String getCssText() {
        return "@charset \"" + this.getEncoding() + "\";";
    }

    public void setCssText(String cssText) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r2 = parser.parseRule(is);
            if (r2.getType() != 2) {
                throw new DOMExceptionImpl(13, 5);
            }
            this._encoding = ((CSSCharsetRuleImpl)r2)._encoding;
        }
        catch (CSSException e2) {
            throw new DOMExceptionImpl(12, 0, e2.getMessage());
        }
        catch (IOException e3) {
            throw new DOMExceptionImpl(12, 0, e3.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) throws DOMException {
        this._encoding = encoding;
    }
}

