#region license
// Copyright (c) 2009 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//

namespace Boo.Lang.Compiler.Ast
{
	using System;
	
	/// <summary>
	/// Visitor implementation that avoids the overhead of cloning collections
	/// before visiting them.
	///
	/// Avoid mutating collections when using this implementation.
	/// </summary>
	public partial class FastDepthFirstVisitor : IAstVisitor
	{

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnCompileUnit(Boo.Lang.Compiler.Ast.CompileUnit node)
		{				
			{
				var modules = node.Modules;
				if (modules != null)
				{
					var innerList = modules.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnTypeMemberStatement(Boo.Lang.Compiler.Ast.TypeMemberStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var typeMember = node.TypeMember;
				if (typeMember != null)
					typeMember.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnExplicitMemberInfo(Boo.Lang.Compiler.Ast.ExplicitMemberInfo node)
		{				
			{
				var interfaceType = node.InterfaceType;
				if (interfaceType != null)
					interfaceType.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSimpleTypeReference(Boo.Lang.Compiler.Ast.SimpleTypeReference node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnArrayTypeReference(Boo.Lang.Compiler.Ast.ArrayTypeReference node)
		{				
			{
				var elementType = node.ElementType;
				if (elementType != null)
					elementType.Accept(this);
			}
			{
				var rank = node.Rank;
				if (rank != null)
					rank.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnCallableTypeReference(Boo.Lang.Compiler.Ast.CallableTypeReference node)
		{				
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnGenericTypeReference(Boo.Lang.Compiler.Ast.GenericTypeReference node)
		{				
			{
				var genericArguments = node.GenericArguments;
				if (genericArguments != null)
				{
					var innerList = genericArguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnGenericTypeDefinitionReference(Boo.Lang.Compiler.Ast.GenericTypeDefinitionReference node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnCallableDefinition(Boo.Lang.Compiler.Ast.CallableDefinition node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			{
				var returnTypeAttributes = node.ReturnTypeAttributes;
				if (returnTypeAttributes != null)
				{
					var innerList = returnTypeAttributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnNamespaceDeclaration(Boo.Lang.Compiler.Ast.NamespaceDeclaration node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnImport(Boo.Lang.Compiler.Ast.Import node)
		{				
			{
				var assemblyReference = node.AssemblyReference;
				if (assemblyReference != null)
					assemblyReference.Accept(this);
			}
			{
				var alias = node.Alias;
				if (alias != null)
					alias.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnModule(Boo.Lang.Compiler.Ast.Module node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var members = node.Members;
				if (members != null)
				{
					var innerList = members.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var @namespace = node.Namespace;
				if (@namespace != null)
					@namespace.Accept(this);
			}
			{
				var imports = node.Imports;
				if (imports != null)
				{
					var innerList = imports.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var globals = node.Globals;
				if (globals != null)
					globals.Accept(this);
			}
			{
				var assemblyAttributes = node.AssemblyAttributes;
				if (assemblyAttributes != null)
				{
					var innerList = assemblyAttributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnClassDefinition(Boo.Lang.Compiler.Ast.ClassDefinition node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var members = node.Members;
				if (members != null)
				{
					var innerList = members.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnStructDefinition(Boo.Lang.Compiler.Ast.StructDefinition node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var members = node.Members;
				if (members != null)
				{
					var innerList = members.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnInterfaceDefinition(Boo.Lang.Compiler.Ast.InterfaceDefinition node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var members = node.Members;
				if (members != null)
				{
					var innerList = members.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnEnumDefinition(Boo.Lang.Compiler.Ast.EnumDefinition node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var members = node.Members;
				if (members != null)
				{
					var innerList = members.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnEnumMember(Boo.Lang.Compiler.Ast.EnumMember node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var initializer = node.Initializer;
				if (initializer != null)
					initializer.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnField(Boo.Lang.Compiler.Ast.Field node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			{
				var initializer = node.Initializer;
				if (initializer != null)
					initializer.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnProperty(Boo.Lang.Compiler.Ast.Property node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var getter = node.Getter;
				if (getter != null)
					getter.Accept(this);
			}
			{
				var setter = node.Setter;
				if (setter != null)
					setter.Accept(this);
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			{
				var explicitInfo = node.ExplicitInfo;
				if (explicitInfo != null)
					explicitInfo.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnEvent(Boo.Lang.Compiler.Ast.Event node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var add = node.Add;
				if (add != null)
					add.Accept(this);
			}
			{
				var remove = node.Remove;
				if (remove != null)
					remove.Accept(this);
			}
			{
				var raise = node.Raise;
				if (raise != null)
					raise.Accept(this);
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnLocal(Boo.Lang.Compiler.Ast.Local node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnBlockExpression(Boo.Lang.Compiler.Ast.BlockExpression node)
		{				
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			{
				var body = node.Body;
				if (body != null)
					body.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnMethod(Boo.Lang.Compiler.Ast.Method node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			{
				var returnTypeAttributes = node.ReturnTypeAttributes;
				if (returnTypeAttributes != null)
				{
					var innerList = returnTypeAttributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var body = node.Body;
				if (body != null)
					body.Accept(this);
			}
			{
				var locals = node.Locals;
				if (locals != null)
				{
					var innerList = locals.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var explicitInfo = node.ExplicitInfo;
				if (explicitInfo != null)
					explicitInfo.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnConstructor(Boo.Lang.Compiler.Ast.Constructor node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			{
				var returnTypeAttributes = node.ReturnTypeAttributes;
				if (returnTypeAttributes != null)
				{
					var innerList = returnTypeAttributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var body = node.Body;
				if (body != null)
					body.Accept(this);
			}
			{
				var locals = node.Locals;
				if (locals != null)
				{
					var innerList = locals.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var explicitInfo = node.ExplicitInfo;
				if (explicitInfo != null)
					explicitInfo.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnDestructor(Boo.Lang.Compiler.Ast.Destructor node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameters = node.Parameters;
				if (parameters != null)
				{
					var innerList = parameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var genericParameters = node.GenericParameters;
				if (genericParameters != null)
				{
					var innerList = genericParameters.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var returnType = node.ReturnType;
				if (returnType != null)
					returnType.Accept(this);
			}
			{
				var returnTypeAttributes = node.ReturnTypeAttributes;
				if (returnTypeAttributes != null)
				{
					var innerList = returnTypeAttributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var body = node.Body;
				if (body != null)
					body.Accept(this);
			}
			{
				var locals = node.Locals;
				if (locals != null)
				{
					var innerList = locals.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var explicitInfo = node.ExplicitInfo;
				if (explicitInfo != null)
					explicitInfo.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnParameterDeclaration(Boo.Lang.Compiler.Ast.ParameterDeclaration node)
		{				
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnGenericParameterDeclaration(Boo.Lang.Compiler.Ast.GenericParameterDeclaration node)
		{				
			{
				var baseTypes = node.BaseTypes;
				if (baseTypes != null)
				{
					var innerList = baseTypes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnDeclaration(Boo.Lang.Compiler.Ast.Declaration node)
		{				
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnAttribute(Boo.Lang.Compiler.Ast.Attribute node)
		{				
			{
				var arguments = node.Arguments;
				if (arguments != null)
				{
					var innerList = arguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var namedArguments = node.NamedArguments;
				if (namedArguments != null)
				{
					var innerList = namedArguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnStatementModifier(Boo.Lang.Compiler.Ast.StatementModifier node)
		{				
			{
				var condition = node.Condition;
				if (condition != null)
					condition.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnGotoStatement(Boo.Lang.Compiler.Ast.GotoStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var label = node.Label;
				if (label != null)
					label.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnLabelStatement(Boo.Lang.Compiler.Ast.LabelStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnBlock(Boo.Lang.Compiler.Ast.Block node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var statements = node.Statements;
				if (statements != null)
				{
					var innerList = statements.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnDeclarationStatement(Boo.Lang.Compiler.Ast.DeclarationStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var declaration = node.Declaration;
				if (declaration != null)
					declaration.Accept(this);
			}
			{
				var initializer = node.Initializer;
				if (initializer != null)
					initializer.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnMacroStatement(Boo.Lang.Compiler.Ast.MacroStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var arguments = node.Arguments;
				if (arguments != null)
				{
					var innerList = arguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var body = node.Body;
				if (body != null)
					body.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnTryStatement(Boo.Lang.Compiler.Ast.TryStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var protectedBlock = node.ProtectedBlock;
				if (protectedBlock != null)
					protectedBlock.Accept(this);
			}
			{
				var exceptionHandlers = node.ExceptionHandlers;
				if (exceptionHandlers != null)
				{
					var innerList = exceptionHandlers.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var failureBlock = node.FailureBlock;
				if (failureBlock != null)
					failureBlock.Accept(this);
			}
			{
				var ensureBlock = node.EnsureBlock;
				if (ensureBlock != null)
					ensureBlock.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnExceptionHandler(Boo.Lang.Compiler.Ast.ExceptionHandler node)
		{				
			{
				var declaration = node.Declaration;
				if (declaration != null)
					declaration.Accept(this);
			}
			{
				var filterCondition = node.FilterCondition;
				if (filterCondition != null)
					filterCondition.Accept(this);
			}
			{
				var block = node.Block;
				if (block != null)
					block.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnIfStatement(Boo.Lang.Compiler.Ast.IfStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var condition = node.Condition;
				if (condition != null)
					condition.Accept(this);
			}
			{
				var trueBlock = node.TrueBlock;
				if (trueBlock != null)
					trueBlock.Accept(this);
			}
			{
				var falseBlock = node.FalseBlock;
				if (falseBlock != null)
					falseBlock.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnUnlessStatement(Boo.Lang.Compiler.Ast.UnlessStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var condition = node.Condition;
				if (condition != null)
					condition.Accept(this);
			}
			{
				var block = node.Block;
				if (block != null)
					block.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnForStatement(Boo.Lang.Compiler.Ast.ForStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var declarations = node.Declarations;
				if (declarations != null)
				{
					var innerList = declarations.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var iterator = node.Iterator;
				if (iterator != null)
					iterator.Accept(this);
			}
			{
				var block = node.Block;
				if (block != null)
					block.Accept(this);
			}
			{
				var orBlock = node.OrBlock;
				if (orBlock != null)
					orBlock.Accept(this);
			}
			{
				var thenBlock = node.ThenBlock;
				if (thenBlock != null)
					thenBlock.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnWhileStatement(Boo.Lang.Compiler.Ast.WhileStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var condition = node.Condition;
				if (condition != null)
					condition.Accept(this);
			}
			{
				var block = node.Block;
				if (block != null)
					block.Accept(this);
			}
			{
				var orBlock = node.OrBlock;
				if (orBlock != null)
					orBlock.Accept(this);
			}
			{
				var thenBlock = node.ThenBlock;
				if (thenBlock != null)
					thenBlock.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnBreakStatement(Boo.Lang.Compiler.Ast.BreakStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnContinueStatement(Boo.Lang.Compiler.Ast.ContinueStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnReturnStatement(Boo.Lang.Compiler.Ast.ReturnStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnYieldStatement(Boo.Lang.Compiler.Ast.YieldStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnRaiseStatement(Boo.Lang.Compiler.Ast.RaiseStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var exception = node.Exception;
				if (exception != null)
					exception.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnUnpackStatement(Boo.Lang.Compiler.Ast.UnpackStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var declarations = node.Declarations;
				if (declarations != null)
				{
					var innerList = declarations.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnExpressionStatement(Boo.Lang.Compiler.Ast.ExpressionStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnOmittedExpression(Boo.Lang.Compiler.Ast.OmittedExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnExpressionPair(Boo.Lang.Compiler.Ast.ExpressionPair node)
		{				
			{
				var first = node.First;
				if (first != null)
					first.Accept(this);
			}
			{
				var second = node.Second;
				if (second != null)
					second.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnMethodInvocationExpression(Boo.Lang.Compiler.Ast.MethodInvocationExpression node)
		{				
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var arguments = node.Arguments;
				if (arguments != null)
				{
					var innerList = arguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var namedArguments = node.NamedArguments;
				if (namedArguments != null)
				{
					var innerList = namedArguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnUnaryExpression(Boo.Lang.Compiler.Ast.UnaryExpression node)
		{				
			{
				var operand = node.Operand;
				if (operand != null)
					operand.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnBinaryExpression(Boo.Lang.Compiler.Ast.BinaryExpression node)
		{				
			{
				var left = node.Left;
				if (left != null)
					left.Accept(this);
			}
			{
				var right = node.Right;
				if (right != null)
					right.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnConditionalExpression(Boo.Lang.Compiler.Ast.ConditionalExpression node)
		{				
			{
				var condition = node.Condition;
				if (condition != null)
					condition.Accept(this);
			}
			{
				var trueValue = node.TrueValue;
				if (trueValue != null)
					trueValue.Accept(this);
			}
			{
				var falseValue = node.FalseValue;
				if (falseValue != null)
					falseValue.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnReferenceExpression(Boo.Lang.Compiler.Ast.ReferenceExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnMemberReferenceExpression(Boo.Lang.Compiler.Ast.MemberReferenceExpression node)
		{				
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnGenericReferenceExpression(Boo.Lang.Compiler.Ast.GenericReferenceExpression node)
		{				
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var genericArguments = node.GenericArguments;
				if (genericArguments != null)
				{
					var innerList = genericArguments.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnQuasiquoteExpression(Boo.Lang.Compiler.Ast.QuasiquoteExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnStringLiteralExpression(Boo.Lang.Compiler.Ast.StringLiteralExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnCharLiteralExpression(Boo.Lang.Compiler.Ast.CharLiteralExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnTimeSpanLiteralExpression(Boo.Lang.Compiler.Ast.TimeSpanLiteralExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnIntegerLiteralExpression(Boo.Lang.Compiler.Ast.IntegerLiteralExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnDoubleLiteralExpression(Boo.Lang.Compiler.Ast.DoubleLiteralExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnNullLiteralExpression(Boo.Lang.Compiler.Ast.NullLiteralExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSelfLiteralExpression(Boo.Lang.Compiler.Ast.SelfLiteralExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSuperLiteralExpression(Boo.Lang.Compiler.Ast.SuperLiteralExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnBoolLiteralExpression(Boo.Lang.Compiler.Ast.BoolLiteralExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnRELiteralExpression(Boo.Lang.Compiler.Ast.RELiteralExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSpliceExpression(Boo.Lang.Compiler.Ast.SpliceExpression node)
		{				
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSpliceTypeReference(Boo.Lang.Compiler.Ast.SpliceTypeReference node)
		{				
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSpliceMemberReferenceExpression(Boo.Lang.Compiler.Ast.SpliceMemberReferenceExpression node)
		{				
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var nameExpression = node.NameExpression;
				if (nameExpression != null)
					nameExpression.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSpliceTypeMember(Boo.Lang.Compiler.Ast.SpliceTypeMember node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var typeMember = node.TypeMember;
				if (typeMember != null)
					typeMember.Accept(this);
			}
			{
				var nameExpression = node.NameExpression;
				if (nameExpression != null)
					nameExpression.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSpliceTypeDefinitionBody(Boo.Lang.Compiler.Ast.SpliceTypeDefinitionBody node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSpliceParameterDeclaration(Boo.Lang.Compiler.Ast.SpliceParameterDeclaration node)
		{				
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var parameterDeclaration = node.ParameterDeclaration;
				if (parameterDeclaration != null)
					parameterDeclaration.Accept(this);
			}
			{
				var nameExpression = node.NameExpression;
				if (nameExpression != null)
					nameExpression.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnExpressionInterpolationExpression(Boo.Lang.Compiler.Ast.ExpressionInterpolationExpression node)
		{				
			{
				var expressions = node.Expressions;
				if (expressions != null)
				{
					var innerList = expressions.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnHashLiteralExpression(Boo.Lang.Compiler.Ast.HashLiteralExpression node)
		{				
			{
				var items = node.Items;
				if (items != null)
				{
					var innerList = items.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnListLiteralExpression(Boo.Lang.Compiler.Ast.ListLiteralExpression node)
		{				
			{
				var items = node.Items;
				if (items != null)
				{
					var innerList = items.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnCollectionInitializationExpression(Boo.Lang.Compiler.Ast.CollectionInitializationExpression node)
		{				
			{
				var collection = node.Collection;
				if (collection != null)
					collection.Accept(this);
			}
			{
				var initializer = node.Initializer;
				if (initializer != null)
					initializer.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnArrayLiteralExpression(Boo.Lang.Compiler.Ast.ArrayLiteralExpression node)
		{				
			{
				var items = node.Items;
				if (items != null)
				{
					var innerList = items.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnGeneratorExpression(Boo.Lang.Compiler.Ast.GeneratorExpression node)
		{				
			{
				var expression = node.Expression;
				if (expression != null)
					expression.Accept(this);
			}
			{
				var declarations = node.Declarations;
				if (declarations != null)
				{
					var innerList = declarations.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var iterator = node.Iterator;
				if (iterator != null)
					iterator.Accept(this);
			}
			{
				var filter = node.Filter;
				if (filter != null)
					filter.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnExtendedGeneratorExpression(Boo.Lang.Compiler.Ast.ExtendedGeneratorExpression node)
		{				
			{
				var items = node.Items;
				if (items != null)
				{
					var innerList = items.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSlice(Boo.Lang.Compiler.Ast.Slice node)
		{				
			{
				var begin = node.Begin;
				if (begin != null)
					begin.Accept(this);
			}
			{
				var end = node.End;
				if (end != null)
					end.Accept(this);
			}
			{
				var step = node.Step;
				if (step != null)
					step.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnSlicingExpression(Boo.Lang.Compiler.Ast.SlicingExpression node)
		{				
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var indices = node.Indices;
				if (indices != null)
				{
					var innerList = indices.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnTryCastExpression(Boo.Lang.Compiler.Ast.TryCastExpression node)
		{				
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnCastExpression(Boo.Lang.Compiler.Ast.CastExpression node)
		{				
			{
				var target = node.Target;
				if (target != null)
					target.Accept(this);
			}
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnTypeofExpression(Boo.Lang.Compiler.Ast.TypeofExpression node)
		{				
			{
				var type = node.Type;
				if (type != null)
					type.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnCustomStatement(Boo.Lang.Compiler.Ast.CustomStatement node)
		{				
			{
				var modifier = node.Modifier;
				if (modifier != null)
					modifier.Accept(this);
			}
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnCustomExpression(Boo.Lang.Compiler.Ast.CustomExpression node)
		{				
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public virtual void OnStatementTypeMember(Boo.Lang.Compiler.Ast.StatementTypeMember node)
		{				
			{
				var attributes = node.Attributes;
				if (attributes != null)
				{
					var innerList = attributes.InnerList;
					var count = innerList.Count;
					for (var i=0; i<count; ++i)
						innerList.FastAt(i).Accept(this);
				}
			}
			{
				var statement = node.Statement;
				if (statement != null)
					statement.Accept(this);
			}
		}

		protected void Visit(Node node)
		{
			if (node == null)
				return;
			node.Accept(this);
		}
		
		protected void Visit<T>(NodeCollection<T> nodes) where T: Node
		{
			if (nodes == null)
				return;
			var innerList = nodes.InnerList;
			var count = innerList.Count;
			for (var i = 0; i<count; ++i)
				innerList.FastAt(i).Accept(this);
		}
	}
}

