/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTTPTransportUtils {
    private static final Log log = LogFactory.getLog(HTTPTransportUtils.class);
    private static final int VERSION_UNKNOWN = 0;
    private static final int VERSION_SOAP11 = 1;
    private static final int VERSION_SOAP12 = 2;

    public static SOAPEnvelope createEnvelopeFromGetRequest(String requestUrl, Map map, ConfigurationContext configCtx) throws AxisFault {
        String[] values = Utils.parseRequestURLForServiceAndOperation((String)requestUrl, (String)configCtx.getServiceContextPath());
        if (values == null) {
            return OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope();
        }
        if (values[1] != null && values[0] != null) {
            String srvice = values[0];
            AxisService service = configCtx.getAxisConfiguration().getService(srvice);
            if (service == null) {
                throw new AxisFault("service not found: " + srvice);
            }
            String operation = values[1];
            SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
            SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
            OMNamespace omNs = soapFactory.createOMNamespace(service.getSchemaTargetNamespace(), service.getSchemaTargetNamespacePrefix());
            soapFactory.createOMNamespace(service.getSchemaTargetNamespace(), service.getSchemaTargetNamespacePrefix());
            OMElement opElement = soapFactory.createOMElement(operation, omNs);
            for (String name : map.keySet()) {
                String value = (String)map.get(name);
                OMElement omEle = soapFactory.createOMElement(name, omNs);
                omEle.setText(value);
                opElement.addChild((OMNode)omEle);
            }
            envelope.getBody().addChild((OMNode)opElement);
            return envelope;
        }
        return null;
    }

    public static boolean processHTTPGetRequest(MessageContext msgContext, OutputStream out, String soapAction, String requestURI, ConfigurationContext configurationContext, Map requestParameters) throws AxisFault {
        if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        msgContext.setSoapAction(soapAction);
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setProperty("TRANSPORT_OUT", (Object)out);
        msgContext.setServerSide(true);
        SOAPEnvelope envelope = HTTPTransportUtils.createEnvelopeFromGetRequest(requestURI, requestParameters, configurationContext);
        if (envelope == null) {
            return false;
        }
        msgContext.setDoingREST(true);
        msgContext.setEnvelope(envelope);
        AxisEngine.receive((MessageContext)msgContext);
        return true;
    }

    public static Handler.InvocationResponse processHTTPPostRequest(MessageContext msgContext, InputStream in, OutputStream out, String contentType, String soapActionHeader, String requestURI) throws AxisFault {
        int soapVersion = 0;
        try {
            soapVersion = HTTPTransportUtils.initializeMessageContext(msgContext, soapActionHeader, requestURI, contentType);
            msgContext.setProperty("TRANSPORT_OUT", (Object)out);
            msgContext.setEnvelope(TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)HTTPTransportUtils.handleGZip(msgContext, in), (String)contentType));
            Handler.InvocationResponse invocationResponse = AxisEngine.receive((MessageContext)msgContext);
            return invocationResponse;
        }
        catch (SOAPProcessingException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (OMException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        finally {
            if (msgContext.getEnvelope() == null && soapVersion != 1) {
                msgContext.setEnvelope(OMAbstractFactory.getSOAP12Factory().getDefaultEnvelope());
            }
        }
    }

    public static int initializeMessageContext(MessageContext msgContext, String soapActionHeader, String requestURI, String contentType) {
        int soapVersion = 0;
        if (soapActionHeader != null && soapActionHeader.length() > 0 && soapActionHeader.charAt(0) == '\"' && soapActionHeader.endsWith("\"")) {
            soapActionHeader = soapActionHeader.substring(1, soapActionHeader.length() - 1);
        }
        msgContext.setSoapAction(soapActionHeader);
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setServerSide(true);
        String charSetEnc = BuilderUtil.getCharSetEncoding((String)contentType);
        if (charSetEnc == null) {
            charSetEnc = "UTF-8";
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEnc);
        if (contentType != null) {
            if (contentType.indexOf("application/soap+xml") > -1) {
                soapVersion = 2;
                TransportUtils.processContentTypeForAction((String)contentType, (MessageContext)msgContext);
            } else if (contentType.indexOf("text/xml") > -1) {
                soapVersion = 1;
            } else if (HTTPTransportUtils.isRESTRequest(contentType)) {
                soapVersion = 1;
                msgContext.setDoingREST(true);
            }
            if (soapVersion == 1) {
                Parameter enableREST = msgContext.getParameter("enableREST");
                if (soapActionHeader == null && enableREST != null && "true".equals(enableREST.getValue())) {
                    msgContext.setDoingREST(true);
                }
            }
        }
        return soapVersion;
    }

    public static InputStream handleGZip(MessageContext msgContext, InputStream in) throws IOException {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headers != null && ("gzip".equals(headers.get("Content-Encoding")) || "gzip".equals(headers.get(HTTPConstants.HEADER_CONTENT_ENCODING_LOWERCASE)))) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static boolean isRESTRequest(String contentType) {
        return contentType != null && (contentType.indexOf("application/xml") > -1 || contentType.indexOf("application/x-www-form-urlencoded") > -1 || contentType.indexOf("multipart/form-data") > -1);
    }

    public static EndpointReference[] getEPRsForService(ConfigurationContext configurationContext, TransportInDescription trpInDesc, String serviceName, String ip, int port) throws AxisFault {
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        Parameter param = axisConfiguration.getParameter("httpFrontendHostUrl");
        StringBuilder epr = new StringBuilder();
        if (param != null) {
            epr.append(param.getValue());
            String servicePath = configurationContext.getServicePath();
            if (epr.charAt(epr.length() - 1) != '/' && !servicePath.startsWith("/")) {
                epr.append('/');
            }
            epr.append(servicePath);
        } else {
            param = trpInDesc.getParameter("hostname");
            if (param != null) {
                log.warn((Object)("Transport '" + trpInDesc.getName() + "' is configured with deprecated parameter '" + "hostname" + "'. Please set '" + "httpFrontendHostUrl" + "' in the Axis configuration instead."));
                epr.append(param.getValue());
            } else {
                if (ip == null) {
                    try {
                        ip = Utils.getIpAddress((AxisConfiguration)configurationContext.getAxisConfiguration());
                    }
                    catch (SocketException ex) {
                        AxisFault.makeFault((Throwable)ex);
                    }
                }
                String scheme = trpInDesc.getName();
                epr.append(scheme);
                epr.append("://");
                epr.append(ip);
                if (!(scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443)) {
                    epr.append(':');
                    epr.append(port);
                }
            }
            String serviceContextPath = configurationContext.getServiceContextPath();
            if (epr.charAt(epr.length() - 1) != '/' && !serviceContextPath.startsWith("/")) {
                epr.append('/');
            }
            epr.append(serviceContextPath);
        }
        epr.append('/');
        epr.append(serviceName);
        epr.append('/');
        return new EndpointReference[]{new EndpointReference(epr.toString())};
    }
}

