/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.BaseXMLElement;
import org.apache.woden.internal.util.dom.DOMQNameUtils;
import org.apache.woden.internal.util.dom.XPathUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMXMLElement
extends BaseXMLElement {
    private static final String emptyString = "".intern();

    public DOMXMLElement(ErrorReporter errorReporter) {
        super(errorReporter);
    }

    public void setSource(Object elem) {
        if (!(elem instanceof Element)) {
            String elemClass = elem != null ? elem.getClass().getName() : null;
            String xmlElementClass = ((Object)((Object)this)).getClass().getName();
            String msg = this.fErrorReporter.getFormattedMessage("WSDL019", new Object[]{elemClass, xmlElementClass});
            throw new IllegalArgumentException(msg);
        }
        this.fSource = elem;
    }

    protected String doGetAttributeValue(String attrName) {
        Element el = (Element)this.fSource;
        return this.getAttribute(el, attrName);
    }

    protected URI doGetNamespaceURI() throws WSDLException {
        Element el = (Element)this.fSource;
        String nsStr = el.getNamespaceURI();
        URI uri = null;
        if (nsStr != null) {
            try {
                uri = new URI(nsStr);
            }
            catch (URISyntaxException e) {
                String msg = this.fErrorReporter.getFormattedMessage("WSDL506", new Object[]{nsStr});
                throw new WSDLException("INVALID_WSDL", msg, (Throwable)e);
            }
        }
        return uri;
    }

    protected String doGetLocalName() {
        Element el = (Element)this.fSource;
        return el.getLocalName();
    }

    protected QName doGetQName() {
        Element el = (Element)this.fSource;
        return new QName(el.getNamespaceURI(), el.getLocalName());
    }

    protected QName doGetQName(String prefixedValue) throws WSDLException {
        Element el = (Element)this.fSource;
        int index = prefixedValue.indexOf(58);
        String prefix = index != -1 ? prefixedValue.substring(0, index) : null;
        String localPart = prefixedValue.substring(index + 1);
        String namespaceURI = this.getNamespaceFromPrefix(el, prefix);
        if (prefix != null && namespaceURI == null) {
            String faultCode = "UNBOUND_PREFIX";
            String msg = this.fErrorReporter.getFormattedMessage("WSDL513", new Object[]{prefixedValue, DOMQNameUtils.newQName(el)});
            WSDLException wsdlExc = new WSDLException(faultCode, msg);
            wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(el));
            throw wsdlExc;
        }
        return new QName(namespaceURI, localPart, prefix != null ? prefix : emptyString);
    }

    protected XMLElement doGetFirstChildElement() {
        DOMXMLElement xmlElement = new DOMXMLElement(this.fErrorReporter);
        Element el = (Element)this.fSource;
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            xmlElement.setSource(node);
            return xmlElement;
        }
        return null;
    }

    protected XMLElement doGetNextSiblingElement() {
        DOMXMLElement xmlElement = new DOMXMLElement(this.fErrorReporter);
        Element el = (Element)this.fSource;
        for (Node node = el.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            xmlElement.setSource(node);
            return xmlElement;
        }
        return null;
    }

    protected XMLElement[] doGetChildElements() {
        Vector<XMLElement> children = new Vector<XMLElement>();
        for (XMLElement temp = this.doGetFirstChildElement(); temp != null; temp = temp.getNextSiblingElement()) {
            children.add(temp);
        }
        XMLElement[] array = new XMLElement[children.size()];
        children.toArray(array);
        return array;
    }

    private String getAttribute(Element el, String attrName) {
        String sRet = null;
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    private String getAttributeNS(Element el, String namespaceURI, String localPart) {
        String sRet = null;
        Attr attr = el.getAttributeNodeNS(namespaceURI, localPart);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    private String getNamespaceFromPrefix(Node context, String prefix) {
        short nodeType = context.getNodeType();
        Node tempNode = null;
        switch (nodeType) {
            case 2: {
                tempNode = ((Attr)context).getOwnerElement();
                break;
            }
            case 1: {
                tempNode = context;
                break;
            }
            default: {
                tempNode = context.getParentNode();
            }
        }
        while (tempNode != null && tempNode.getNodeType() == 1) {
            String namespaceURI;
            Element tempEl = (Element)tempNode;
            String string = namespaceURI = prefix == null ? this.getAttribute(tempEl, "xmlns") : this.getAttributeNS(tempEl, "http://www.w3.org/2000/xmlns/", prefix);
            if (namespaceURI != null) {
                return namespaceURI;
            }
            tempNode = tempEl.getParentNode();
        }
        return null;
    }
}

