/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.support.BaseByteBuffer;

public class SimpleByteBufferAllocator
implements ByteBufferAllocator {
    private static final int MINIMUM_CAPACITY = 1;

    public ByteBuffer allocate(int capacity, boolean direct) {
        java.nio.ByteBuffer nioBuffer = direct ? java.nio.ByteBuffer.allocateDirect(capacity) : java.nio.ByteBuffer.allocate(capacity);
        return new SimpleByteBuffer(nioBuffer);
    }

    public ByteBuffer wrap(java.nio.ByteBuffer nioBuffer) {
        return new SimpleByteBuffer(nioBuffer);
    }

    public void dispose() {
    }

    private static class SimpleByteBuffer
    extends BaseByteBuffer {
        private java.nio.ByteBuffer buf;
        private final AtomicInteger refCount = new AtomicInteger();

        protected SimpleByteBuffer(java.nio.ByteBuffer buf) {
            this.buf = buf;
            buf.order(ByteOrder.BIG_ENDIAN);
            this.refCount.set(1);
        }

        public void acquire() {
            if (this.refCount.get() <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            this.refCount.incrementAndGet();
        }

        public void release() {
            if (this.refCount.get() <= 0) {
                this.refCount.set(0);
                throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
            }
            this.refCount.decrementAndGet();
        }

        public java.nio.ByteBuffer buf() {
            return this.buf;
        }

        public boolean isPooled() {
            return false;
        }

        public void setPooled(boolean pooled) {
        }

        protected void capacity0(int requestedCapacity) {
            int newCapacity = 1;
            while (newCapacity < requestedCapacity) {
                newCapacity <<= 1;
            }
            java.nio.ByteBuffer oldBuf = this.buf;
            java.nio.ByteBuffer newBuf = this.isDirect() ? java.nio.ByteBuffer.allocateDirect(newCapacity) : java.nio.ByteBuffer.allocate(newCapacity);
            newBuf.clear();
            oldBuf.clear();
            newBuf.put(oldBuf);
            this.buf = newBuf;
        }

        public ByteBuffer duplicate() {
            return new SimpleByteBuffer(this.buf.duplicate());
        }

        public ByteBuffer slice() {
            return new SimpleByteBuffer(this.buf.slice());
        }

        public ByteBuffer asReadOnlyBuffer() {
            return new SimpleByteBuffer(this.buf.asReadOnlyBuffer());
        }

        public byte[] array() {
            return this.buf.array();
        }

        public int arrayOffset() {
            return this.buf.arrayOffset();
        }
    }
}

