/*
 * Decompiled with CFR 0.152.
 */
package org.avis.util;

import java.util.regex.Pattern;

public final class Wildcard {
    private Wildcard() {
    }

    public static Pattern toPattern(String wildcard) {
        return Wildcard.toPattern(wildcard, 0);
    }

    public static Pattern toPattern(String wildcard, int flags) {
        StringBuilder regex = new StringBuilder(wildcard.length() * 2);
        block5: for (int i = 0; i < wildcard.length(); ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    regex.append(".*");
                    continue block5;
                }
                case '?': {
                    regex.append('.');
                    continue block5;
                }
                case '\\': {
                    if (++i < wildcard.length()) {
                        regex.append('\\');
                        regex.append(wildcard.charAt(i));
                        continue block5;
                    }
                    regex.append("\\\\");
                    continue block5;
                }
                default: {
                    if (Character.isLetterOrDigit(c) || Character.isWhitespace(c)) {
                        regex.append(c);
                        continue block5;
                    }
                    regex.append('\\').append(c);
                }
            }
        }
        return Pattern.compile(regex.toString(), flags);
    }
}

