/*
 * Decompiled with CFR 0.152.
 */
package org.avis.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentingWriter
extends PrintWriter {
    private int indent = 0;
    private int indentIncr = 2;

    public IndentingWriter(OutputStream str) {
        this(new OutputStreamWriter(str));
    }

    public IndentingWriter(Writer writer) {
        super(writer);
    }

    public String toString() {
        return this.out.toString();
    }

    public void setIndentIncr(int newValue) {
        this.indentIncr = newValue;
    }

    public int getIndentIncr() {
        return this.indentIncr;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void indentln() {
        this.indent();
        this.println();
    }

    public void indent() {
        this.indent += this.indentIncr;
    }

    public void unindent() {
        this.indent -= this.indentIncr;
    }

    public void indent(int spaces) {
        this.indent += spaces;
    }

    public void unindent(int spaces) {
        this.indent -= spaces;
    }

    public void write(int c) {
        super.write(c);
        if (c == 10) {
            this.writeIndent();
        }
    }

    public void write(char[] buf, int off, int len) {
        int index = off;
        for (int i = 0; i < len; ++i) {
            this.write(buf[index++]);
        }
    }

    public void write(String s, int off, int len) {
        this.write(s.toCharArray(), off, len);
    }

    public void println() {
        super.println();
        this.writeIndent();
        this.flush();
    }

    private void writeIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.write(32);
        }
    }
}

