/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.parser;

import java.io.StringReader;
import java.util.regex.PatternSyntaxException;
import org.avis.subscription.ast.IllegalChildException;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.Const;
import org.avis.subscription.parser.ConstantExpressionException;
import org.avis.subscription.parser.ParseException;
import org.avis.subscription.parser.SubscriptionParser;
import org.avis.subscription.parser.TokenMgrError;
import org.avis.util.InvalidFormatException;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubscriptionParserBase {
    public static Node parse(String subExpr) throws ParseException {
        return new SubscriptionParser(new StringReader(subExpr)).parseAndValidate();
    }

    abstract Node doParse() throws ParseException;

    public Node parse() throws ParseException {
        try {
            return this.doParse();
        }
        catch (IllegalChildException ex) {
            throw new ParseException("Illegal expression: " + ex.getMessage());
        }
        catch (TokenMgrError ex) {
            throw new ParseException(ex.getMessage());
        }
        catch (PatternSyntaxException ex) {
            throw new ParseException("Invalid regex \"" + ex.getPattern() + "\": " + ex.getDescription());
        }
    }

    public Node parseAndValidate() throws ParseException, ConstantExpressionException {
        Node node = this.parse().inlineConstants();
        if (node.evalType() == Boolean.class) {
            if (!(node instanceof Const)) {
                return node;
            }
            throw new ConstantExpressionException("Expression is constant: " + node.expr());
        }
        throw new ParseException("Expression does not evaluate to boolean: " + node.expr());
    }

    protected static String stripBackslashes(String text) throws ParseException {
        try {
            return Text.stripBackslashes(text);
        }
        catch (InvalidFormatException ex) {
            throw new ParseException("Error in string: " + ex.getMessage());
        }
    }

    protected static String className(Class<?> type) {
        return Text.className(type);
    }

    public static String expectedTokensFor(ParseException ex) {
        StringBuilder expected = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < ex.expectedTokenSequences.length; ++i) {
            if (!first) {
                expected.append(", ");
            }
            first = false;
            for (int j = 0; j < ex.expectedTokenSequences[i].length; ++j) {
                expected.append(ex.tokenImage[ex.expectedTokenSequences[i][j]]);
            }
        }
        return expected.toString();
    }
}

