/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.Const;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringCompareNode
extends Node {
    protected Node stringExpr;
    protected String string;

    public StringCompareNode(Node stringExpr, Const stringConst) {
        this(stringExpr, (String)stringConst.value());
    }

    public StringCompareNode(Node stringExpr, String string) {
        this.stringExpr = stringExpr;
        this.string = string;
    }

    @Override
    public Class<?> evalType() {
        return Boolean.class;
    }

    @Override
    public String presentation() {
        return this.name();
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Collection<Node> children() {
        ArrayList<Node> children = new ArrayList<Node>(2);
        children.add(this.stringExpr);
        children.add(new Const(this.string));
        return children;
    }

    @Override
    public Object evaluate(Map<String, Object> attrs) {
        Object value = this.stringExpr.evaluate(attrs);
        if (value == null) {
            return BOTTOM;
        }
        return this.evaluate((String)value, this.string);
    }

    protected abstract boolean evaluate(String var1, String var2);

    @Override
    public Node inlineConstants() {
        this.stringExpr = this.stringExpr.inlineConstants();
        Object result = this.evaluate(EMPTY_NOTIFICATION);
        if (result != BOTTOM) {
            return Const.bool((Boolean)result);
        }
        return this;
    }
}

