/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast;

import java.util.ArrayList;
import java.util.Collection;
import org.avis.subscription.ast.IllegalChildException;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.Const;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParentBiNode
extends Node {
    protected Node child1;
    protected Node child2;

    public ParentBiNode() {
    }

    public ParentBiNode(Node child1, Node child2) {
        this.init(child1, child2);
    }

    protected void init(Node newChild1, Node newChild2) {
        this.checkChild(newChild1);
        this.child1 = newChild1;
        this.checkChild(newChild2);
        this.child2 = newChild2;
    }

    private void checkChild(Node child) {
        String error = this.validateChild(child);
        if (error != null) {
            throw new IllegalChildException(error, this, child);
        }
    }

    protected abstract String validateChild(Node var1);

    @Override
    public String presentation() {
        return this.name();
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Collection<Node> children() {
        ArrayList<Node> children = new ArrayList<Node>(2);
        children.add(this.child1);
        children.add(this.child2);
        return children;
    }

    @Override
    public Node inlineConstants() {
        this.child1 = this.child1.inlineConstants();
        this.child2 = this.child2.inlineConstants();
        Object result = this.evaluate(EMPTY_NOTIFICATION);
        if (result != null) {
            return new Const(result);
        }
        return this;
    }
}

