/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast;

import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.Or;
import org.avis.util.IndentingWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Nodes {
    private Nodes() {
    }

    public static String toString(Node node) {
        IndentingWriter out = new IndentingWriter(new StringWriter());
        Nodes.print(out, node);
        return out.toString();
    }

    private static void print(IndentingWriter out, Node node) {
        out.print(node.presentation());
        if (node.hasChildren()) {
            out.indent();
            for (Node child : node.children()) {
                out.println();
                Nodes.print(out, child);
            }
            out.unindent();
        }
    }

    public static String unparse(Node node) {
        StringBuilder str = new StringBuilder();
        Nodes.unparse(str, node);
        return str.toString();
    }

    private static void unparse(StringBuilder str, Node node) {
        if (node.hasChildren()) {
            str.append('(');
            str.append(node.expr());
            for (Node child : node.children()) {
                str.append(' ');
                Nodes.unparse(str, child);
            }
            str.append(')');
        } else {
            str.append(node.expr());
        }
    }

    public static <T extends Node> Node createConjunction(Class<T> nodeType, Class<?> param1, Class<?> param2, List<Node> args) {
        try {
            Constructor<T> nodeConstructor = nodeType.getConstructor(param1, param2);
            if (args.size() == 2) {
                return (Node)nodeConstructor.newInstance(args.get(0), args.get(1));
            }
            Node arg0 = args.get(0);
            Or or = new Or();
            for (int i = 1; i < args.size(); ++i) {
                or.addChild((Node)nodeConstructor.newInstance(arg0, args.get(i)));
            }
            return or;
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new Error(ex);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

