/*
 * Decompiled with CFR 0.152.
 */
package org.avis.subscription.ast;

import org.avis.subscription.ast.MathParentNode;
import org.avis.subscription.ast.Node;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MathIntParentNode
extends MathParentNode {
    public MathIntParentNode(Node child1, Node child2) {
        super(child1, child2);
    }

    @Override
    public Class<?> evalType() {
        return Integer.class;
    }

    @Override
    protected String validateChild(Node child) {
        Class<?> childType = child.evalType();
        if (childType == Object.class) {
            return null;
        }
        if (!Integer.class.isAssignableFrom(childType) && !Long.class.isAssignableFrom(childType)) {
            return "\"" + this.expr() + "\" needs an integer as an argument (was " + Text.className(child.evalType()).toLowerCase() + ")";
        }
        return null;
    }

    @Override
    protected boolean validOperand(Object value) {
        return value instanceof Integer || value instanceof Long;
    }

    @Override
    protected double evaluateReal64(double number1, double number2) {
        throw new UnsupportedOperationException("Not applicable for Real64 values");
    }
}

