/*
 * Decompiled with CFR 0.152.
 */
package org.avis.security;

public final class SHA1
implements Cloneable {
    private static final int SHA1_LENGTH = 20;
    private byte[] pad = new byte[64];
    private int padding;
    private long bytes;
    private int hA;
    private int hB;
    private int hC;
    private int hD;
    private int hE;

    public SHA1() {
        this.engineReset();
    }

    public SHA1(SHA1 state) {
        this();
        this.pad = (byte[])state.pad.clone();
        this.padding = state.padding;
        this.bytes = state.bytes;
        this.hA = state.hA;
        this.hB = state.hB;
        this.hC = state.hC;
        this.hD = state.hD;
        this.hE = state.hE;
    }

    public Object clone() {
        SHA1 that = null;
        try {
            that = (SHA1)super.clone();
            that.pad = (byte[])this.pad.clone();
            that.padding = this.padding;
            that.bytes = this.bytes;
            that.hA = this.hA;
            that.hB = this.hB;
            that.hC = this.hC;
            that.hD = this.hD;
            that.hE = this.hE;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return that;
    }

    public int engineGetDigestLength() {
        return 20;
    }

    protected void engineReset() {
        int i = 60;
        do {
            this.pad[i] = 0;
            this.pad[i + 1] = 0;
            this.pad[i + 2] = 0;
            this.pad[i + 3] = 0;
        } while ((i -= 4) >= 0);
        this.padding = 0;
        this.bytes = 0L;
        this.hA = 1732584193;
        this.hB = -271733879;
        this.hC = -1732584194;
        this.hD = 271733878;
        this.hE = -1009589776;
    }

    public void engineUpdate(byte input) {
        ++this.bytes;
        this.pad[this.padding] = input;
        if (++this.padding == 64) {
            this.computeBlock(this.pad, 0);
            this.padding = 0;
        }
    }

    public void engineUpdate(byte[] input, int offset, int len) {
        if (offset >= 0 && len >= 0 && offset + len <= input.length) {
            int padlen;
            this.bytes += (long)len;
            if (this.padding > 0 && len >= (padlen = 64 - this.padding)) {
                System.arraycopy(input, offset, this.pad, this.padding, padlen);
                this.computeBlock(this.pad, 0);
                this.padding = 0;
                offset += padlen;
                len -= padlen;
            }
            while (len >= 64) {
                this.computeBlock(input, offset);
                offset += 64;
                len -= 64;
            }
            if (len > 0) {
                System.arraycopy(input, offset, this.pad, this.padding, len);
                this.padding += len;
            }
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public byte[] engineDigest() {
        byte[] hashvalue = new byte[20];
        this.engineDigest(hashvalue, 0, hashvalue.length);
        return hashvalue;
    }

    public int engineDigest(byte[] hashvalue, int offset, int len) {
        if (len < 20) {
            throw new IllegalArgumentException("partial digests not returned");
        }
        if (hashvalue.length - offset < 20) {
            throw new IllegalArgumentException("insufficient space in output buffer to store the digest");
        }
        int temp = this.padding;
        this.pad[temp] = -128;
        switch (temp) {
            case 56: {
                this.pad[57] = 0;
            }
            case 57: {
                this.pad[58] = 0;
            }
            case 58: {
                this.pad[59] = 0;
            }
            case 59: {
                this.pad[60] = 0;
            }
            case 60: {
                this.pad[61] = 0;
            }
            case 61: {
                this.pad[62] = 0;
            }
            case 62: {
                this.pad[63] = 0;
            }
            case 63: {
                this.computeBlock(this.pad, 0);
                temp = 52;
                do {
                    this.pad[temp] = 0;
                    this.pad[temp + 1] = 0;
                    this.pad[temp + 2] = 0;
                    this.pad[temp + 3] = 0;
                } while ((temp -= 4) >= 0);
                break;
            }
            case 52: {
                this.pad[53] = 0;
            }
            case 53: {
                this.pad[54] = 0;
            }
            case 54: {
                this.pad[55] = 0;
            }
            case 55: {
                break;
            }
            default: {
                switch (temp & 3) {
                    case 3: {
                        ++temp;
                        break;
                    }
                    case 2: {
                        this.pad[(temp += 2) - 1] = 0;
                        break;
                    }
                    case 1: {
                        this.pad[(temp += 3) - 2] = 0;
                        this.pad[temp - 1] = 0;
                        break;
                    }
                    case 0: {
                        this.pad[(temp += 4) - 3] = 0;
                        this.pad[temp - 2] = 0;
                        this.pad[temp - 1] = 0;
                    }
                }
                do {
                    this.pad[temp] = 0;
                    this.pad[temp + 1] = 0;
                    this.pad[temp + 2] = 0;
                    this.pad[temp + 3] = 0;
                } while ((temp += 4) < 56);
            }
        }
        temp = (int)(this.bytes >>> 29);
        this.pad[56] = (byte)(temp >>> 24);
        this.pad[57] = (byte)(temp >>> 16);
        this.pad[58] = (byte)(temp >>> 8);
        this.pad[59] = (byte)temp;
        temp = (int)this.bytes << 3;
        this.pad[60] = (byte)(temp >>> 24);
        this.pad[61] = (byte)(temp >>> 16);
        this.pad[62] = (byte)(temp >>> 8);
        this.pad[63] = (byte)temp;
        this.computeBlock(this.pad, 0);
        hashvalue[offset] = (byte)(this.hA >>> 24);
        hashvalue[offset + 1] = (byte)(this.hA >>> 16);
        hashvalue[offset + 2] = (byte)(this.hA >>> 8);
        hashvalue[offset + 3] = (byte)this.hA;
        hashvalue[offset + 4] = (byte)(this.hB >>> 24);
        hashvalue[offset += 5] = (byte)(this.hB >>> 16);
        hashvalue[offset + 1] = (byte)(this.hB >>> 8);
        hashvalue[offset + 2] = (byte)this.hB;
        hashvalue[offset + 3] = (byte)(this.hC >>> 24);
        hashvalue[offset + 4] = (byte)(this.hC >>> 16);
        hashvalue[offset += 5] = (byte)(this.hC >>> 8);
        hashvalue[offset + 1] = (byte)this.hC;
        hashvalue[offset + 2] = (byte)(this.hD >>> 24);
        hashvalue[offset + 3] = (byte)(this.hD >>> 16);
        hashvalue[offset + 4] = (byte)(this.hD >>> 8);
        hashvalue[offset += 5] = (byte)this.hD;
        hashvalue[offset + 1] = (byte)(this.hE >>> 24);
        hashvalue[offset + 2] = (byte)(this.hE >>> 16);
        hashvalue[offset + 3] = (byte)(this.hE >>> 8);
        hashvalue[offset + 4] = (byte)this.hE;
        this.engineReset();
        return 20;
    }

    private void computeBlock(byte[] input, int offset) {
        int a = this.hA;
        int b = this.hB;
        int c = this.hC;
        int d = this.hD;
        int i00 = input[offset] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        int e = this.hE + (a << 5 | a >>> 27) + 1518500249 + (b & (c ^ d) ^ d) + i00;
        b = b << 30 | b >>> 2;
        int i01 = input[offset + 4] << 24 | (input[offset += 5] & 0xFF) << 16 | (input[offset + 1] & 0xFF) << 8 | input[offset + 2] & 0xFF;
        d += (e << 5 | e >>> 27) + 1518500249 + (a & (b ^ c) ^ c) + i01;
        a = a << 30 | a >>> 2;
        int i02 = input[offset + 3] << 24 | (input[offset + 4] & 0xFF) << 16 | (input[offset += 5] & 0xFF) << 8 | input[offset + 1] & 0xFF;
        c += (d << 5 | d >>> 27) + 1518500249 + (e & (a ^ b) ^ b) + i02;
        e = e << 30 | e >>> 2;
        int i03 = input[offset + 2] << 24 | (input[offset + 3] & 0xFF) << 16 | (input[offset + 4] & 0xFF) << 8 | input[offset += 5] & 0xFF;
        b += (c << 5 | c >>> 27) + 1518500249 + (d & (e ^ a) ^ a) + i03;
        d = d << 30 | d >>> 2;
        int i04 = input[offset + 1] << 24 | (input[offset + 2] & 0xFF) << 16 | (input[offset + 3] & 0xFF) << 8 | input[offset + 4] & 0xFF;
        a += (b << 5 | b >>> 27) + 1518500249 + (c & (d ^ e) ^ e) + i04;
        c = c << 30 | c >>> 2;
        int i05 = input[offset += 5] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        e += (a << 5 | a >>> 27) + 1518500249 + (b & (c ^ d) ^ d) + i05;
        b = b << 30 | b >>> 2;
        int i06 = input[offset + 4] << 24 | (input[offset += 5] & 0xFF) << 16 | (input[offset + 1] & 0xFF) << 8 | input[offset + 2] & 0xFF;
        d += (e << 5 | e >>> 27) + 1518500249 + (a & (b ^ c) ^ c) + i06;
        a = a << 30 | a >>> 2;
        int i07 = input[offset + 3] << 24 | (input[offset + 4] & 0xFF) << 16 | (input[offset += 5] & 0xFF) << 8 | input[offset + 1] & 0xFF;
        c += (d << 5 | d >>> 27) + 1518500249 + (e & (a ^ b) ^ b) + i07;
        e = e << 30 | e >>> 2;
        int i08 = input[offset + 2] << 24 | (input[offset + 3] & 0xFF) << 16 | (input[offset + 4] & 0xFF) << 8 | input[offset += 5] & 0xFF;
        b += (c << 5 | c >>> 27) + 1518500249 + (d & (e ^ a) ^ a) + i08;
        d = d << 30 | d >>> 2;
        int i09 = input[offset + 1] << 24 | (input[offset + 2] & 0xFF) << 16 | (input[offset + 3] & 0xFF) << 8 | input[offset + 4] & 0xFF;
        a += (b << 5 | b >>> 27) + 1518500249 + (c & (d ^ e) ^ e) + i09;
        c = c << 30 | c >>> 2;
        int i10 = input[offset += 5] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        e += (a << 5 | a >>> 27) + 1518500249 + (b & (c ^ d) ^ d) + i10;
        b = b << 30 | b >>> 2;
        int i11 = input[offset + 4] << 24 | (input[offset += 5] & 0xFF) << 16 | (input[offset + 1] & 0xFF) << 8 | input[offset + 2] & 0xFF;
        d += (e << 5 | e >>> 27) + 1518500249 + (a & (b ^ c) ^ c) + i11;
        a = a << 30 | a >>> 2;
        int i12 = input[offset + 3] << 24 | (input[offset + 4] & 0xFF) << 16 | (input[offset += 5] & 0xFF) << 8 | input[offset + 1] & 0xFF;
        c += (d << 5 | d >>> 27) + 1518500249 + (e & (a ^ b) ^ b) + i12;
        e = e << 30 | e >>> 2;
        int i13 = input[offset + 2] << 24 | (input[offset + 3] & 0xFF) << 16 | (input[offset + 4] & 0xFF) << 8 | input[offset += 5] & 0xFF;
        b += (c << 5 | c >>> 27) + 1518500249 + (d & (e ^ a) ^ a) + i13;
        d = d << 30 | d >>> 2;
        int i14 = input[offset + 1] << 24 | (input[offset + 2] & 0xFF) << 16 | (input[offset + 3] & 0xFF) << 8 | input[offset + 4] & 0xFF;
        a += (b << 5 | b >>> 27) + 1518500249 + (c & (d ^ e) ^ e) + i14;
        c = c << 30 | c >>> 2;
        int i15 = input[offset += 5] << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
        e += (a << 5 | a >>> 27) + 1518500249 + (b & (c ^ d) ^ d) + i15;
        b = b << 30 | b >>> 2;
        i00 ^= i02 ^ i08 ^ i13;
        i00 = i00 << 1 | i00 >>> 31;
        d += (e << 5 | e >>> 27) + 1518500249 + (a & (b ^ c) ^ c) + i00;
        a = a << 30 | a >>> 2;
        i01 ^= i03 ^ i09 ^ i14;
        i01 = i01 << 1 | i01 >>> 31;
        c += (d << 5 | d >>> 27) + 1518500249 + (e & (a ^ b) ^ b) + i01;
        e = e << 30 | e >>> 2;
        i02 ^= i04 ^ i10 ^ i15;
        i02 = i02 << 1 | i02 >>> 31;
        b += (c << 5 | c >>> 27) + 1518500249 + (d & (e ^ a) ^ a) + i02;
        d = d << 30 | d >>> 2;
        i03 ^= i05 ^ i11 ^ i00;
        i03 = i03 << 1 | i03 >>> 31;
        a += (b << 5 | b >>> 27) + 1518500249 + (c & (d ^ e) ^ e) + i03;
        c = c << 30 | c >>> 2;
        i04 ^= i06 ^ i12 ^ i01;
        i04 = i04 << 1 | i04 >>> 31;
        e += (a << 5 | a >>> 27) + 1859775393 + (b ^ c ^ d) + i04;
        b = b << 30 | b >>> 2;
        i05 ^= i07 ^ i13 ^ i02;
        i05 = i05 << 1 | i05 >>> 31;
        d += (e << 5 | e >>> 27) + 1859775393 + (a ^ b ^ c) + i05;
        a = a << 30 | a >>> 2;
        i06 ^= i08 ^ i14 ^ i03;
        i06 = i06 << 1 | i06 >>> 31;
        c += (d << 5 | d >>> 27) + 1859775393 + (e ^ a ^ b) + i06;
        e = e << 30 | e >>> 2;
        i07 ^= i09 ^ i15 ^ i04;
        i07 = i07 << 1 | i07 >>> 31;
        b += (c << 5 | c >>> 27) + 1859775393 + (d ^ e ^ a) + i07;
        d = d << 30 | d >>> 2;
        i08 ^= i10 ^ i00 ^ i05;
        i08 = i08 << 1 | i08 >>> 31;
        a += (b << 5 | b >>> 27) + 1859775393 + (c ^ d ^ e) + i08;
        c = c << 30 | c >>> 2;
        i09 ^= i11 ^ i01 ^ i06;
        i09 = i09 << 1 | i09 >>> 31;
        e += (a << 5 | a >>> 27) + 1859775393 + (b ^ c ^ d) + i09;
        b = b << 30 | b >>> 2;
        i10 ^= i12 ^ i02 ^ i07;
        i10 = i10 << 1 | i10 >>> 31;
        d += (e << 5 | e >>> 27) + 1859775393 + (a ^ b ^ c) + i10;
        a = a << 30 | a >>> 2;
        i11 ^= i13 ^ i03 ^ i08;
        i11 = i11 << 1 | i11 >>> 31;
        c += (d << 5 | d >>> 27) + 1859775393 + (e ^ a ^ b) + i11;
        e = e << 30 | e >>> 2;
        i12 ^= i14 ^ i04 ^ i09;
        i12 = i12 << 1 | i12 >>> 31;
        b += (c << 5 | c >>> 27) + 1859775393 + (d ^ e ^ a) + i12;
        d = d << 30 | d >>> 2;
        i13 ^= i15 ^ i05 ^ i10;
        i13 = i13 << 1 | i13 >>> 31;
        a += (b << 5 | b >>> 27) + 1859775393 + (c ^ d ^ e) + i13;
        c = c << 30 | c >>> 2;
        i14 ^= i00 ^ i06 ^ i11;
        i14 = i14 << 1 | i14 >>> 31;
        e += (a << 5 | a >>> 27) + 1859775393 + (b ^ c ^ d) + i14;
        b = b << 30 | b >>> 2;
        i15 ^= i01 ^ i07 ^ i12;
        i15 = i15 << 1 | i15 >>> 31;
        d += (e << 5 | e >>> 27) + 1859775393 + (a ^ b ^ c) + i15;
        a = a << 30 | a >>> 2;
        i00 ^= i02 ^ i08 ^ i13;
        i00 = i00 << 1 | i00 >>> 31;
        c += (d << 5 | d >>> 27) + 1859775393 + (e ^ a ^ b) + i00;
        e = e << 30 | e >>> 2;
        i01 ^= i03 ^ i09 ^ i14;
        i01 = i01 << 1 | i01 >>> 31;
        b += (c << 5 | c >>> 27) + 1859775393 + (d ^ e ^ a) + i01;
        d = d << 30 | d >>> 2;
        i02 ^= i04 ^ i10 ^ i15;
        i02 = i02 << 1 | i02 >>> 31;
        a += (b << 5 | b >>> 27) + 1859775393 + (c ^ d ^ e) + i02;
        c = c << 30 | c >>> 2;
        i03 ^= i05 ^ i11 ^ i00;
        i03 = i03 << 1 | i03 >>> 31;
        e += (a << 5 | a >>> 27) + 1859775393 + (b ^ c ^ d) + i03;
        b = b << 30 | b >>> 2;
        i04 ^= i06 ^ i12 ^ i01;
        i04 = i04 << 1 | i04 >>> 31;
        d += (e << 5 | e >>> 27) + 1859775393 + (a ^ b ^ c) + i04;
        a = a << 30 | a >>> 2;
        i05 ^= i07 ^ i13 ^ i02;
        i05 = i05 << 1 | i05 >>> 31;
        c += (d << 5 | d >>> 27) + 1859775393 + (e ^ a ^ b) + i05;
        e = e << 30 | e >>> 2;
        i06 ^= i08 ^ i14 ^ i03;
        i06 = i06 << 1 | i06 >>> 31;
        b += (c << 5 | c >>> 27) + 1859775393 + (d ^ e ^ a) + i06;
        d = d << 30 | d >>> 2;
        i07 ^= i09 ^ i15 ^ i04;
        i07 = i07 << 1 | i07 >>> 31;
        a += (b << 5 | b >>> 27) + 1859775393 + (c ^ d ^ e) + i07;
        c = c << 30 | c >>> 2;
        i08 ^= i10 ^ i00 ^ i05;
        i08 = i08 << 1 | i08 >>> 31;
        e += (a << 5 | a >>> 27) + -1894007588 + (b & c | (b | c) & d) + i08;
        b = b << 30 | b >>> 2;
        i09 ^= i11 ^ i01 ^ i06;
        i09 = i09 << 1 | i09 >>> 31;
        d += (e << 5 | e >>> 27) + -1894007588 + (a & b | (a | b) & c) + i09;
        a = a << 30 | a >>> 2;
        i10 ^= i12 ^ i02 ^ i07;
        i10 = i10 << 1 | i10 >>> 31;
        c += (d << 5 | d >>> 27) + -1894007588 + (e & a | (e | a) & b) + i10;
        e = e << 30 | e >>> 2;
        i11 ^= i13 ^ i03 ^ i08;
        i11 = i11 << 1 | i11 >>> 31;
        b += (c << 5 | c >>> 27) + -1894007588 + (d & e | (d | e) & a) + i11;
        d = d << 30 | d >>> 2;
        i12 ^= i14 ^ i04 ^ i09;
        i12 = i12 << 1 | i12 >>> 31;
        a += (b << 5 | b >>> 27) + -1894007588 + (c & d | (c | d) & e) + i12;
        c = c << 30 | c >>> 2;
        i13 ^= i15 ^ i05 ^ i10;
        i13 = i13 << 1 | i13 >>> 31;
        e += (a << 5 | a >>> 27) + -1894007588 + (b & c | (b | c) & d) + i13;
        b = b << 30 | b >>> 2;
        i14 ^= i00 ^ i06 ^ i11;
        i14 = i14 << 1 | i14 >>> 31;
        d += (e << 5 | e >>> 27) + -1894007588 + (a & b | (a | b) & c) + i14;
        a = a << 30 | a >>> 2;
        i15 ^= i01 ^ i07 ^ i12;
        i15 = i15 << 1 | i15 >>> 31;
        c += (d << 5 | d >>> 27) + -1894007588 + (e & a | (e | a) & b) + i15;
        e = e << 30 | e >>> 2;
        i00 ^= i02 ^ i08 ^ i13;
        i00 = i00 << 1 | i00 >>> 31;
        b += (c << 5 | c >>> 27) + -1894007588 + (d & e | (d | e) & a) + i00;
        d = d << 30 | d >>> 2;
        i01 ^= i03 ^ i09 ^ i14;
        i01 = i01 << 1 | i01 >>> 31;
        a += (b << 5 | b >>> 27) + -1894007588 + (c & d | (c | d) & e) + i01;
        c = c << 30 | c >>> 2;
        i02 ^= i04 ^ i10 ^ i15;
        i02 = i02 << 1 | i02 >>> 31;
        e += (a << 5 | a >>> 27) + -1894007588 + (b & c | (b | c) & d) + i02;
        b = b << 30 | b >>> 2;
        i03 ^= i05 ^ i11 ^ i00;
        i03 = i03 << 1 | i03 >>> 31;
        d += (e << 5 | e >>> 27) + -1894007588 + (a & b | (a | b) & c) + i03;
        a = a << 30 | a >>> 2;
        i04 ^= i06 ^ i12 ^ i01;
        i04 = i04 << 1 | i04 >>> 31;
        c += (d << 5 | d >>> 27) + -1894007588 + (e & a | (e | a) & b) + i04;
        e = e << 30 | e >>> 2;
        i05 ^= i07 ^ i13 ^ i02;
        i05 = i05 << 1 | i05 >>> 31;
        b += (c << 5 | c >>> 27) + -1894007588 + (d & e | (d | e) & a) + i05;
        d = d << 30 | d >>> 2;
        i06 ^= i08 ^ i14 ^ i03;
        i06 = i06 << 1 | i06 >>> 31;
        a += (b << 5 | b >>> 27) + -1894007588 + (c & d | (c | d) & e) + i06;
        c = c << 30 | c >>> 2;
        i07 ^= i09 ^ i15 ^ i04;
        i07 = i07 << 1 | i07 >>> 31;
        e += (a << 5 | a >>> 27) + -1894007588 + (b & c | (b | c) & d) + i07;
        b = b << 30 | b >>> 2;
        i08 ^= i10 ^ i00 ^ i05;
        i08 = i08 << 1 | i08 >>> 31;
        d += (e << 5 | e >>> 27) + -1894007588 + (a & b | (a | b) & c) + i08;
        a = a << 30 | a >>> 2;
        i09 ^= i11 ^ i01 ^ i06;
        i09 = i09 << 1 | i09 >>> 31;
        c += (d << 5 | d >>> 27) + -1894007588 + (e & a | (e | a) & b) + i09;
        e = e << 30 | e >>> 2;
        i10 ^= i12 ^ i02 ^ i07;
        i10 = i10 << 1 | i10 >>> 31;
        b += (c << 5 | c >>> 27) + -1894007588 + (d & e | (d | e) & a) + i10;
        d = d << 30 | d >>> 2;
        i11 ^= i13 ^ i03 ^ i08;
        i11 = i11 << 1 | i11 >>> 31;
        a += (b << 5 | b >>> 27) + -1894007588 + (c & d | (c | d) & e) + i11;
        c = c << 30 | c >>> 2;
        i12 ^= i14 ^ i04 ^ i09;
        i12 = i12 << 1 | i12 >>> 31;
        e += (a << 5 | a >>> 27) + -899497514 + (b ^ c ^ d) + i12;
        b = b << 30 | b >>> 2;
        i13 ^= i15 ^ i05 ^ i10;
        i13 = i13 << 1 | i13 >>> 31;
        d += (e << 5 | e >>> 27) + -899497514 + (a ^ b ^ c) + i13;
        a = a << 30 | a >>> 2;
        i14 ^= i00 ^ i06 ^ i11;
        i14 = i14 << 1 | i14 >>> 31;
        c += (d << 5 | d >>> 27) + -899497514 + (e ^ a ^ b) + i14;
        e = e << 30 | e >>> 2;
        i15 ^= i01 ^ i07 ^ i12;
        i15 = i15 << 1 | i15 >>> 31;
        b += (c << 5 | c >>> 27) + -899497514 + (d ^ e ^ a) + i15;
        d = d << 30 | d >>> 2;
        i00 ^= i02 ^ i08 ^ i13;
        i00 = i00 << 1 | i00 >>> 31;
        a += (b << 5 | b >>> 27) + -899497514 + (c ^ d ^ e) + i00;
        c = c << 30 | c >>> 2;
        i01 ^= i03 ^ i09 ^ i14;
        i01 = i01 << 1 | i01 >>> 31;
        e += (a << 5 | a >>> 27) + -899497514 + (b ^ c ^ d) + i01;
        b = b << 30 | b >>> 2;
        i02 ^= i04 ^ i10 ^ i15;
        i02 = i02 << 1 | i02 >>> 31;
        d += (e << 5 | e >>> 27) + -899497514 + (a ^ b ^ c) + i02;
        a = a << 30 | a >>> 2;
        i03 ^= i05 ^ i11 ^ i00;
        i03 = i03 << 1 | i03 >>> 31;
        c += (d << 5 | d >>> 27) + -899497514 + (e ^ a ^ b) + i03;
        e = e << 30 | e >>> 2;
        i04 ^= i06 ^ i12 ^ i01;
        i04 = i04 << 1 | i04 >>> 31;
        b += (c << 5 | c >>> 27) + -899497514 + (d ^ e ^ a) + i04;
        d = d << 30 | d >>> 2;
        i05 ^= i07 ^ i13 ^ i02;
        i05 = i05 << 1 | i05 >>> 31;
        a += (b << 5 | b >>> 27) + -899497514 + (c ^ d ^ e) + i05;
        c = c << 30 | c >>> 2;
        i06 ^= i08 ^ i14 ^ i03;
        i06 = i06 << 1 | i06 >>> 31;
        e += (a << 5 | a >>> 27) + -899497514 + (b ^ c ^ d) + i06;
        b = b << 30 | b >>> 2;
        i07 ^= i09 ^ i15 ^ i04;
        i07 = i07 << 1 | i07 >>> 31;
        d += (e << 5 | e >>> 27) + -899497514 + (a ^ b ^ c) + i07;
        a = a << 30 | a >>> 2;
        i08 ^= i10 ^ i00 ^ i05;
        i08 = i08 << 1 | i08 >>> 31;
        c += (d << 5 | d >>> 27) + -899497514 + (e ^ a ^ b) + i08;
        e = e << 30 | e >>> 2;
        i09 ^= i11 ^ i01 ^ i06;
        i09 = i09 << 1 | i09 >>> 31;
        b += (c << 5 | c >>> 27) + -899497514 + (d ^ e ^ a) + i09;
        d = d << 30 | d >>> 2;
        i10 ^= i12 ^ i02 ^ i07;
        i10 = i10 << 1 | i10 >>> 31;
        a += (b << 5 | b >>> 27) + -899497514 + (c ^ d ^ e) + i10;
        c = c << 30 | c >>> 2;
        i11 ^= i13 ^ i03 ^ i08;
        i11 = i11 << 1 | i11 >>> 31;
        e += (a << 5 | a >>> 27) + -899497514 + (b ^ c ^ d) + i11;
        b = b << 30 | b >>> 2;
        i12 ^= i14 ^ i04 ^ i09;
        i12 = i12 << 1 | i12 >>> 31;
        d += (e << 5 | e >>> 27) + -899497514 + (a ^ b ^ c) + i12;
        a = a << 30 | a >>> 2;
        i13 ^= i15 ^ i05 ^ i10;
        i13 = i13 << 1 | i13 >>> 31;
        c += (d << 5 | d >>> 27) + -899497514 + (e ^ a ^ b) + i13;
        e = e << 30 | e >>> 2;
        i14 ^= i00 ^ i06 ^ i11;
        i14 = i14 << 1 | i14 >>> 31;
        this.hB += (b += (c << 5 | c >>> 27) + -899497514 + (d ^ e ^ a) + i14);
        d = d << 30 | d >>> 2;
        i15 ^= i01 ^ i07 ^ i12;
        i15 = i15 << 1 | i15 >>> 31;
        this.hA += (a += (b << 5 | b >>> 27) + -899497514 + (c ^ d ^ e) + i15);
        this.hE += e;
        this.hD += d;
        this.hC += c << 30 | c >>> 2;
    }
}

