/*
 * Decompiled with CFR 0.152.
 */
package org.avis.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.avis.io.XdrCoding;
import org.avis.security.DualKeyScheme;
import org.avis.security.DualKeySet;
import org.avis.security.Key;
import org.avis.security.KeyScheme;
import org.avis.security.KeySet;
import org.avis.security.SingleKeyScheme;
import org.avis.security.SingleKeySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Keys {
    public static final Keys EMPTY_KEYS = new EmptyKeys();
    private static final DualKeySet EMPTY_DUAL_KEYSET = new DualKeySet(true);
    private static final SingleKeySet EMPTY_SINGLE_KEYSET = new EmptySingleKeys();
    private Map<KeyScheme, KeySet> keySets = new HashMap<KeyScheme, KeySet>(4);

    public Keys() {
    }

    public Keys(Keys keys) {
        this();
        this.add(keys);
    }

    public boolean isEmpty() {
        return this.keySets.isEmpty();
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        int size = 0;
        for (KeySet keyset : this.keySets.values()) {
            size += keyset.size();
        }
        return size;
    }

    public Keys addedTo(Keys keys) {
        if (keys.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return keys;
        }
        Keys newKeys = new Keys(this);
        newKeys.add(keys);
        return newKeys;
    }

    public void add(SingleKeyScheme scheme, Key key) {
        this.newKeysetFor(scheme).add(key);
    }

    public void remove(SingleKeyScheme scheme, Key key) throws IllegalArgumentException {
        KeySet keys = this.keySets.get(scheme);
        if (keys != null) {
            keys.remove(key);
            if (keys.isEmpty()) {
                this.keySets.remove(scheme);
            }
        }
    }

    public void add(DualKeyScheme scheme, DualKeyScheme.Subset subset, Key key) throws IllegalArgumentException {
        this.newKeysetFor(scheme).keysFor(subset).add(key);
    }

    public void remove(DualKeyScheme scheme, DualKeyScheme.Subset subset, Key key) {
        DualKeySet keySet = (DualKeySet)this.keySets.get(scheme);
        if (keySet != null) {
            keySet.keysFor(subset).remove(key);
            if (keySet.isEmpty()) {
                this.keySets.remove(scheme);
            }
        }
    }

    public void add(Keys keys) {
        if (keys == this) {
            throw new IllegalArgumentException("Cannot add key collection to itself");
        }
        for (KeyScheme scheme : keys.keySets.keySet()) {
            this.add(scheme, keys.keySets.get(scheme));
        }
    }

    private void add(KeyScheme scheme, KeySet keys) {
        if (!keys.isEmpty()) {
            this.newKeysetFor(scheme).add(keys);
        }
    }

    public void remove(Keys keys) {
        if (keys == this) {
            throw new IllegalArgumentException("Cannot remove key collection from itself");
        }
        for (KeyScheme scheme : keys.keySets.keySet()) {
            KeySet myKeys = this.keySets.get(scheme);
            if (myKeys == null) continue;
            myKeys.remove(keys.keysetFor(scheme));
            if (!myKeys.isEmpty()) continue;
            this.keySets.remove(scheme);
        }
    }

    public Keys delta(Keys toAdd, Keys toRemove) {
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            return this;
        }
        Keys keys = new Keys(this);
        keys.add(toAdd);
        keys.remove(toRemove);
        return keys;
    }

    public Delta deltaFrom(Keys keys) {
        if (keys == this) {
            return Delta.EMPTY_DELTA;
        }
        Keys addedKeys = new Keys();
        Keys removedKeys = new Keys();
        for (KeyScheme scheme : KeyScheme.schemes()) {
            KeySet existingKeyset = this.keysetFor(scheme);
            KeySet otherKeyset = keys.keysetFor(scheme);
            addedKeys.add(scheme, otherKeyset.subtract(existingKeyset));
            removedKeys.add(scheme, existingKeyset.subtract(otherKeyset));
        }
        return new Delta(addedKeys, removedKeys);
    }

    private KeySet keysetFor(KeyScheme scheme) {
        KeySet keys = this.keySets.get(scheme);
        if (keys == null) {
            return scheme.isDual() ? EMPTY_DUAL_KEYSET : EMPTY_SINGLE_KEYSET;
        }
        return keys;
    }

    DualKeySet keysetFor(DualKeyScheme scheme) {
        DualKeySet keys = (DualKeySet)this.keySets.get(scheme);
        if (keys == null) {
            return EMPTY_DUAL_KEYSET;
        }
        return keys;
    }

    SingleKeySet keysetFor(SingleKeyScheme scheme) {
        SingleKeySet keys = (SingleKeySet)this.keySets.get(scheme);
        if (keys == null) {
            return EMPTY_SINGLE_KEYSET;
        }
        return keys;
    }

    private KeySet newKeysetFor(KeyScheme scheme) {
        if (scheme.isDual()) {
            return this.newKeysetFor((DualKeyScheme)scheme);
        }
        return this.newKeysetFor((SingleKeyScheme)scheme);
    }

    private SingleKeySet newKeysetFor(SingleKeyScheme scheme) {
        SingleKeySet keys = (SingleKeySet)this.keySets.get(scheme);
        if (keys == null) {
            keys = new SingleKeySet();
            this.keySets.put(scheme, keys);
        }
        return keys;
    }

    private DualKeySet newKeysetFor(DualKeyScheme scheme) {
        DualKeySet keys = (DualKeySet)this.keySets.get(scheme);
        if (keys == null) {
            keys = new DualKeySet();
            this.keySets.put(scheme, keys);
        }
        return keys;
    }

    public boolean match(Keys producerKeys) {
        if (this.isEmpty() || producerKeys.isEmpty()) {
            return false;
        }
        for (Map.Entry<KeyScheme, KeySet> entry : producerKeys.keySets.entrySet()) {
            KeyScheme scheme = entry.getKey();
            KeySet keyset = entry.getValue();
            if (!this.keySets.containsKey(scheme) || !scheme.match(keyset, this.keySets.get(scheme))) continue;
            return true;
        }
        return false;
    }

    public void encode(ByteBuffer out) {
        out.putInt(this.keySets.size());
        for (Map.Entry<KeyScheme, KeySet> entry : this.keySets.entrySet()) {
            KeyScheme scheme = entry.getKey();
            KeySet keySet = entry.getValue();
            out.putInt(scheme.id);
            if (scheme.isDual()) {
                DualKeySet dualKeySet = (DualKeySet)keySet;
                out.putInt(2);
                Keys.encodeKeys(out, dualKeySet.producerKeys);
                Keys.encodeKeys(out, dualKeySet.consumerKeys);
                continue;
            }
            out.putInt(1);
            Keys.encodeKeys(out, (SingleKeySet)keySet);
        }
    }

    public static Keys decode(ByteBuffer in) throws ProtocolCodecException {
        int length = in.getInt();
        if (length == 0) {
            return EMPTY_KEYS;
        }
        try {
            Keys keys = new Keys();
            while (length > 0) {
                KeyScheme scheme = KeyScheme.schemeFor(in.getInt());
                int keySetCount = in.getInt();
                if (scheme.isDual()) {
                    if (keySetCount != 2) {
                        throw new ProtocolCodecException("Dual key scheme with " + keySetCount + " key sets");
                    }
                    DualKeySet keyset = keys.newKeysetFor((DualKeyScheme)scheme);
                    Keys.decodeKeys(in, keyset.producerKeys);
                    Keys.decodeKeys(in, keyset.consumerKeys);
                } else {
                    if (keySetCount != 1) {
                        throw new ProtocolCodecException("Single key scheme with " + keySetCount + " key sets");
                    }
                    Keys.decodeKeys(in, keys.newKeysetFor((SingleKeyScheme)scheme));
                }
                --length;
            }
            return keys;
        }
        catch (IllegalArgumentException ex) {
            throw new ProtocolCodecException(ex);
        }
    }

    private static void encodeKeys(ByteBuffer out, Set<Key> keys) {
        out.putInt(keys.size());
        for (Key key : keys) {
            XdrCoding.putBytes(out, key.data);
        }
    }

    private static void decodeKeys(ByteBuffer in, Set<Key> keys) throws ProtocolCodecException {
        for (int keysetCount = in.getInt(); keysetCount > 0; --keysetCount) {
            keys.add(new Key(XdrCoding.getBytes(in)));
        }
    }

    public boolean equals(Object object) {
        return object instanceof Keys && this.equals((Keys)object);
    }

    public boolean equals(Keys keys) {
        if (this.keySets.size() != keys.keySets.size()) {
            return false;
        }
        for (KeyScheme scheme : keys.keySets.keySet()) {
            if (this.keysetFor(scheme).equals(keys.keysetFor(scheme))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (KeyScheme scheme : this.keySets.keySet()) {
            hash ^= 1 << scheme.id;
        }
        return hash;
    }

    static class EmptyKeys
    extends Keys {
        EmptyKeys() {
        }

        public void add(Keys keys) {
            throw new UnsupportedOperationException();
        }

        public void remove(Keys keys) {
            throw new UnsupportedOperationException();
        }

        public void add(SingleKeyScheme scheme, Key key) {
            throw new UnsupportedOperationException();
        }

        public void remove(SingleKeyScheme scheme, Key key) {
            throw new UnsupportedOperationException();
        }

        public void add(DualKeyScheme scheme, DualKeyScheme.Subset subset, Key key) {
            throw new UnsupportedOperationException();
        }

        public void remove(DualKeyScheme scheme, DualKeyScheme.Subset subset, Key key) {
            throw new UnsupportedOperationException();
        }
    }

    static class EmptySingleKeys
    extends SingleKeySet {
        EmptySingleKeys() {
        }

        public boolean add(Key key) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        public void add(KeySet keys) throws IllegalArgumentException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Key key) throws IllegalArgumentException, UnsupportedOperationException {
            return false;
        }

        public void remove(KeySet keys) throws IllegalArgumentException {
        }
    }

    public static class Delta {
        public static final Delta EMPTY_DELTA = new Delta(EMPTY_KEYS, EMPTY_KEYS);
        public final Keys added;
        public final Keys removed;

        Delta(Keys added, Keys removed) {
            this.added = added;
            this.removed = removed;
        }

        public boolean isEmpty() {
            return this.added.isEmpty() && this.removed.isEmpty();
        }
    }
}

