/*
 * Decompiled with CFR 0.152.
 */
package org.avis.security;

import java.util.Arrays;
import org.avis.io.XdrCoding;
import org.avis.security.KeyScheme;

public final class Key {
    public final byte[] data;
    private int hash;

    public Key(String password) {
        this(XdrCoding.toUTF8(password));
    }

    public Key(byte[] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Key data cannot be empty");
        }
        this.data = data;
        this.hash = Arrays.hashCode(data);
    }

    public Key publicKeyFor(KeyScheme scheme) {
        return scheme.publicKeyFor(this);
    }

    public boolean equals(Object object) {
        return object instanceof Key && this.equals((Key)object);
    }

    public boolean equals(Key key) {
        return this.hash == key.hash && Arrays.equals(this.data, key.data);
    }

    public int hashCode() {
        return this.hash;
    }
}

