/*
 * Decompiled with CFR 0.152.
 */
package org.avis.security;

import java.util.HashSet;
import java.util.Set;
import org.avis.security.DualKeyScheme;
import org.avis.security.Key;
import org.avis.security.KeySet;
import org.avis.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DualKeySet
implements KeySet {
    public final Set<Key> producerKeys;
    public final Set<Key> consumerKeys;

    DualKeySet() {
        this.producerKeys = new HashSet<Key>();
        this.consumerKeys = new HashSet<Key>();
    }

    DualKeySet(boolean immutable) {
        this.producerKeys = java.util.Collections.emptySet();
        this.consumerKeys = java.util.Collections.emptySet();
    }

    DualKeySet(Set<Key> producerKeys, Set<Key> consumerKeys) {
        this.producerKeys = producerKeys;
        this.consumerKeys = consumerKeys;
    }

    public Set<Key> keysFor(DualKeyScheme.Subset subset) {
        if (subset == DualKeyScheme.Subset.PRODUCER) {
            return this.producerKeys;
        }
        return this.consumerKeys;
    }

    @Override
    public boolean isEmpty() {
        return this.producerKeys.isEmpty() && this.consumerKeys.isEmpty();
    }

    @Override
    public int size() {
        return this.producerKeys.size() + this.consumerKeys.size();
    }

    @Override
    public void add(KeySet theKeys) throws IllegalArgumentException {
        DualKeySet keys = (DualKeySet)theKeys;
        this.producerKeys.addAll(keys.producerKeys);
        this.consumerKeys.addAll(keys.consumerKeys);
    }

    @Override
    public void remove(KeySet theKeys) throws IllegalArgumentException {
        DualKeySet keys = (DualKeySet)theKeys;
        this.producerKeys.removeAll(keys.producerKeys);
        this.consumerKeys.removeAll(keys.consumerKeys);
    }

    @Override
    public boolean add(Key key) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot add to a dual key set");
    }

    @Override
    public boolean remove(Key key) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove from a dual key set");
    }

    @Override
    public KeySet subtract(KeySet theKeys) {
        DualKeySet keys = (DualKeySet)theKeys;
        return new DualKeySet(Collections.difference(this.producerKeys, keys.producerKeys), Collections.difference(this.consumerKeys, keys.consumerKeys));
    }

    public boolean equals(Object object) {
        return object instanceof DualKeySet && this.equals((DualKeySet)object);
    }

    public boolean equals(DualKeySet keyset) {
        return ((Object)this.producerKeys).equals(keyset.producerKeys) && ((Object)this.consumerKeys).equals(keyset.consumerKeys);
    }

    public int hashCode() {
        return ((Object)this.producerKeys).hashCode() ^ ((Object)this.consumerKeys).hashCode();
    }
}

