/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.avis.io.SharedExecutor;
import org.avis.io.messages.ErrorMessage;
import org.avis.io.messages.Message;
import org.avis.io.messages.RequestMessage;
import org.avis.io.messages.RequestTimeoutMessage;
import org.avis.io.messages.XidMessage;

public class RequestTrackingFilter
extends IoFilterAdapter
implements IoFilter {
    protected ScheduledExecutorService executor;
    protected long replyTimeout;
    protected String filterName;

    public RequestTrackingFilter(long replyTimeout) {
        this(null, replyTimeout);
    }

    public RequestTrackingFilter(ScheduledExecutorService executor, long replyTimeout) {
        this.executor = executor;
        this.replyTimeout = replyTimeout;
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (this.executor == null) {
            this.executor = SharedExecutor.acquire();
        }
        this.filterName = name;
    }

    public void filterClose(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        nextFilter.filterClose(session);
        if (SharedExecutor.release(this.executor)) {
            this.executor = null;
        }
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        nextFilter.sessionCreated(session);
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        session.setAttribute("requestTracker", new Tracker(session));
        nextFilter.sessionOpened(session);
    }

    private static Tracker trackerFor(IoSession session) {
        return (Tracker)session.getAttribute("requestTracker");
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        Tracker tracker = RequestTrackingFilter.trackerFor(session);
        if (tracker != null) {
            tracker.dispose();
        }
        nextFilter.sessionClosed(session);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        if (message instanceof RequestMessage) {
            RequestTrackingFilter.trackerFor(session).add((RequestMessage)message);
        }
        nextFilter.filterWrite(session, writeRequest);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (message instanceof XidMessage && !(message instanceof RequestMessage)) {
            XidMessage reply = (XidMessage)message;
            try {
                reply.request = RequestTrackingFilter.trackerFor(session).remove(reply);
            }
            catch (IllegalArgumentException ex) {
                message = new ErrorMessage(ex, reply);
            }
        }
        nextFilter.messageReceived(session, message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Request {
        public RequestMessage<?> message;
        public long sentAt;

        public Request(RequestMessage<?> request) {
            this.message = request;
            this.sentAt = System.currentTimeMillis();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Tracker
    implements Runnable {
        private IoSession session;
        private Map<Integer, Request> xidToRequest;
        private ScheduledFuture<?> replyFuture;

        public Tracker(IoSession session) {
            this.session = session;
            this.xidToRequest = new HashMap<Integer, Request>();
        }

        public synchronized void dispose() {
            this.cancelReplyCheck();
        }

        public synchronized void add(RequestMessage<?> request) {
            this.xidToRequest.put(request.xid, new Request(request));
            this.scheduleReplyCheck(RequestTrackingFilter.this.replyTimeout);
        }

        public synchronized RequestMessage<?> remove(XidMessage reply) {
            Request request = this.xidToRequest.remove(reply.xid);
            if (request == null) {
                throw new IllegalArgumentException("Reply with unknown XID " + reply.xid);
            }
            return request.message;
        }

        private void cancelReplyCheck() {
            if (this.replyFuture != null) {
                this.replyFuture.cancel(false);
                this.replyFuture = null;
            }
        }

        private void scheduleReplyCheck(long delay) {
            if (this.replyFuture == null) {
                this.replyFuture = RequestTrackingFilter.this.executor.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public synchronized void run() {
            long now;
            this.replyFuture = null;
            long earliestTimeout = now = System.currentTimeMillis();
            Iterator<Map.Entry<Integer, Request>> i = this.xidToRequest.entrySet().iterator();
            while (i.hasNext()) {
                Request request = i.next().getValue();
                if (now - request.sentAt >= RequestTrackingFilter.this.replyTimeout) {
                    i.remove();
                    this.injectMessage(new RequestTimeoutMessage(request.message));
                    continue;
                }
                earliestTimeout = Math.min(earliestTimeout, request.sentAt);
            }
            if (!this.xidToRequest.isEmpty()) {
                this.scheduleReplyCheck(RequestTrackingFilter.this.replyTimeout - (now - earliestTimeout));
            }
        }

        private void injectMessage(Message message) {
            IoFilter.NextFilter filter = this.session.getFilterChain().getNextFilter(RequestTrackingFilter.this.filterName);
            filter.messageReceived(this.session, message);
        }
    }
}

