/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.avis.common.ElvinURI;
import org.avis.common.InvalidURIException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Net {
    private Net() {
    }

    public static String localHostName() throws IOException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static Set<InetSocketAddress> addressesFor(Set<? extends ElvinURI> uris) throws IOException, SocketException, UnknownHostException {
        HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
        for (ElvinURI elvinURI : uris) {
            Net.addAddressFor(addresses, elvinURI);
        }
        return addresses;
    }

    public static Set<InetSocketAddress> addressesFor(ElvinURI uri) throws IOException, SocketException, UnknownHostException {
        HashSet<InetSocketAddress> addresses = new HashSet<InetSocketAddress>();
        Net.addAddressFor(addresses, uri);
        return addresses;
    }

    private static void addAddressFor(Set<InetSocketAddress> addresses, ElvinURI uri) throws SocketException, IOException, UnknownHostException {
        Collection<InetAddress> inetAddresses = uri.host.startsWith("!") ? Net.addressesForInterface(uri.host.substring(1)) : Net.addressesForHost(uri.host);
        for (InetAddress address : inetAddresses) {
            if (address.isAnyLocalAddress()) {
                addresses.add(new InetSocketAddress(uri.port));
                continue;
            }
            if (address.isLinkLocalAddress()) continue;
            addresses.add(new InetSocketAddress(address, uri.port));
        }
    }

    private static Collection<InetAddress> addressesForHost(String host) throws UnknownHostException {
        return Arrays.asList(InetAddress.getAllByName(host));
    }

    private static Collection<InetAddress> addressesForInterface(String name) throws SocketException, IOException {
        NetworkInterface netInterface = NetworkInterface.getByName(name);
        if (netInterface == null) {
            throw new IOException("Unknown interface name \"" + name + "\"");
        }
        HashSet<InetAddress> addresses = new HashSet<InetAddress>();
        Enumeration<InetAddress> i = netInterface.getInetAddresses();
        while (i.hasMoreElements()) {
            addresses.add(i.nextElement());
        }
        return addresses;
    }

    public static InetAddress remoteHostAddressFor(IoSession session) {
        if (session.getRemoteAddress() instanceof InetSocketAddress) {
            return ((InetSocketAddress)session.getRemoteAddress()).getAddress();
        }
        throw new Error("Can't get host name for address type " + session.getRemoteAddress().getClass());
    }

    public static String hostIdFor(IoSession session) {
        InetAddress address = Net.remoteHostAddressFor(session);
        return address.getCanonicalHostName() + '/' + address.getHostAddress();
    }

    public static boolean enableTcpNoDelay(IoSession session, boolean noDelay) {
        if (session.getConfig() instanceof SocketSessionConfig) {
            ((SocketSessionConfig)session.getConfig()).setTcpNoDelay(noDelay);
            return true;
        }
        return false;
    }

    public static URI uri(String uriString) throws InvalidURIException {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException ex) {
            throw new InvalidURIException(ex);
        }
    }
}

