/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io;

import java.nio.BufferUnderflowException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.avis.io.FrameTooLargeException;
import org.avis.io.messages.ErrorMessage;
import org.avis.io.messages.Message;
import org.avis.io.messages.XidMessage;

public abstract class FrameCodec
extends CumulativeProtocolDecoder
implements ProtocolEncoder {
    public void encode(IoSession session, Object messageObject, ProtocolEncoderOutput out) throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        buffer.setAutoExpand(true);
        buffer.position(4);
        Message message = (Message)messageObject;
        buffer.putInt(message.typeId());
        message.encode(buffer);
        int frameSize = buffer.position() - 4;
        buffer.putInt(0, frameSize);
        if (frameSize % 4 != 0) {
            throw new ProtocolCodecException("Frame length not 4 byte aligned for " + message.getClass());
        }
        int maxLength = FrameCodec.maxFrameLengthFor(session);
        if (frameSize > maxLength) {
            throw new FrameTooLargeException(maxLength, frameSize);
        }
        buffer.flip();
        out.write(buffer);
    }

    protected boolean doDecode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (session.getAttribute("protocolViolation") != null) {
            return false;
        }
        if (!FrameCodec.haveFullFrame(session, in)) {
            return false;
        }
        int maxLength = FrameCodec.maxFrameLengthFor(session);
        int frameSize = in.getInt();
        int dataStart = in.position();
        Message message = null;
        try {
            int messageType = in.getInt();
            message = this.newMessage(messageType, frameSize);
            if (frameSize % 4 != 0) {
                throw new ProtocolCodecException("Frame length not 4 byte aligned");
            }
            if (frameSize > maxLength) {
                throw new FrameTooLargeException(maxLength, frameSize);
            }
            message.decode(in);
            int bytesRead = in.position() - dataStart;
            if (bytesRead != frameSize) {
                throw new ProtocolCodecException("Some input not read for " + message.name() + ": " + "Frame header said " + frameSize + " bytes, but only read " + bytesRead);
            }
            out.write(message);
            return true;
        }
        catch (Exception ex) {
            if (ex instanceof ProtocolCodecException || ex instanceof BufferUnderflowException || ex instanceof FrameTooLargeException) {
                int xid;
                session.setAttribute("protocolViolation");
                session.suspendRead();
                ErrorMessage error = new ErrorMessage(ex, message);
                if (message instanceof XidMessage && in.limit() >= 12 && (xid = in.getInt(8)) > 0) {
                    ((XidMessage)message).xid = xid;
                }
                out.write(error);
                return true;
            }
            throw (RuntimeException)ex;
        }
    }

    protected abstract Message newMessage(int var1, int var2) throws ProtocolCodecException;

    private static boolean haveFullFrame(IoSession session, ByteBuffer in) {
        boolean haveFrame;
        if (in.remaining() < 8) {
            return false;
        }
        int start = in.position();
        int frameSize = in.getInt();
        if (frameSize > FrameCodec.maxFrameLengthFor(session)) {
            haveFrame = true;
        } else if (in.remaining() < frameSize) {
            if (in.capacity() < frameSize + 4) {
                int limit = in.limit();
                in.expand(frameSize);
                in.limit(limit);
            }
            haveFrame = false;
        } else {
            haveFrame = true;
        }
        in.position(start);
        return haveFrame;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    public static void setMaxFrameLengthFor(IoSession session, int length) {
        session.setAttribute("maxFrameLength", length);
    }

    private static int maxFrameLengthFor(IoSession session) {
        Integer length = (Integer)session.getAttribute("maxFrameLength");
        if (length == null) {
            return Integer.MAX_VALUE;
        }
        return length;
    }
}

