/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io;

import org.apache.mina.common.IoFilter;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.avis.io.FrameCodec;
import org.avis.io.messages.ConfConn;
import org.avis.io.messages.ConnRply;
import org.avis.io.messages.ConnRqst;
import org.avis.io.messages.Disconn;
import org.avis.io.messages.DisconnRply;
import org.avis.io.messages.DisconnRqst;
import org.avis.io.messages.DropWarn;
import org.avis.io.messages.Message;
import org.avis.io.messages.Nack;
import org.avis.io.messages.NotifyDeliver;
import org.avis.io.messages.NotifyEmit;
import org.avis.io.messages.QuenchPlaceHolder;
import org.avis.io.messages.SecRply;
import org.avis.io.messages.SecRqst;
import org.avis.io.messages.SubAddRqst;
import org.avis.io.messages.SubDelRqst;
import org.avis.io.messages.SubModRqst;
import org.avis.io.messages.SubRply;
import org.avis.io.messages.TestConn;
import org.avis.io.messages.UNotify;

public class ClientFrameCodec
extends FrameCodec
implements ProtocolCodecFactory {
    public static final ClientFrameCodec INSTANCE = new ClientFrameCodec();
    public static final IoFilter FILTER = new ProtocolCodecFilter(INSTANCE);

    public ProtocolEncoder getEncoder() throws Exception {
        return INSTANCE;
    }

    public ProtocolDecoder getDecoder() throws Exception {
        return INSTANCE;
    }

    protected Message newMessage(int messageType, int frameSize) throws ProtocolCodecException {
        switch (messageType) {
            case 49: {
                return new ConnRqst();
            }
            case 50: {
                return new ConnRply();
            }
            case 51: {
                return new DisconnRqst();
            }
            case 52: {
                return new DisconnRply();
            }
            case 53: {
                return new Disconn();
            }
            case 58: {
                return new SubAddRqst();
            }
            case 61: {
                return new SubRply();
            }
            case 59: {
                return new SubModRqst();
            }
            case 60: {
                return new SubDelRqst();
            }
            case 48: {
                return new Nack();
            }
            case 57: {
                return new NotifyDeliver();
            }
            case 56: {
                return new NotifyEmit();
            }
            case 63: {
                return TestConn.INSTANCE;
            }
            case 64: {
                return ConfConn.INSTANCE;
            }
            case 54: {
                return new SecRqst();
            }
            case 55: {
                return new SecRply();
            }
            case 32: {
                return new UNotify();
            }
            case 62: {
                return new DropWarn();
            }
            case 80: 
            case 81: 
            case 82: {
                return new QuenchPlaceHolder(messageType, frameSize - 4);
            }
        }
        throw new ProtocolCodecException("Unknown message type: ID = " + messageType);
    }
}

