/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation.io;

import java.util.ArrayList;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.avis.io.XdrCoding;
import org.avis.subscription.ast.IllegalChildException;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.And;
import org.avis.subscription.ast.nodes.Compare;
import org.avis.subscription.ast.nodes.Const;
import org.avis.subscription.ast.nodes.Field;
import org.avis.subscription.ast.nodes.MathBitAnd;
import org.avis.subscription.ast.nodes.MathBitInvert;
import org.avis.subscription.ast.nodes.MathBitLogShiftRight;
import org.avis.subscription.ast.nodes.MathBitOr;
import org.avis.subscription.ast.nodes.MathBitShiftLeft;
import org.avis.subscription.ast.nodes.MathBitShiftRight;
import org.avis.subscription.ast.nodes.MathBitXor;
import org.avis.subscription.ast.nodes.MathDiv;
import org.avis.subscription.ast.nodes.MathMinus;
import org.avis.subscription.ast.nodes.MathMod;
import org.avis.subscription.ast.nodes.MathMult;
import org.avis.subscription.ast.nodes.MathPlus;
import org.avis.subscription.ast.nodes.MathUnaryMinus;
import org.avis.subscription.ast.nodes.Nan;
import org.avis.subscription.ast.nodes.Not;
import org.avis.subscription.ast.nodes.Or;
import org.avis.subscription.ast.nodes.Require;
import org.avis.subscription.ast.nodes.Size;
import org.avis.subscription.ast.nodes.StrBeginsWith;
import org.avis.subscription.ast.nodes.StrContains;
import org.avis.subscription.ast.nodes.StrEndsWith;
import org.avis.subscription.ast.nodes.StrFoldCase;
import org.avis.subscription.ast.nodes.StrRegex;
import org.avis.subscription.ast.nodes.StrUnicodeDecompose;
import org.avis.subscription.ast.nodes.StrWildcard;
import org.avis.subscription.ast.nodes.Type;
import org.avis.subscription.ast.nodes.Xor;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XdrAstParser {
    private ByteBuffer in;

    public XdrAstParser(ByteBuffer in) {
        this.in = in;
    }

    public Node expr() throws ProtocolCodecException, IllegalChildException {
        int type = this.in.getInt();
        if (type == 0) {
            return Const.CONST_FALSE;
        }
        int leafType = this.in.getInt();
        if (type > 5 && leafType != 0) {
            throw new ProtocolCodecException("Invalid leaf type for parent node: " + leafType);
        }
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.leaf(type, leafType);
            }
            case 6: {
                return StrRegex.create(this.children());
            }
            case 8: {
                return new Compare(this.binary().expr(), this.expr(), 0, true);
            }
            case 9: {
                return new Not(new Compare(this.binary().expr(), this.expr(), 0, true));
            }
            case 10: {
                return new Compare(this.binary().expr(), this.expr(), -1, false);
            }
            case 11: {
                return new Compare(this.binary().expr(), this.expr(), -1, true);
            }
            case 12: {
                return new Compare(this.binary().expr(), this.expr(), 1, false);
            }
            case 13: {
                return new Compare(this.binary().expr(), this.expr(), 1, true);
            }
            case 16: {
                return new Or(this.children());
            }
            case 17: {
                return new Xor(this.children());
            }
            case 18: {
                return new And(this.children());
            }
            case 19: {
                return new Not(this.single().expr());
            }
            case 24: {
                return this.single().expr();
            }
            case 25: {
                return new MathUnaryMinus(this.single().expr());
            }
            case 26: {
                return new MathMult(this.binary().expr(), this.expr());
            }
            case 27: {
                return new MathDiv(this.binary().expr(), this.expr());
            }
            case 28: {
                return new MathMod(this.binary().expr(), this.expr());
            }
            case 29: {
                return new MathPlus(this.binary().expr(), this.expr());
            }
            case 30: {
                return new MathMinus(this.binary().expr(), this.expr());
            }
            case 32: {
                return new MathBitShiftLeft(this.binary().expr(), this.expr());
            }
            case 33: {
                return new MathBitShiftRight(this.binary().expr(), this.expr());
            }
            case 34: {
                return new MathBitLogShiftRight(this.binary().expr(), this.expr());
            }
            case 35: {
                return new MathBitAnd(this.binary().expr(), this.expr());
            }
            case 36: {
                return new MathBitXor(this.binary().expr(), this.expr());
            }
            case 37: {
                return new MathBitOr(this.binary().expr(), this.expr());
            }
            case 38: {
                return new MathBitInvert(this.single().expr());
            }
            case 40: {
                return new Type(this.single().field(), Integer.class);
            }
            case 41: {
                return new Type(this.single().field(), Long.class);
            }
            case 42: {
                return new Type(this.single().field(), Double.class);
            }
            case 43: {
                return new Type(this.single().field(), String.class);
            }
            case 44: {
                return new Type(this.single().field(), byte[].class);
            }
            case 45: {
                return new Nan(this.single().field());
            }
            case 48: {
                return StrBeginsWith.create(this.children());
            }
            case 49: {
                return StrContains.create(this.children());
            }
            case 50: {
                return StrEndsWith.create(this.children());
            }
            case 51: {
                return StrWildcard.create(this.children());
            }
            case 52: {
                return StrRegex.create(this.children());
            }
            case 56: {
                return new StrFoldCase(this.single().expr());
            }
            case 61: {
                return new StrUnicodeDecompose(this.single().expr(), StrUnicodeDecompose.Mode.DECOMPOSE);
            }
            case 62: {
                return new StrUnicodeDecompose(this.single().expr(), StrUnicodeDecompose.Mode.DECOMPOSE_COMPAT);
            }
            case 64: {
                return new Require(this.single().field());
            }
            case 65: {
                return Compare.createEquals(this.children());
            }
            case 66: {
                return new Size(this.single().field());
            }
        }
        throw new ProtocolCodecException("Unknown AST node type: " + type);
    }

    private XdrAstParser single() throws ProtocolCodecException {
        int count = this.in.getInt();
        if (count == 1) {
            return this;
        }
        throw new ProtocolCodecException("Expected single child, found " + count);
    }

    private XdrAstParser binary() throws ProtocolCodecException {
        int count = this.in.getInt();
        if (count == 2) {
            return this;
        }
        throw new ProtocolCodecException("Expected two children, found " + count);
    }

    private List<Node> children() throws ProtocolCodecException {
        int count = this.in.getInt();
        if (count < 0) {
            throw new ProtocolCodecException("Child count cannot be negative: " + count);
        }
        ArrayList<Node> children = new ArrayList<Node>(count);
        while (count > 0) {
            children.add(this.expr());
            --count;
        }
        return children;
    }

    private Field field() throws ProtocolCodecException {
        Node node = this.expr();
        if (node instanceof Field) {
            return (Field)node;
        }
        throw new ProtocolCodecException("Field node required, found " + Text.className(node));
    }

    private Node leaf(int type, int leafType) throws ProtocolCodecException {
        switch (type) {
            case 1: {
                XdrAstParser.assertLeafType(leafType, 4);
                return new Field(XdrCoding.getString(this.in));
            }
            case 5: {
                XdrAstParser.assertLeafType(leafType, 4);
                return new Const(XdrCoding.getString(this.in));
            }
            case 2: {
                XdrAstParser.assertLeafType(leafType, 1);
                return new Const(this.in.getInt());
            }
            case 3: {
                XdrAstParser.assertLeafType(leafType, 2);
                return new Const(this.in.getLong());
            }
            case 4: {
                XdrAstParser.assertLeafType(leafType, 3);
                return new Const(this.in.getDouble());
            }
        }
        throw new Error();
    }

    private static void assertLeafType(int required, int actual) throws ProtocolCodecException {
        if (required != actual) {
            throw new ProtocolCodecException("Leaf node has incorrect value type: " + actual);
        }
    }
}

