/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation.io;

import org.apache.mina.common.IoFilter;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.avis.federation.io.messages.Ack;
import org.avis.federation.io.messages.FedConnRply;
import org.avis.federation.io.messages.FedConnRqst;
import org.avis.federation.io.messages.FedNotify;
import org.avis.federation.io.messages.FedSubReplace;
import org.avis.io.FrameCodec;
import org.avis.io.messages.ConfConn;
import org.avis.io.messages.Disconn;
import org.avis.io.messages.DropWarn;
import org.avis.io.messages.Message;
import org.avis.io.messages.Nack;
import org.avis.io.messages.TestConn;

public class FederationFrameCodec
extends FrameCodec
implements ProtocolCodecFactory {
    private static final FederationFrameCodec INSTANCE = new FederationFrameCodec();
    public static final IoFilter FILTER = new ProtocolCodecFilter(INSTANCE);

    public ProtocolEncoder getEncoder() throws Exception {
        return INSTANCE;
    }

    public ProtocolDecoder getDecoder() throws Exception {
        return INSTANCE;
    }

    protected Message newMessage(int messageType, int frameSize) throws ProtocolCodecException {
        switch (messageType) {
            case 48: {
                return new Nack();
            }
            case 53: {
                return new Disconn();
            }
            case 65: {
                return new Ack();
            }
            case 193: {
                return new FedConnRply();
            }
            case 192: {
                return new FedConnRqst();
            }
            case 194: {
                return new FedSubReplace();
            }
            case 195: {
                return new FedNotify();
            }
            case 63: {
                return TestConn.INSTANCE;
            }
            case 64: {
                return ConfConn.INSTANCE;
            }
            case 62: {
                return new DropWarn();
            }
        }
        throw new ProtocolCodecException("Unknown message type: ID = " + messageType);
    }
}

