/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation;

import java.util.Arrays;
import java.util.Map;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.avis.federation.Federation;
import org.avis.federation.FederationClass;
import org.avis.federation.io.messages.Ack;
import org.avis.federation.io.messages.FedNotify;
import org.avis.federation.io.messages.FedSubReplace;
import org.avis.io.messages.Disconn;
import org.avis.io.messages.ErrorMessage;
import org.avis.io.messages.Message;
import org.avis.io.messages.Nack;
import org.avis.io.messages.Notify;
import org.avis.io.messages.RequestMessage;
import org.avis.io.messages.RequestTimeoutMessage;
import org.avis.logging.Log;
import org.avis.router.NotifyListener;
import org.avis.router.Router;
import org.avis.security.Keys;
import org.avis.subscription.ast.Node;
import org.avis.subscription.ast.nodes.Const;
import org.avis.util.Collections;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Link
implements NotifyListener {
    private static final int REASON_DISCONN_REQUESTED = -1;
    private static final int REASON_REQUEST_REJECTED = -2;
    private static final int REASON_FEDERATOR_NOT_RESPONDING = -3;
    private static final String[] EMPTY_ROUTING = new String[0];
    private Router router;
    private IoSession session;
    private FederationClass federationClass;
    private String serverDomain;
    private String remoteServerDomain;
    private String remoteHostName;
    private Node remotePullFilter;
    private boolean subscribed;
    private volatile boolean closed;

    public Link(Router router, IoSession session, FederationClass federationClass, String serverDomain, String remoteServerDomain, String remoteHostName) {
        this.session = session;
        this.router = router;
        this.federationClass = federationClass;
        this.serverDomain = serverDomain;
        this.remoteServerDomain = remoteServerDomain;
        this.remoteHostName = remoteHostName;
        this.remotePullFilter = Const.CONST_FALSE;
        this.subscribed = false;
        this.subscribe();
        if (federationClass.outgoingFilter != Const.CONST_FALSE) {
            router.addNotifyListener(this);
        }
    }

    public IoSession session() {
        return this.session;
    }

    public String remoteServerDomain() {
        return this.remoteServerDomain;
    }

    public boolean isLive() {
        return this.federationClass.incomingFilter == Const.CONST_FALSE || this.subscribed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean initiatedSessionClose() {
        return this.session.containsAttribute("linkClosed");
    }

    public void close() {
        this.close(1);
    }

    private void close(int reason) {
        this.close(reason, "");
    }

    private void close(int reason, String message) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.router.removeNotifyListener(this);
        if (this.session.isConnected()) {
            this.session.setAttribute("linkClosed");
            if (reason < 0) {
                this.session.close();
            } else {
                this.send(new Disconn(reason, message)).addListener(IoFutureListener.CLOSE);
            }
        }
    }

    private void subscribe() {
        if (this.federationClass.incomingFilter != Const.CONST_FALSE) {
            this.send(new FedSubReplace(this.federationClass.incomingFilter));
        }
    }

    @Override
    public void notifyReceived(Notify message, Keys keys) {
        Map<String, Object> attributes;
        String[] routing = Link.routingFor(message);
        if (this.shouldPush(routing, attributes = Collections.union(message.attributes, this.federationClass.outgoingAttributes))) {
            this.send(new FedNotify(message, attributes, keys.addedTo(message.keys), this.serverDomainAddedTo(routing)));
        }
    }

    private boolean shouldPush(String[] routing, Map<String, Object> attributes) {
        return !Link.containsDomain(routing, this.remoteServerDomain) && Link.matches(this.federationClass.outgoingFilter, attributes) && Link.matches(this.remotePullFilter, attributes);
    }

    private boolean shouldPull(FedNotify message) {
        return !Link.containsDomain(message.routing, this.serverDomain) && Link.matches(this.federationClass.incomingFilter, message.attributes);
    }

    public void handleMessage(Message message) {
        switch (message.typeId()) {
            case 194: {
                this.handleFedSubReplace((FedSubReplace)message);
                break;
            }
            case 195: {
                this.handleFedNotify((FedNotify)message);
                break;
            }
            case 53: {
                this.close(-1);
                break;
            }
            case 62: {
                this.handleDropWarn();
                break;
            }
            case 48: {
                this.handleNack((Nack)message);
                break;
            }
            case 65: {
                this.handleAck((Ack)message);
                break;
            }
            case -2: {
                this.handleRequestTimeout(((RequestTimeoutMessage)message).request);
                break;
            }
            case -3: {
                this.handleLivenessFailure();
                break;
            }
            case -1: {
                this.handleError((ErrorMessage)message);
                break;
            }
            default: {
                this.handleProtocolViolation("Unexpected " + message.name());
            }
        }
    }

    private void handleDropWarn() {
        Log.warn("Remote federator sent a dropped packet warning: a message may have been discarded due to congestion", this);
    }

    private void handleRequestTimeout(RequestMessage<?> request) {
        if (request.getClass() == FedSubReplace.class) {
            Log.warn("Federation subscription request to remote federator at " + this.remoteHostName + " timed out: retrying", this);
            this.subscribe();
        } else {
            Log.internalError("Request timeout for unexpected message type: " + Text.className(request), this);
        }
    }

    private void handleLivenessFailure() {
        Log.warn("Remote federator at " + this.remoteHostName + " has stopped responding", this);
        this.close(-3);
    }

    private void handleError(ErrorMessage message) {
        Federation.logError(message, this);
        this.handleProtocolViolation(message.error.getMessage());
    }

    private void handleAck(Ack ack) {
        if (ack.request instanceof FedSubReplace) {
            this.subscribed = true;
        }
    }

    private void handleNack(Nack nack) {
        Log.warn("Disconnecting from remote federator at " + this.remoteHostName + " " + "after it rejected a " + nack.request.name(), this);
        this.close(-2);
    }

    private void handleFedSubReplace(FedSubReplace message) {
        this.remotePullFilter = message.incomingFilter.inlineConstants();
        this.send(new Ack(message));
    }

    private void handleFedNotify(FedNotify message) {
        if (Log.shouldLog(0)) {
            Log.trace("Federator for domain \"" + this.serverDomain + "\" " + "FedNotify: routing=" + Arrays.asList(message.routing), this);
        }
        if (Link.containsDomain(message.routing, this.remoteServerDomain)) {
            message.attributes = Collections.union(message.attributes, this.federationClass.incomingAttributes);
            if (this.shouldPull(message)) {
                this.router.injectNotify(message);
            }
        } else {
            Log.warn("Closing federation link on receipt of FedNotify from remote federator that has not added its own domain (" + this.remoteServerDomain + ") to the routing list: " + Arrays.asList(message.routing), this);
            this.handleProtocolViolation("Remote server domain was not in FedNotify routing list");
        }
    }

    private void handleProtocolViolation(String message) {
        Log.warn("Disconnecting remote federator at " + this.remoteHostName + " " + "due to protocol violation: " + message, this);
        this.close(4, message);
    }

    private WriteFuture send(Message message) {
        return Federation.send(this.session, this.serverDomain, message);
    }

    private static boolean matches(Node filter, Map<String, Object> attributes) {
        return filter.evaluate(attributes) == Node.TRUE;
    }

    private static String[] routingFor(Notify message) {
        if (message instanceof FedNotify) {
            return ((FedNotify)message).routing;
        }
        return EMPTY_ROUTING;
    }

    private static boolean containsDomain(String[] routing, String serverDomain) {
        for (String domain : routing) {
            if (!domain.equals(serverDomain)) continue;
            return true;
        }
        return false;
    }

    private String[] serverDomainAddedTo(String[] routing) {
        String[] newRouting = new String[routing.length + 1];
        newRouting[0] = this.serverDomain;
        System.arraycopy(routing, 0, newRouting, 1, routing.length);
        return newRouting;
    }
}

