/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation;

import java.util.Collections;
import org.avis.config.OptionSet;
import org.avis.config.OptionType;
import org.avis.config.OptionTypeFromString;
import org.avis.config.OptionTypeParam;
import org.avis.config.OptionTypeSet;
import org.avis.config.OptionTypeValueExpr;
import org.avis.federation.EwafURI;
import org.avis.federation.FederationClass;
import org.avis.io.InetAddressFilter;
import org.avis.router.ConnectionOptionSet;
import org.avis.subscription.ast.Node;
import org.avis.subscription.parser.ParseException;
import org.avis.util.Filter;
import org.avis.util.IllegalConfigOptionException;

public class FederationOptionSet
extends OptionSet {
    public static final OptionSet OPTION_SET = new FederationOptionSet();

    protected FederationOptionSet() {
        OptionTypeParam fedClassOption = new OptionTypeParam(new SubExpOption());
        OptionTypeParam attrOption = new OptionTypeParam(new OptionTypeValueExpr(), 2);
        OptionTypeSet setOfURI = new OptionTypeSet(EwafURI.class);
        this.add("Federation.Activated", false);
        this.add("Federation.Router-Name", "");
        this.add("Federation.Subscribe", fedClassOption, Collections.emptyMap());
        this.add("Federation.Provide", fedClassOption, Collections.emptyMap());
        this.add("Federation.Apply-Class", new OptionTypeParam(new OptionTypeSet(String.class)), Collections.emptyMap());
        this.add("Federation.Default-Class", "");
        this.add("Federation.Connect", new OptionTypeParam(setOfURI), Collections.emptyMap());
        this.add("Federation.Listen", setOfURI, Collections.emptySet());
        this.add("Federation.Router-Name", "");
        this.add("Federation.Add-Incoming-Attribute", attrOption, Collections.emptyMap());
        this.add("Federation.Add-Outgoing-Attribute", attrOption, Collections.emptyMap());
        this.add("Federation.Request-Timeout", 1, 20, Integer.MAX_VALUE);
        this.add("Federation.Keepalive-Interval", 1, 60, Integer.MAX_VALUE);
        this.add("Federation.Require-Authenticated", new OptionTypeFromString(InetAddressFilter.class), Filter.MATCH_NONE);
        this.inheritFrom(ConnectionOptionSet.CONNECTION_OPTION_SET);
    }

    static class SubExpOption
    extends OptionType {
        SubExpOption() {
        }

        public Object convert(String option, Object value) throws IllegalConfigOptionException {
            try {
                if (value instanceof Node) {
                    return value;
                }
                return FederationClass.parse(value.toString());
            }
            catch (ParseException ex) {
                throw new IllegalConfigOptionException(option, "Invalid subscription: " + ex.getMessage());
            }
        }

        public String validate(String option, Object value) {
            return this.validateType(value, Node.class);
        }
    }
}

