/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.avis.federation.FederationClass;
import org.avis.io.InetAddressFilter;
import org.avis.util.Filter;
import org.avis.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FederationClasses {
    private FederationClass defaultClass;
    private Map<String, FederationClass> classes;
    private List<Pair<Filter<InetAddress>, FederationClass>> hostToClass;

    public FederationClasses() {
        this(new FederationClass());
    }

    public FederationClasses(FederationClass defaultClass) {
        this.defaultClass = defaultClass;
        this.classes = new TreeMap<String, FederationClass>(String.CASE_INSENSITIVE_ORDER);
        this.hostToClass = new ArrayList<Pair<Filter<InetAddress>, FederationClass>>();
    }

    public void setDefaultClass(FederationClass newDefaultClass) {
        this.defaultClass = newDefaultClass;
    }

    public FederationClass defaultClass() {
        return this.defaultClass;
    }

    public FederationClass define(String name) {
        FederationClass fedClass = this.classes.get(name);
        if (fedClass == null) {
            fedClass = new FederationClass();
            fedClass.name = name;
            this.classes.put(name, fedClass);
        }
        return fedClass;
    }

    public FederationClass classFor(InetAddress address) {
        for (Pair<Filter<InetAddress>, FederationClass> entry : this.hostToClass) {
            if (!((Filter)entry.item1).matches(address)) continue;
            return (FederationClass)entry.item2;
        }
        return this.defaultClass;
    }

    public FederationClass classFor(String hostName) {
        try {
            return this.classFor(InetAddress.getByName(hostName));
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public void map(Filter<InetAddress> matcher, FederationClass fedClass) {
        this.hostToClass.add(new Pair<Filter<InetAddress>, FederationClass>(matcher, fedClass));
    }

    public void map(String host, FederationClass fedClass) {
        this.map(new InetAddressFilter(host), fedClass);
    }

    public void clear() {
        this.classes.clear();
        this.hostToClass.clear();
    }
}

