/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.RuntimeIOException;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.avis.config.Options;
import org.avis.federation.EwafURI;
import org.avis.federation.Federation;
import org.avis.federation.FederationClass;
import org.avis.federation.Link;
import org.avis.federation.io.FederationFrameCodec;
import org.avis.federation.io.messages.FedConnRply;
import org.avis.federation.io.messages.FedConnRqst;
import org.avis.io.FrameCodec;
import org.avis.io.LivenessFilter;
import org.avis.io.Net;
import org.avis.io.RequestTrackingFilter;
import org.avis.io.messages.ErrorMessage;
import org.avis.io.messages.Message;
import org.avis.io.messages.Nack;
import org.avis.io.messages.RequestMessage;
import org.avis.io.messages.RequestTimeoutMessage;
import org.avis.logging.Log;
import org.avis.router.Router;
import org.avis.util.Filter;
import org.avis.util.IllegalConfigOptionException;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connector
implements IoHandler,
Closeable {
    private EwafURI uri;
    private Options options;
    private Router router;
    private SocketConnector connector;
    private SocketConnectorConfig connectorConfig;
    private InetSocketAddress remoteAddress;
    private IoSession session;
    private String serverDomain;
    private FederationClass federationClass;
    private Link link;
    private Timer asyncConnectTimer;
    protected volatile boolean closing;

    public Connector(Router router, String serverDomain, EwafURI uri, FederationClass federationClass, Options options) throws IllegalConfigOptionException, IOException {
        this.router = router;
        this.uri = uri;
        this.serverDomain = serverDomain;
        this.federationClass = federationClass;
        this.options = options;
        this.connector = new SocketConnector(1, router.executor());
        this.connectorConfig = new SocketConnectorConfig();
        this.remoteAddress = new InetSocketAddress(uri.host, uri.port);
        long requestTimeout = options.getInt("Federation.Request-Timeout") * 1000;
        long keepaliveInterval = options.getInt("Federation.Keepalive-Interval") * 1000;
        this.connector.setWorkerTimeout(0);
        this.connectorConfig.setThreadModel(ThreadModel.MANUAL);
        this.connectorConfig.setConnectTimeout((int)(requestTimeout / 1000L));
        DefaultIoFilterChainBuilder filters = new DefaultIoFilterChainBuilder();
        filters.addLast("codec", FederationFrameCodec.FILTER);
        filters.addLast("requestTracker", new RequestTrackingFilter(requestTimeout));
        filters.addLast("liveness", new LivenessFilter(keepaliveInterval, requestTimeout));
        Filter authRequired = (Filter)options.get("Federation.Require-Authenticated");
        filters = uri.isSecure() ? router.createSecureFilters(filters, authRequired, true) : router.createStandardFilters(filters, authRequired);
        this.connectorConfig.setFilterChainBuilder(filters);
        this.connect();
    }

    public Link link() {
        return this.link;
    }

    public boolean isWaitingForAsyncConnection() {
        return this.asyncConnectTimer != null;
    }

    public boolean isConnected() {
        return this.link != null && this.link.isLive();
    }

    synchronized void connect() {
        this.closing = false;
        this.cancelAsyncConnect();
        this.connector.connect((SocketAddress)this.remoteAddress, this, this.connectorConfig).addListener(new IoFutureListener(){

            public void operationComplete(IoFuture future) {
                Connector.this.connectFutureComplete(future);
            }
        });
    }

    protected void connectFutureComplete(IoFuture future) {
        if (this.closing) {
            return;
        }
        try {
            if (!future.isReady()) {
                Log.diagnostic("Connection attempt to federator at " + this.uri + " timed out, retrying", this);
                this.asyncConnect();
            } else {
                this.open(future.getSession());
            }
        }
        catch (RuntimeIOException ex) {
            Log.diagnostic("Failed to connect to federator at " + this.uri + ", retrying: " + Text.shortException(ex.getCause()), this, ex);
            this.asyncConnect();
        }
    }

    synchronized void asyncConnect() {
        if (this.asyncConnectTimer != null) {
            throw new Error();
        }
        this.asyncConnectTimer = new Timer("Federation connector");
        TimerTask connectTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connector connector = Connector.this;
                synchronized (connector) {
                    if (!Connector.this.closing) {
                        Connector.this.connect();
                    }
                }
            }
        };
        this.asyncConnectTimer.schedule(connectTask, (long)this.options.getInt("Federation.Request-Timeout") * 1000L);
    }

    private void cancelAsyncConnect() {
        if (this.asyncConnectTimer != null) {
            this.asyncConnectTimer.cancel();
            this.asyncConnectTimer = null;
        }
    }

    synchronized void open(IoSession newSession) {
        this.session = newSession;
        this.cancelAsyncConnect();
        this.send(new FedConnRqst(1, 0, this.serverDomain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Connector connector = this;
        synchronized (connector) {
            this.closing = true;
            this.cancelAsyncConnect();
            if (this.session != null) {
                if (this.session.isConnected()) {
                    if (this.link != null) {
                        this.link.close();
                    } else {
                        this.session.close();
                    }
                } else if (this.link != null && !this.link.initiatedSessionClose()) {
                    Log.warn("Remote federator at " + this.uri + " " + "closed outgoing link with no warning", this);
                    this.link.close();
                }
                this.session = null;
            }
            this.link = null;
        }
    }

    private void reopen() {
        if (this.closing) {
            return;
        }
        this.close();
        Log.diagnostic("Scheduling reconnection for outgoing federation link to " + this.uri, this);
        this.closing = false;
        this.asyncConnect();
    }

    private void handleMessage(Message message) {
        switch (message.typeId()) {
            case 193: {
                this.createFederationLink(((FedConnRply)message).serverDomain);
                break;
            }
            case 48: {
                this.handleFedConnNack((Nack)message);
                break;
            }
            case -2: {
                this.handleRequestTimeout(((RequestTimeoutMessage)message).request);
                break;
            }
            case -1: {
                Federation.logError((ErrorMessage)message, this);
                this.close();
                break;
            }
            default: {
                Log.warn("Unexpected message during handshake from remote federator at " + this.uri + ": " + message.name(), this);
                this.reopen();
            }
        }
    }

    private void handleRequestTimeout(RequestMessage<?> request) {
        if (request.getClass() == FedConnRqst.class) {
            Log.warn("Federation connection request to remote federator at " + this.uri + " timed out, reconnecting", this);
            this.reopen();
        } else {
            Log.internalError("Request timeout for unexpected message type: " + Text.className(request), this);
        }
    }

    private void handleFedConnNack(Nack nack) {
        Log.warn("Closing connection to remote router at " + this.uri + " after it rejected federation connect request: " + nack.formattedMessage(), this);
        this.reopen();
    }

    private void createFederationLink(String remoteServerDomain) {
        Log.info("Federation outgoing link for " + this.uri + " established with \"" + Net.hostIdFor(this.session) + "\", remote server domain \"" + remoteServerDomain + "\"", this);
        this.link = new Link(this.router, this.session, this.federationClass, this.serverDomain, remoteServerDomain, this.remoteAddress.getAddress().getCanonicalHostName());
    }

    private void send(Message message) {
        Federation.send(this.session, this.serverDomain, message);
    }

    @Override
    public void sessionOpened(IoSession theSession) throws Exception {
        Federation.logSessionOpened(theSession, this);
    }

    @Override
    public void sessionClosed(IoSession theSession) throws Exception {
        Log.info("Federation link for " + this.uri + " with \"" + Net.hostIdFor(theSession) + "\" disconnected", this);
        this.reopen();
    }

    @Override
    public void sessionCreated(IoSession theSession) throws Exception {
        FrameCodec.setMaxFrameLengthFor(theSession, this.options.getInt("Packet.Max-Length"));
    }

    @Override
    public void messageReceived(IoSession theSession, Object theMessage) throws Exception {
        if (this.closing) {
            return;
        }
        Message message = (Message)theMessage;
        Federation.logMessageReceived(message, this.serverDomain, this);
        if (this.link == null) {
            this.handleMessage(message);
        } else if (!this.link.isClosed()) {
            this.link.handleMessage(message);
        }
    }

    @Override
    public void messageSent(IoSession theSession, Object message) throws Exception {
    }

    @Override
    public void sessionIdle(IoSession theSession, IdleStatus status) throws Exception {
    }

    @Override
    public void exceptionCaught(IoSession theSession, Throwable cause) throws Exception {
        Federation.logMinaException(cause, this);
    }
}

