/*
 * Decompiled with CFR 0.152.
 */
package org.avis.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.avis.config.OptionType;
import org.avis.util.IllegalConfigOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionTypeString
extends OptionType {
    public static final OptionTypeString ANY_STRING_OPTION = new OptionTypeString();
    protected Set<String> validValues;

    public OptionTypeString() {
        this(null);
    }

    public OptionTypeString(String defaultValue, String ... validValues) {
        this.validValues = new HashSet<String>(Arrays.asList(validValues));
        this.validValues.add(defaultValue);
    }

    public OptionTypeString(Set<String> validValues) {
        this.validValues = validValues;
    }

    @Override
    public Object convert(String option, Object value) throws IllegalConfigOptionException {
        return value.toString();
    }

    @Override
    public String validate(String option, Object value) {
        if (value instanceof String) {
            if (this.validValues != null && !this.validValues.contains(value)) {
                return "Value must be one of: " + this.validValues.toString();
            }
            return null;
        }
        return "Value must be a string";
    }
}

