/*
 * Decompiled with CFR 0.152.
 */
package org.avis.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.avis.config.OptionType;
import org.avis.util.IllegalConfigOptionException;
import org.avis.util.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionTypeSet
extends OptionType {
    private Constructor<?> constructor;

    public OptionTypeSet(Class<?> setValueType) {
        try {
            this.constructor = setValueType.getConstructor(String.class);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("No constructor taking a string");
        }
    }

    @Override
    public String validate(String option, Object value) {
        return this.validateType(value, Set.class);
    }

    @Override
    public Object convert(String option, Object value) throws IllegalConfigOptionException {
        try {
            HashSet values = new HashSet();
            for (String item : Text.split(value.toString().trim(), "((?<!\\\\)\\s)+")) {
                values.add(this.constructor.newInstance(Text.stripBackslashes(item)));
            }
            return values;
        }
        catch (InvocationTargetException ex) {
            throw new IllegalConfigOptionException(option, ex.getCause().getMessage());
        }
        catch (Exception ex) {
            throw new IllegalConfigOptionException(option, ex.toString());
        }
    }
}

