/*
 * Decompiled with CFR 0.152.
 */
package org.avis.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.avis.config.OptionType;
import org.avis.util.IllegalConfigOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionTypeFromString
extends OptionType {
    private Class<?> valueType;
    private Constructor<?> constructor;

    public OptionTypeFromString(Class<?> valueType) {
        this.valueType = valueType;
        try {
            this.constructor = valueType.getConstructor(String.class);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("No constructor taking a string");
        }
    }

    @Override
    public String validate(String option, Object value) {
        return this.validateType(value, this.valueType);
    }

    @Override
    public Object convert(String option, Object value) throws IllegalConfigOptionException {
        if (this.valueType.isAssignableFrom(value.getClass())) {
            return value;
        }
        try {
            return this.constructor.newInstance(value.toString());
        }
        catch (InvocationTargetException ex) {
            throw new IllegalConfigOptionException(option, ex.getCause().getMessage());
        }
        catch (Exception ex) {
            throw new IllegalConfigOptionException(option, ex.toString());
        }
    }
}

