/*
 * Decompiled with CFR 0.152.
 */
package org.avis.common;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.avis.common.InvalidURIException;
import org.avis.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElvinURI {
    private static final List<String> DEFAULT_PROTOCOL = Collections.list("tcp", "none", "xdr");
    private static final List<String> SECURE_PROTOCOL = Collections.list("ssl", "none", "xdr");
    private static final Pattern URL_PATTERN = Pattern.compile("(\\w+):([^/]+)?/([^/]+)?/([^;/][^;]*)(;.*)?");
    public String uriString;
    public String scheme;
    public int versionMajor;
    public int versionMinor;
    public List<String> protocol;
    public String host;
    public int port;
    public Map<String, String> options;
    private int hash;

    public ElvinURI(String uriString) throws InvalidURIException {
        this.init();
        this.uriString = uriString;
        this.parseUri();
        this.validate();
        this.hash = this.computeHash();
    }

    public ElvinURI(String host, int port) {
        this.init();
        this.uriString = "elvin://" + host + ':' + port;
        this.scheme = "elvin";
        this.host = host;
        this.port = port;
        this.hash = this.computeHash();
    }

    public ElvinURI(String uriString, ElvinURI defaultUri) throws InvalidURIException {
        this.init(defaultUri);
        this.uriString = uriString;
        this.parseUri();
        this.validate();
        this.hash = this.computeHash();
    }

    public ElvinURI(ElvinURI defaultUri) {
        this.init(defaultUri);
        this.validate();
    }

    protected void init(ElvinURI defaultUri) {
        this.uriString = defaultUri.uriString;
        this.scheme = defaultUri.scheme;
        this.versionMajor = defaultUri.versionMajor;
        this.versionMinor = defaultUri.versionMinor;
        this.protocol = defaultUri.protocol;
        this.host = defaultUri.host;
        this.port = defaultUri.port;
        this.options = defaultUri.options;
        this.hash = defaultUri.hash;
    }

    protected void init() {
        this.scheme = null;
        this.versionMajor = 4;
        this.versionMinor = 0;
        this.protocol = DEFAULT_PROTOCOL;
        this.host = null;
        this.port = 2917;
        this.options = java.util.Collections.emptyMap();
    }

    private void validate() {
        if (!this.validScheme(this.scheme)) {
            throw new InvalidURIException(this.uriString, "Invalid scheme: " + this.scheme);
        }
    }

    protected boolean validScheme(String schemeToCheck) {
        return schemeToCheck.equals("elvin");
    }

    public String toString() {
        return this.uriString;
    }

    public String toCanonicalString() {
        StringBuilder str = new StringBuilder();
        str.append(this.scheme).append(':');
        str.append(this.versionMajor).append('.').append(this.versionMinor);
        str.append('/');
        Collections.join(str, this.protocol, ',');
        str.append('/').append(this.host).append(':').append(this.port);
        for (Map.Entry<String, String> option : this.options.entrySet()) {
            str.append(';');
            str.append(option.getKey()).append('=').append(option.getValue());
        }
        return str.toString();
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        return obj instanceof ElvinURI && this.equals((ElvinURI)obj);
    }

    public boolean equals(ElvinURI uri) {
        return this.hash == uri.hash && this.scheme.equals(uri.scheme) && this.host.equals(uri.host) && this.port == uri.port && this.versionMajor == uri.versionMajor && this.versionMinor == uri.versionMinor && ((Object)this.options).equals(uri.options) && ((Object)this.protocol).equals(uri.protocol);
    }

    private int computeHash() {
        return this.scheme.hashCode() ^ this.host.hashCode() ^ this.port ^ ((Object)this.protocol).hashCode();
    }

    private void parseUri() throws InvalidURIException {
        Matcher matcher = URL_PATTERN.matcher(this.uriString);
        if (!matcher.matches()) {
            throw new InvalidURIException(this.uriString, "Not a valid Elvin URI");
        }
        this.scheme = matcher.group(1);
        if (matcher.group(2) != null) {
            this.parseVersion(matcher.group(2));
        }
        if (matcher.group(3) != null) {
            this.parseProtocol(matcher.group(3));
        }
        this.parseEndpoint(matcher.group(4));
        if (matcher.group(5) != null) {
            this.parseOptions(matcher.group(5));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseVersion(String versionExpr) throws InvalidURIException {
        Matcher versionMatch = Pattern.compile("(\\d+)(?:\\.(\\d+))?").matcher(versionExpr);
        if (!versionMatch.matches()) throw new InvalidURIException(this.uriString, "Invalid version string: \"" + versionExpr + "\"");
        try {
            this.versionMajor = Integer.parseInt(versionMatch.group(1));
            if (versionMatch.group(2) == null) return;
            this.versionMinor = Integer.parseInt(versionMatch.group(2));
            return;
        }
        catch (NumberFormatException ex) {
            throw new InvalidURIException(this.uriString, "Number too large in version string: \"" + versionExpr + "\"");
        }
    }

    private void parseProtocol(String protocolExpr) throws InvalidURIException {
        Matcher protocolMatch = Pattern.compile("(?:(\\w+),(\\w+),(\\w+))|secure").matcher(protocolExpr);
        if (protocolMatch.matches()) {
            this.protocol = protocolMatch.group(1) != null ? Arrays.asList(protocolExpr.split(",")) : SECURE_PROTOCOL;
        } else {
            throw new InvalidURIException(this.uriString, "Invalid protocol: \"" + protocolExpr + "\"");
        }
    }

    private void parseEndpoint(String endpoint) throws InvalidURIException {
        Pattern pattern = endpoint.charAt(0) == '[' ? Pattern.compile("(\\[[^\\]]+\\])(?::(\\d+))?") : Pattern.compile("([^:]+)(?::(\\d+))?");
        Matcher endpointMatch = pattern.matcher(endpoint);
        if (endpointMatch.matches()) {
            this.host = endpointMatch.group(1);
            if (endpointMatch.group(2) != null) {
                this.port = Integer.parseInt(endpointMatch.group(2));
            }
        } else {
            throw new InvalidURIException(this.uriString, "Invalid port number");
        }
    }

    private void parseOptions(String optionsExpr) throws InvalidURIException {
        Matcher optionMatch = Pattern.compile(";([^=;]+)=([^=;]*)").matcher(optionsExpr);
        this.options = new TreeMap<String, String>();
        int index = 0;
        while (optionMatch.lookingAt()) {
            this.options.put(optionMatch.group(1), optionMatch.group(2));
            index = optionMatch.end();
            optionMatch.region(index, optionsExpr.length());
        }
        if (index != optionsExpr.length()) {
            throw new InvalidURIException(this.uriString, "Invalid options: \"" + optionsExpr + "\"");
        }
    }

    public static List<String> defaultProtocol() {
        return DEFAULT_PROTOCOL;
    }

    public static List<String> secureProtocol() {
        return SECURE_PROTOCOL;
    }

    public boolean isSecure() {
        return ((Object)this.protocol).equals(ElvinURI.secureProtocol());
    }
}

