/*
 * Decompiled with CFR 0.152.
 */
package dsto.dfc.tools;

import dsto.dfc.tools.JarX;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class JarXTask
extends Task {
    private File archiveFile;
    private File manifestFile = null;
    private String mainClass = null;
    private boolean useJarFormat = true;
    private ArrayList includes = new ArrayList();
    private ArrayList includeRegexps = new ArrayList();
    private ArrayList excludes = new ArrayList();
    private ArrayList excludeRegexps = new ArrayList();
    private Path classPath = null;

    public JarXTask() {
        this.setTaskName("jarx");
    }

    public void setArchive(File newFile) {
        this.archiveFile = newFile;
    }

    public void setManifest(File newFile) {
        this.manifestFile = newFile;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setUseJarFormat(boolean useJarFormat) {
        this.useJarFormat = useJarFormat;
    }

    public void setIncludes(String newIncludes) {
        String[] includesArray = JarXTask.split(newIncludes, ",");
        this.includes.addAll(Arrays.asList(includesArray));
    }

    public PatternArgument createInclude() {
        return new PatternArgument(this.includes, this.includeRegexps);
    }

    public void setIncludeRegexps(String newRegexps) {
        String[] regexpsArray = JarXTask.split(newRegexps, ",");
        this.includeRegexps.addAll(Arrays.asList(regexpsArray));
    }

    public void setExcludes(String newExcludes) {
        String[] excludesArray = JarXTask.split(newExcludes, ",");
        this.excludes.addAll(Arrays.asList(excludesArray));
    }

    public PatternArgument createExclude() {
        return new PatternArgument(this.excludes, this.excludeRegexps);
    }

    public void setExcludeRegexps(String newRegexps) {
        String[] regexpsArray = JarXTask.split(newRegexps, ",");
        this.excludeRegexps.addAll(Arrays.asList(regexpsArray));
    }

    public void setClasspath(Path newPath) {
        if (this.classPath == null) {
            this.classPath = newPath;
        } else {
            this.classPath.append(newPath);
        }
    }

    public Path getClasspath() {
        return this.classPath;
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.project);
        }
        return this.classPath.createPath();
    }

    public void execute() throws BuildException {
        if (this.archiveFile == null) {
            throw new BuildException("No archive specified");
        }
        JarX jarx = new JarX(this.archiveFile, this.useJarFormat);
        if (this.manifestFile != null) {
            jarx.setManifestFile(this.manifestFile);
        }
        if (this.mainClass != null) {
            jarx.setMainClassName(this.mainClass);
        }
        if (this.classPath == null) {
            this.classPath = Path.systemClasspath;
        }
        jarx.setClassPath(this.classPath.list());
        jarx.addRoots(this.includes);
        jarx.addRootRegexps(this.includeRegexps);
        jarx.addExcludes(this.excludes);
        jarx.addExcludeRegexps(this.excludeRegexps);
        try {
            this.log("Creating " + this.archiveFile);
            jarx.run();
        }
        catch (Exception ex) {
            throw new BuildException("JarX encountered an error: " + ex, (Throwable)ex);
        }
    }

    public static String[] split(String str, String delimeter) {
        ArrayList<String> elements = new ArrayList<String>();
        int start = 0;
        int end = -1;
        while (start < str.length()) {
            end = str.indexOf(delimeter, start);
            if (end == -1) {
                end = str.length();
            }
            elements.add(str.substring(start, end));
            start = end + 1;
        }
        String[] elementArray = new String[elements.size()];
        elements.toArray(elementArray);
        return elementArray;
    }

    public final class PatternArgument {
        private List namesList;
        private List regexpsList;

        public PatternArgument(List namesList, List regexpsList) {
            this.namesList = namesList;
            this.regexpsList = regexpsList;
        }

        public void setName(String name) {
            this.namesList.add(name);
        }

        public void setRegexp(String regexp) {
            this.regexpsList.add(regexp);
        }
    }
}

