	PROCESSOR 68HC11

	TEST			; 00 - 68HC11
	NOP			; 01
	IDIV			; 02 - 68HC11
	FDIV			; 03 - 68HC11
	LSRD			; 04 - 68HC11 6801 6303
	ASLD			; 05 - 68HC11 6801 6303
	TAP			; 06
	TPA			; 07
	INX			; 08
	DEX			; 09
	CLV			; 0A
	SEV			; 0B
	CLC			; 0C
	SEC			; 0D
	CLI			; 0E
	SEI			; 0F

	SBA			; 10
	CBA			; 11
	BRSET	$44 $42 .+4	; 12 44 42 00 - 68HC11
	BRCLR	$44 $42 .+4	; 13 44 42 00 - 68HC11
	BSET	$44 $42		; 14 44 42    - 68HC11
	BCLR	$44 $42		; 15 44 42    - 68HC11
	TAB			; 16
	TBA			; 17
	FCB	$18		; 18 - 68HC11 prebyte / 6303 XGDX
	DAA			; 19
	FCB	$1A		; 1A - 68HC11 prebyte / 6303 SLP
	ABA			; 1B
	BSET	$58,X $42	; 1C 58 42    - 68HC11
	BCLR	$58,X $42	; 1D 58 42    - 68HC11
	BRSET	$58,X $42 .+4	; 1E 58 42 00 - 68HC11
	BRCLR	$58,X $42 .+4	; 1F 58 42 00 - 68HC11

	BRA	.+2		; 20 00
	BRN	.+2		; 21 00 - 68HC11 6801 6303
	BHI	.+2		; 22 00
	BLS	.+2		; 23 00
	BCC	.+2		; 24 00 - also BHS
	BCS	.+2		; 25 00 - also BLO
	BNE	.+2		; 26 00
	BEQ	.+2		; 27 00
	BVC	.+2		; 28 00
	BVS	.+2		; 29 00
	BPL	.+2		; 2A 00
	BMI	.+2		; 2B 00
	BGE	.+2		; 2C 00
	BLT	.+2		; 2D 00
	BGT	.+2		; 2E 00
	BLE	.+2		; 2F 00

	TSX			; 30
	INS			; 31
	PULA			; 32
	PULB			; 33
	DES			; 34
	TXS			; 35
	PSHA			; 36
	PSHB			; 37
	PULX			; 38 - 68HC11 6801 6303
	RTS			; 39
	ABX			; 3A - 68HC11 6801 6303
	RTI			; 3B
	PSHX			; 3C - 68HC11 6801 6303
	MUL			; 3D - 68HC11 6801 6303
	WAI			; 3E
	SWI			; 3F

	NEGA			; 40
	FCB	$41		; 41
	FCB	$42		; 42
	COMA			; 43
	LSRA			; 44
	FCB	$45		; 45
	RORA			; 46
	ASRA			; 47
	ASLA			; 48
	ROLA			; 49
	DECA			; 4A
	FCB	$4B		; 4B
	INCA			; 4C
	TSTA			; 4D
	FCB	$4E		; 4E
	CLRA			; 4F

	NEGB			; 50
	FCB	$51		; 51
	FCB	$52		; 52
	COMB			; 53
	LSRB			; 54
	FCB	$55		; 55
	RORB			; 56
	ASRB			; 57
	ASLB			; 58
	ROLB			; 59
	DECB			; 5A
	FCB	$5B		; 5B
	INCB			; 5C
	TSTB			; 5D
	FCB	$5E		; 5E
	CLRB			; 5F

	NEG	$58,X		; 60 58
	FCB	$61		; 61    - 6303 AIM indexed
	FCB	$62		; 62    - 6303 OIM indexed
	COM	$58,X		; 63 58
	LSR	$58,X		; 64 58
	FCB	$65		; 65    - 6303 EIM indexed
	ROR	$58,X		; 66 58
	ASR	$58,X		; 67 58
	ASL	$58,X		; 68 58
	ROL	$58,X		; 69 58
	DEC	$58,X		; 6A 58
	FCB	$6B		; 6B    - 6303 TIM indexed
	INC	$58,X		; 6C 58
	TST	$58,X		; 6D 58
	JMP	$58,X		; 6E 58
	CLR	$58,X		; 6F 58

	NEG	$4558		; 70 4558
	FCB	$71		; 71      - 6303 AIM extended
	FCB	$72		; 72      - 6303 OIM extended
	COM	$4558		; 73 4558
	LSR	$4558		; 74 4558
	FCB	$75		; 75      - 6303 EIM extended
	ROR	$4558		; 76 4558
	ASR	$4558		; 77 4558
	ASL	$4558		; 78 4558
	ROL	$4558		; 79 4558
	DEC	$4558		; 7A 4558
	FCB	$7B		; 7B      - 6303 TIM extended
	INC	$4558		; 7C 4558
	TST	$4558		; 7D 4558
	JMP	.+3		; 7E XXXX
	CLR	$4558		; 7F 4558

	SUBA	#$49		; 80 49
	CMPA	#$49		; 81 49
	SBCA	#$49		; 82 49
	SUBD	#$494D		; 83 494D - 68HC11 6801 6303
	ANDA	#$49		; 84 49
	BITA	#$49		; 85 49
	LDAA	#$49		; 86 49
	FCB	$87		; 87
	EORA	#$49		; 88 49
	ADCA	#$49		; 89 49
	ORAA	#$49		; 8A 49
	ADDA	#$49		; 8B 49
	CPX	#$494D		; 8C 494D
	BSR	.+2		; 8D 00
	LDS	#$494D		; 8E 494D
	XGDX			; 8F      - 68HC11

	SUBA	$44		; 90 44
	CMPA	$44		; 91 44
	SBCA	$44		; 92 44
	SUBD	$44		; 93 44 - 68HC11 6801 6303
	ANDA	$44		; 94 44
	BITA	$44		; 95 44
	LDAA	$44		; 96 44
	STAA	$44		; 97 44
	EORA	$44		; 98 44
	ADCA	$44		; 99 44
	ORAA	$44		; 9A 44
	ADDA	$44		; 9B 44
	CPX	$44		; 9C 44
	JSR	$44		; 9D 44 - 68HC11 6801 6303
	LDS	$44		; 9E 44
	STS	$44		; 9F 44

	SUBA	$58,X		; A0 58
	CMPA	$58,X		; A1 58
	SBCA	$58,X		; A2 58
	SUBD	$58,X		; A3 58 - 68HC11 6801 6303
	ANDA	$58,X		; A4 58
	BITA	$58,X		; A5 58
	LDAA	$58,X		; A6 58
	STAA	$58,X		; A7 58
	EORA	$58,X		; A8 58
	ADCA	$58,X		; A9 58
	ORAA	$58,X		; AA 58
	ADDA	$58,X		; AB 58
	CPX	$58,X		; AC 58
	JSR	$58,X		; AD 58
	LDS	$58,X		; AE 58
	STS	$58,X		; AF 58

	SUBA	$4558		; B0 4558
	CMPA	$4558		; B1 4558
	SBCA	$4558		; B2 4558
	SUBD	$4558		; B3 4558 - 68HC11 6801 6303
	ANDA	$4558		; B4 4558
	BITA	$4558		; B5 4558
	LDAA	$4558		; B6 4558
	STAA	$4558		; B7 4558
	EORA	$4558		; B8 4558
	ADCA	$4558		; B9 4558
	ORAA	$4558		; BA 4558
	ADDA	$4558		; BB 4558
	CPX	$4558		; BC 4558
	JSR	.+3		; BD XXXX
	LDS	$4558		; BE 4558
	STS	$4558		; BF 4558

	SUBB	#$49		; C0 49
	CMPB	#$49		; C1 49
	SBCB	#$49		; C2 49
	ADDD	#$494D		; C3 494D - 68HC11 6801 6303
	ANDB	#$49		; C4 49
	BITB	#$49		; C5 49
	LDAB	#$49		; C6 49
	FCB	$C7		; C7
	EORB	#$49		; C8 49
	ADCB	#$49		; C9 49
	ORAB	#$49		; CA 49
	ADDB	#$49		; CB 49
	LDD	#$494D		; CC 494D - 68HC11 6801 6303
	FCB	$CD		; CD      - 68HC11 page
	LDX	#$494D		; CE 494D
	STOP			; CF      - 68HC11

	SUBB	$44		; D0 44
	CMPB	$44		; D1 44
	SBCB	$44		; D2 44
	ADDD	$44		; D3 44 - 68HC11 6801 6303
	ANDB	$44		; D4 44
	BITB	$44		; D5 44
	LDAB	$44		; D6 44
	STAB	$44		; D7 44
	EORB	$44		; D8 44
	ADCB	$44		; D9 44
	ORAB	$44		; DA 44
	ADDB	$44		; DB 44
	LDD	$44		; DC 44 - 68HC11 6801 6303
	STD	$44		; DD 44 - 68HC11 6801 6303
	LDX	$44		; DE 44
	STX	$44		; DF 44

	SUBB	$58,X		; E0 58
	CMPB	$58,X		; E1 58
	SBCB	$58,X		; E2 58
	ADDD	$58,X		; E3 58 - 68HC11 6801 6303
	ANDB	$58,X		; E4 58
	BITB	$58,X		; E5 58
	LDAB	$58,X		; E6 58
	STAB	$58,X		; E7 58
	EORB	$58,X		; E8 58
	ADCB	$58,X		; E9 58
	ORAB	$58,X		; EA 58
	ADDB	$58,X		; EB 58
	LDD	$58,X		; EC 58 - 68HC11 6801 6303
	STD	$58,X		; ED 58 - 68HC11 6801 6303
	LDX	$58,X		; EE 58
	STX	$58,X		; EF 58

	SUBB	$4558		; F0 4558
	CMPB	$4558		; F1 4558
	SBCB	$4558		; F2 4558
	ADDD	$4558		; F3 4558 - 68HC11 6801 6303
	ANDB	$4558		; F4 4558
	BITB	$4558		; F5 4558
	LDAB	$4558		; 6F 4558
	STAB	$4558		; 7F 4558
	EORB	$4558		; 8F 4558
	ADCB	$4558		; 9F 4558
	ORAB	$4558		; FA 4558
	ADDB	$4558		; FB 4558
	LDD	$4558		; FC 4558 - 68HC11 6801 6303
	STD	$4558		; FD 4558 - 68HC11 6811 6303
	LDX	$4558		; FE 4558
	STX	$4558		; FF 4558

; all following instructions are 68HC11 only

	INY			; 1808
	DEY			; 1808

	BSET	$58,Y $42	; 181C 58 42
	BCLR	$58,Y $42	; 181D 58 42
	BRSET	$58,Y $42 .+5	; 181E 58 42 00
	BRCLR	$58,Y $42 .+5	; 181F 58 42 00

	TSY			; 1830
	TYS			; 1835
	PULY			; 1838
	ABY			; 183A
	PSHY			; 183C

	NEG	$58,Y		; 1860 58
	COM	$58,Y		; 1863 58
	LSR	$58,Y		; 1864 58
	ROR	$58,Y		; 1866 58
	ASR	$58,Y		; 1867 58
	ASL	$58,Y		; 1868 58
	ROL	$58,Y		; 1869 58
	DEC	$58,Y		; 186A 58
	INC	$58,Y		; 186C 58
	TST	$58,Y		; 186D 58
	JMP	$58,Y		; 186E 58
	CLR	$58,Y		; 186F 58

	CPY	#$494D		; 188C 494D
	XGDY			; 188F

	CPY	$44		; 189C 44

	SUBA	$58,Y		; 18A0 58
	CMPA	$58,Y		; 18A1 58
	SBCA	$58,Y		; 18A2 58
	SUBD	$58,Y		; 18A3 58
	ANDA	$58,Y		; 18A4 58
	BITA	$58,Y		; 18A5 58
	LDAA	$58,Y		; 18A6 58
	STAA	$58,Y		; 18A7 58
	EORA	$58,Y		; 18A8 58
	ADCA	$58,Y		; 18A9 58
	ORAA	$58,Y		; 18AA 58
	ADDA	$58,Y		; 18AB 58
	CPY	$58,Y		; 18AC 58
	JSR	$58,Y		; 18AD 58
	LDS	$58,Y		; 18AE 58
	STS	$58,Y		; 18AF 58

	CPY	$4558		; 18BC 4558

	LDY	#$494D		; 18CE 494D

	LDY	$44		; 18DE 44
	STY	$44		; 18DF 44

	SUBB	$58,Y		; 18E0 58
	CMPB	$58,Y		; 18E1 58
	SBCB	$58,Y		; 18E2 58
	ADDD	$58,Y		; 18E3 58
	ANDB	$58,Y		; 18E4 58
	BITB	$58,Y		; 18E5 58
	LDAB	$58,Y		; 18E6 58
	STAB	$58,Y		; 18E7 58
	EORB	$58,Y		; 18E8 58
	ADCB	$58,Y		; 18E9 58
	ORAB	$58,Y		; 18EA 58
	ADDB	$58,Y		; 18EB 58
	LDD	$58,Y		; 18EC 58
	STD	$58,Y		; 18ED 58
	LDY	$58,Y		; 18EE 58
	STY	$58,Y		; 18EF 58

	LDY	$4558		; 18FE 4558
	STY	$4558		; 18FF 4558

	CPD	#$494D		; 1A83 494D
	CPD	$44		; 1A93 44
	CPD	$58,X		; 1AA3 58
	CPY	$58,X		; 1AAC 58
	CPD	$4558		; 1AB3 4558
	LDY	$58,X		; 1AEE 58
	STY	$58,X		; 1AEF 58

	CPD	$58,Y		; CDA3 58
	CPX	$58,Y		; CDAC 58
	LDX	$58,Y		; CDEE 58
	STX	$58,Y		; CDEF 58
