var MyCloudPortalModule = Class.create(
{
	initialize: function initialize()
	{
		this.currentSiteId		= 0;
		this.currentlyDisplayed	= 0;
		this.currentHelpContent	= '';
		this.svnInstalled		= false;
		this.templates			= {};
	},
	
	finishInit: function finishInit()
	{
		Object.extend(this, MyCloudControllers);
		Object.extend(this, MyCloudViews);
		Object.extend(this, MyCloudPortalViewUtils);
		Object.extend(this, MyCloudPortalUtils);
		Object.extend(this, MyCloudViewportManager);
		
		this.registerObservers();
		
		EventManager.subscribe('/portal/cloud/sites', 
		{
			channelHook: 'MyCloudPortal'
		});
		
		Portal.API.tabs.switchingTabs = false;
		
		this._init();
		
		console.warn('FINISH INIT!!!');
	},
	
	loadComplete: function loadComplete()
	{
		// nothing here...
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if (msg.data.response == 'deleteSite')
		{
			this.deleteSite(msg);
		}
	},
	
	registerObservers: function registerObservers()
	{
		// wait for the main view to render before we continue...
        this.observeOnce('mainViewRendered', function()
        {
			this.fetchSiteList();
        }.bind(this));
		
		// update the team count...
        Portal.Data.siteList.observe('siteTeamUpdated', function(siteId)
        {
			if($('tab_team') && siteId == this.currentSiteId)
			{
				this.updateTeamCount();
			}
        }.bind(this));
		
		// update services overview...
		Portal.Data.siteList.observe(['siteServicesUpdated', 'siteServicesLoaded'], function(siteId)
		{
			if(siteId == this.currentSiteId)
			{
				this.renderSite();
			}
		}.bind(this));
		
		// update site overview / site list
		Portal.Data.siteList.observe('siteUpdated', function(siteId)
        {
			if(siteId == this.currentSiteId)
			{
				this.renderSite();
			}
			
			this.renderSiteList();
			
        }.bind(this));
		
		Portal.Data.siteList.observe(['siteAdded', 'siteDeleted'], function(siteId)
        {
			this.renderSiteList();
			
        }.bind(this));
	}
});

var MyCloudControllers = 
{
	_init: function _init()
	{
		this.setCurrentSite();
		
		this._initViews();
	},
	
	setCurrentSite: function setCurrentSite(siteId)
	{
		if (!siteId || siteId == 0) 
		{
			// is there a specific site to show?
			if (Portal.Vars.siteToLoad != 0) 
			{
				this.currentSiteId = Portal.Vars.siteToLoad;
				Portal.Vars.siteToLoad = 0;
			}
			else
			{
                var that = this;
				
				Portal.Data.siteList.sites.each(function(site)
                {
					if(that.currentSiteId == 0)
					{
						that.currentSiteId = site.value.id;
					}
                })
			}
		}
		else
		{
			this.currentSiteId = siteId;
		}
	},
	
	showSiteInCloud: function showSiteInCloud(siteId)
	{
		// make sure the cloud tab is loaded
        if (Portal.API.tabs.currentTab != 'tab_my_cloud') 
        {
        	Portal.Vars.siteToLoad = siteId;
			Portal.API.tabs.loadTabManually('tab_my_cloud');
			
			return;
        }
				
		if (siteId) 
		{
			this.setCurrentSite(siteId);
		}
		
		this.highlightCurrentSite();
		
		this.renderSite();
	},
	
	fetchSiteList: function fetchSiteList()
	{
		if(Portal.Data.siteList.loading)
		{
            Portal.Data.siteList.observeOnce('siteModelLoaded', function()
            {
				this.fetchSiteList();
            }.bind(this));
			
			return;
		}
		
		if(Portal.Data.siteList.totalSites > 0 && Portal.Data.siteList.totalSites != Portal.Data.siteList.statusInfo.deleted)
		{
			this.renderSiteList();
		}
		else
		{
			this.renderEmptyList();
		}
		
	},
	
	highlightCurrentSite: function highLightCurrentSite()
	{
		if($('list_' + this.currentSiteId) && $('list_' + this.currentSiteId).hasClassName('currentSite'))
		{
			return;
		}
		
        $A($$('#site_list li.currentSite')).each(function(item)
        {
            new Effect.Morph(item, 
            {
                style: { backgroundColor: '#ededed' },
                duration: 0.25,
				beforeStart: function()
				{
					$(item).removeClassName('currentSite');
					$(item).down().setStyle({ fontWeight: 'normal' });
				}
            });
        });
		
		if(!$('list_' + this.currentSiteId))
		{
			return;
		}
		
        new Effect.Morph('list_' + this.currentSiteId, 
        {
            style: { backgroundColor: '#ffffff' },
            duration: 0.25,
			beforeStart: function()
			{
				$('list_' + this.currentSiteId).down().setStyle({ fontWeight: 'bold' });
			}.bind(this),
            afterFinish: function()
            {
                $('list_' + this.currentSiteId).addClassName('currentSite');
            }.bind(this)
        });
	},
	
	shouldDisplaySite: function shouldDisplaySite()
	{
		var totalRunning	= 0;
		var totalDeleted	= 0;
		var totalOther		= 0;
		var totalSites		= 0;
		
		totalSites = Portal.Data.siteList.sites.size();
		
        Portal.Data.siteList.sites.each(function(site)
        {
			if(['deleted', 'deleting'].indexOf(site.value.status.toLowerCase()) != -1)
			{
				totalDeleted ++;
			}
			else if (['running', 'warning'].indexOf(site.value.status.toLowerCase()) != -1)
			{
				totalRunning ++;
			}
			else
			{
				totalOther ++;
			}
        });
		
		console.log('Total Sites: ' + totalSites);
		console.log('Total Running: ' + totalRunning);
		console.log('Total Deleted: ' + totalDeleted);
		console.log('Total Other: ' + totalOther);
		
		if(totalRunning == 0)
		{
			return false;
		}
		
		return true;
	},
	
	showTabs: function showTabs()
	{
		var currentSite = Portal.Data.siteList.sites.get(this.currentSiteId);
		
		if(['Running', 'Warning'].indexOf(currentSite.status) != -1 && $('cloud_site_tabs'))
		{
			var teamSize = Portal.Data.siteList.sites.get(this.currentSiteId).memberships.memberships.size();
			
			if(teamSize == 0)
			{
				teamSize = 1;
			}
			
			$('tab_team').update('Team (' + teamSize + ')');
			
			$('cloud_site_tabs').show();
			
            this.siteTabs = new Control.Tabs('cloud_site_tabs', 
            {
                afterChange: function(newContainer)
                {
					this.loadTabContent(newContainer);
					
					$('cloud_site_tabs').setStyle({ height: $('cloud_site_tabs').getHeight() - 2 + 'px' });
					
                }.bind(this)
            });
		}
		else
		{
			$('cloud_site_tabs').hide();
		}
	},
	
	loadTabContent: function loadTabContent(containerId)
	{
		switch($(containerId).id)
		{
			case 'site_overview':
				Portal.Vars.currentHelpContent = 'My_Cloud_-_Overview';
				this.renderSiteOverview();
				break;
			case 'site_settings':
				Portal.Vars.currentHelpContent = 'My_Cloud_-_Settings';
				this.renderSiteSettings();
				break;
			case 'site_services':
				Portal.Vars.currentHelpContent = 'My_Cloud_-_Services';
				this.renderSiteServices();
				break;
			case 'site_stats':
				Portal.Vars.currentHelpContent = 'My_Cloud_-_Analytics';
				this.renderSiteAnalytics();
				break;
			case 'site_users':
				Portal.Vars.currentHelpContent = 'My_Cloud_-_Team';
				this.renderSiteTeam();
				break;
			case 'site_logs':
				Portal.Vars.currentHelpContent = "My_Cloud_-_Logs";
				this.renderSiteLogs();
				break;
		}
		
		this.currentHelpContent = Portal.Vars.currentHelpContent;
	}
}

var MyCloudViews = 
{
	_initViews: function _initViews()
	{
		this.renderPage();
	},
		
	renderPage: function renderPage()
	{
        View.load(
        {
			main: 
			{
				file: 'portlets/cloud/templates/portals/my_cloud/my_cloud_new.html',
				binding: function()
				{
					return $('content_tab_my_cloud');
				},
				behaviors: function()
				{
					$('content_tab_my_cloud').show();
					
					// set up the window.resize listener
					this.resizeViewPort();
					this.boundResizeViewPort = this.resizeViewPort.bindAsEventListener(this);
					
					Event.stopObserving(window, 'resize', this.boundResizeViewPort);
					Event.observe(window, 'resize', this.boundResizeViewPort);
					
					// load the undeployed projects module
					Portal.API.modules.loadModule('UndeployedProjects', UndeployedProjectsModule, true);
					
				}.bind(this)
			}
		}, 
		function(templates)
		{
			this.templates.main = templates.main;
			
			this.templates.main.render();
			
			this.notify('mainViewRendered');
					
		}.bind(this))
	},
	
	renderSiteList: function renderSiteList()
	{
        View.load(
        {
			siteList:
			{
				file: 'portlets/cloud/templates/my_cloud/site_list.html',
				binding: function()
				{
					return $('site_list_wrap');
				},
				scope:
				{
					siteList: Portal.Data.siteList.sites,
					currentSiteId: this.currentSiteId
				},
				behaviors: function()
				{
					$('cloud_site_status').show();
					
                    $$('li.siteListItem').each(function(item)
                    {
						var siteId = item.id.replace('list_', '');
						var site = Portal.Data.siteList.sites.get(siteId);
						
						var context_menu = new Control.ContextMenu(item.id);
						
						if(['provisioning', 'provisioned', 'initializing', 'initialized'].indexOf(site.status.toLowerCase()) == -1)
						{
							// visit site menu item
	                        context_menu.addItem(
	                        {
								label: 'Visit site',
								callback: function()
								{
									Portal.API.utils.openUrl('http://' + site.domain);
								}
							});
							
							// sync menu item
	                        context_menu.addItem(
	                        {
								label: 'Synchronize site...',
								callback: function()
								{
									this.doSync(site.id);
								}.bind(this)
							});
							
							// browse remote menu item
	                        context_menu.addItem(
	                        {
								label: 'Browse remote',
								callback: function()
								{
									this.browseRemote(site.id)
								}.bind(this)
							});
							
							// browse local project menu item
	                        context_menu.addItem(
	                        {
								label: 'Browse local project',
								enabled: (site.project) ? true : false,
								callback: function()
								{
									this.browseProject(site.project);
								}.bind(this)
							});
							
							// delete site menu item
	                        context_menu.addItem(
	                        {
								label: 'Delete site...',
								enabled: (site.isOwner) ? true : false,
								callback: function()
								{
									this.deleteSiteById(site.id);
								}.bind(this)
							});
						}
						
						// check for deleted sites...
                        Portal.Data.siteList.sites.each(function(site)
                        {
							if(['deleted', 'deleting'].indexOf(site.value.status.toLowerCase()) != -1)
							{
								if($('list_' + site.value.id))
								{
									new Effect.Fade($('list_' + site.value.id), { duration: 0.25 });
									
									if(site.value.id == this.currentlyDisplayed || site.value.id == this.currentSiteId)
									{
										this.currentSiteId = 0;
										this.currentlyDisplayed = 0;
									}
								}
							}
							
                        }.bind(this));
						
						if (this.currentlyDisplayed == 0) 
						{
							this.showSiteInCloud();
						}
						else
						{
							this.highlightCurrentSite();
						}
						
						
                    }.bind(this));
				}.bind(this)
			}
		}, 
		function(templates)
        {
			this.templates.siteList = templates.siteList;
			this.templates.siteList.render();
        }.bind(this));
	},

	renderEmptyList: function renderEmptyList()
	{
        View.load(
        {
			main: 
			{
				file: 'portlets/cloud/templates/my_cloud/no_sites.html',
				binding: function ()
				{
					return $('site_content');
				},
				behaviors: function()
				{
					Portal.API.modules.loadModule('DeployProjectMini', DeployProjectMiniModule, false);
					
					$('cloud_site_status').style.display = 'none';
					$('cloud_site_status').setStyle({ background: 'none' });
					
					$('cloud_site_ip').update('');
					$('cloud_site_name').update('');
					
					$('cloud_site_tabs').hide();
					
					if($('site_list_working'))
					{
						$('site_list_working').hide();
					}
				}
			}
		},
		function(templates)
		{
			templates.main.render();
		});
	},
	
	renderSite: function renderSite()
	{
		// before we do anything, make sure that we should actually display a site..
		if(!this.shouldDisplaySite())
		{
			this.renderEmptyList();
			
			return;
		}
		
		var currentSite = Portal.Data.siteList.sites.get(this.currentSiteId);
		
		if(!currentSite)
		{
			this.setCurrentSite();
			this.showSiteInCloud();
			
			return;
		}
		
		// take care of the stuff that can't be handled through templating (due to design implementation, etc.)
		try
		{
			$('cloud_site_name').update('<a href="javascript: Portal.API.utils.openUrl(\'http://' + currentSite.domain + '\');">' + currentSite.domain + '</a>');
			$('cloud_site_ip').update(currentSite.ip);
			this.setSiteStatus(currentSite.status);
		}
		catch(e)
		{
			console.warn(e);
		}
		
		// display site info (running and warning are allowed)
		if(['running', 'warning'].indexOf(currentSite.status.toLowerCase()) != -1)
		{
			// we're on a site, but the main overview tab isn't displayed... do nothing
			if(this.siteTabs && this.siteTabs.activeContainer.id != 'site_overview')
			{
				// do nothing as long as this is the same site we're currently viewing...
				if (this.currentlyDisplayed == currentSite.id) 
				{
					return;
				}
			}
			
			this.renderLiveSite(currentSite);
		}
		// Show an error screen
		else if (['rebooting', 'suspended', 'deleted', 'deleting', 'error'].indexOf(currentSite.status.toLowerCase()) != -1)
		{
			// show the "error" screen
			this.showTabs();
			this.currentlyDisplayed = currentSite.id;
			
			this.renderErrorSite(currentSite);
		}
		// Show provisioning status
		else
		{
			this.showTabs();
			this.currentlyDisplayed = currentSite.id;
			
			this.renderProvisioningSite(currentSite);
		}
		
	},
	
	renderLiveSite: function renderLiveSite(currentSite)
	{
        View.load(
        {
			dashboard: 
			{
				file: 'portlets/cloud/templates/my_cloud/site_dashboard.html',
				binding: function()
				{
					return $('site_content');
				},
				scope:
				{
					currentSite: currentSite
				}
			},
			overview:
			{
				file: 'portlets/cloud/templates/my_cloud/site_overview.html'
			}
		},
		function(templates)
		{
			this.templates.dashboard = templates.dashboard;
			this.templates.dashboard.set('overview', templates.overview);
			
			this.templates.dashboard.render();
			
			if(!this.siteTabs || this.currentlyDisplayed != currentSite.id)
			{
				this.showTabs();
				this.currentlyDisplayed = currentSite.id;
			}
			// weird render bug with the first display of the first site... this takes care of it
			else if (this.siteTabs && this.siteTabs.activeContainer.id == 'site_overview' && $('site_overview').style.display == 'none')
			{
				this.showTabs();
			}
			
		}.bind(this));
	},
	
	renderErrorSite: function renderErrorSite(currentSite)
	{
        View.load(
        {
			main:
			{
				file: 'portlets/cloud/templates/my_cloud/site_error.html',
				scope: { currentSite: currentSite },
				binding: function()
				{
					return $('site_content');
				},
				behaviors: function()
				{
					$('cloud_site_ip').update('<div class="gray48"><strong>Site Status: </strong> ' + currentSite.status + '</div>');
				}
			}
		}, 
		function(templates)
        {
			templates.main.render();
        });
	},
	
	renderProvisioningSite: function renderProvisioningSite(currentSite)
	{
        View.load(
        {
			main:
			{
				file: 'portlets/cloud/templates/my_cloud/site_provisioning.html',
				scope: { currentSite: currentSite },
				binding: function()
				{
					return $('site_content');
				},
				behaviors: function()
				{
					$('cloud_site_ip').update('<div class="gray48"><strong>Site Status: </strong> ' + currentSite.status + '</div>');
				}
			}
		}, 
		function(templates)
        {
			templates.main.render();
        });
	},
	
	renderSiteOverview: function renderSiteOverview()
	{
		Portal.API.utils.setContent('site_overview', '');
		
        View.load(
        {
			main:
			{
				file: 'portlets/cloud/templates/my_cloud/site_overview.html',
				binding: function()
				{
					return $('site_overview');
				},
				scope:
				{
					currentSite: Portal.Data.siteList.sites.get(this.currentSiteId)
				},
				behaviors: function()
				{
					this.parseDiskUsage(Portal.Data.siteList.sites.get(this.currentSiteId));
					
					Portal.API.modules.loadModule('NotificationList', NotificationListModule, false);	
				}.bind(this)
			}
		},
		function(templates)
		{
			templates.main.render();
		});
	},
	
	renderSiteSettings: function renderSiteSettings()
	{
		Portal.API.utils.setContent('site_settings', '');
		
        View.load(
        {
			main:
			{
				file: 'portlets/cloud/templates/my_cloud/site_settings.html',
				binding: function()
				{
					return $('site_settings');
				},
				behaviors: function()
				{
					var isOwner = Portal.Data.siteList.sites.get(this.currentSiteId).isOwner;
					
					if (isOwner) 
					{
						Portal.API.modules.loadModule('Configurator', ConfiguratorClass, false);
						$('deleteSiteEnabled').show();
					}
					else
					{
						$('deleteSiteDisabled').show();
					}
					
					Portal.API.modules.loadModule('LocalProjectSwitcher', LocalProjectSwitcherModule, false);
					
				}.bind(this)
			}
		},
		function(templates)
		{
			templates.main.render();
		});
	},
	
	renderSiteAnalytics: function renderSiteAnalytics()
	{
		Portal.API.utils.setContent('site_stats', '');
		
		View.load(
        {
			main:
			{
				file: 'portlets/cloud/templates/my_cloud/site_analytics.html',
				binding: function()
				{
					return $('site_stats');
				},
				behaviors: function()
				{
					Portal.API.modules.loadModule('Cloudalytics', CloudalyticsClass, false);
				}
			}
		},
		function(templates)
		{
			templates.main.render();
		});
	},
	
	renderSiteServices: function renderSiteServices()
	{
		Portal.API.utils.setContent('site_services', '');
		
		Portal.API.modules.loadModule('SiteServices', ServicesManagerModule, false);
	},
	
	renderSiteTeam: function renderSiteTeam()
	{
		Portal.API.utils.setContent('site_users', '');
		
        View.load(
        {
			main: 
			{
				file: 'portlets/cloud/templates/my_cloud/site_team.html',
				binding: function()
				{
					return $('site_users');
				}
			}
		},
		function (templates)
		{
			templates.main.render();
			
			Portal.API.modules.loadModule('TeamManager', TeamManagerModule, false);
		});
	},
	
	renderSiteLogs: function renderSiteLogs()
	{
		Portal.API.utils.setContent('site_logs', '');
		
		Portal.API.modules.loadModule('SiteLogs', LogsManagerModule, false);
	}
}

var MyCloudPortalViewUtils = 
{
	setSiteStatus: function setSiteStatus(status)
	{
		var siteStatusImage = '';
		
		switch (status)
		{
			case 'Error':
				siteStatusImage = 'error';
				break;
			case 'Running':
				siteStatusImage = 'running';
				break;
			case 'Initializing':
			case 'Initialized':
			case 'Provisioned':
			case 'Pending':
				siteStatusImage = 'provisioning';
				break;
			case 'Warning':
				siteStatusImage = 'warning';
				break;
			case 'Rebooting':
				siteStatusImage = 'provisioning';
				break;
			default:
				siteStatusImage = 'error';
		}
		
		if ($('cloud_site_status')) 
		{
			$('cloud_site_status').setStyle(
			{
				background: 'url(images_global/img_status_' + siteStatusImage + '.png) no-repeat right 3px'
			});
		}
	},
	
	updateTeamCount: function updateTeamCount()
	{
		try
		{
			var teamSize = Portal.Data.siteList.sites.get(this.currentSiteId).memberships.memberships.size();
				
			if(teamSize == 0)
			{
				teamSize = 1;
			}
			
			$('tab_team').update('Team (' + teamSize + ')');
		}
		catch (e) 
		{
			console.warn(e);
		}
	},
	
	parseDiskUsage: function parseDiskUsage(currentSite)
	{
		var totalSpace = 5;
		
		switch(parseInt(currentSite.hostingPlanId))
		{
			case 9:
				totalSpace = 10;
				break;
			case 10:
				totalSpace = 15;
				break;
			case 11:
				totalSpace = 25;
				break;
		}
		
		currentSite.diskUsage.calculateStats(totalSpace);
		
		if (currentSite.diskUsage.usagePercent == 100) 
		{
			$$('span.totalDisk').each(function(item) { $(item).update(currentSite.diskUsage.totalDisk) });
			$$('span.totalUsed').each(function(item) { $(item).update(currentSite.diskUsage.totalUsed) });
			$$('span.totalLeft').each(function(item) { $(item).update(currentSite.diskUsage.totalLeft) });
			Portal.API.utils.setContent('total_storage', currentSite.diskUsage.totalDisk);
		}
		else
		{
			Portal.API.utils.setContent('total_storage', currentSite.diskUsage.totalDisk);
			
			$$('span.totalDisk').each(function(item) { $(item).update(currentSite.diskUsage.totalDisk) });
			$$('span.totalUsed').each(function(item) { $(item).update(currentSite.diskUsage.totalUsed) });
			$$('span.totalLeft').each(function(item) { $(item).update(currentSite.diskUsage.totalLeft) });
			
			Portal.API.utils.setContent('usagePercent', currentSite.diskUsage.usagePercent);
			
			if($('diskUsage'))
			{
	            $('diskUsage').setStyle(
	            {
	                backgroundPosition: '0 -' + currentSite.diskUsage.chartIncrement + 'px'
	            });
			}
		}
	}
}

var MyCloudPortalUtils = 
{
	deleteSiteById: function deleteSiteById(siteId)
	{
		this.siteToDelete = parseInt(siteId);
		
		this.deleteSite(false, true);
	},
	
	deleteSite: function deleteSite(msg, deleteById)
	{
		if(!msg)
		{
			var isOwner = Portal.Data.siteList.sites.get(this.currentSiteId).isOwner;
			
			if(!isOwner)
			{
				Portal.API.dialogs.alert('You do not have permission to delete this site.  Only the owner of the site may do so.', 'Cannot Delete Site');
				return;
			}
			
			if (!deleteById) 
			{
				this.siteToDelete = this.currentSiteId;
			}
			
            Portal.API.dialogs.confirm(
            {
				message: 'Are you sure you wish to delete the site "' + Portal.Data.siteList.sites.get(this.siteToDelete).name.truncate(30) + '"?<br /><br /><em>This cannot be undone, and we cannot restore your site once you delete it.</em>'
						 + '<br /><br />Please also note that while the site will be deleted right away, you may not be able to reuse your domain for a while.  Domains usually become available again within 10 minutes.',
				title: 'Confirm site deletion',
				onConfirm: function()
				{
                    Portal.API.dialogs.observeOnce('confirmClosed', function()
                    {
						this.showDeleteWindow.delay(0.25);
                    }.bind(this));
				}.bind(this)
			});
		}
		else
		{
			
			var totalRunning = 0;
			
            Portal.Data.siteList.sites.each(function(site)
            {
				if(['deleted', 'deleting'].indexOf(site.value.status.toLowerCase) == -1)
				{
					totalRunning ++;
				}
            });
			
			if(totalRunning == 0)
			{
				$('cloud_site_status').hide();
				$('cloud_site_ip').update('');
				$('cloud_site_name').update('');
				
				this.renderEmptyList();
			}
			else if(this.currentSiteId == this.siteToDelete || this.currentlyDisplayed == this.siteToDelete)
			{
				this.currentSiteId = 0;
				this.currentlyDisplayed = 0;
				
				this.showSiteInCloud();
			}
			
			this.siteToDelete = 0;
			
			this.deleteDialog.close();
			this.deleteDialog.destroy();
			
			// just to be sure...
			this.fetchSiteList();
		}
	},
	
	showDeleteWindow: function showDeleteWindow()
	{
		var deleteContent 	= '<div class="clean-yellow"><div class="bold line16 center top5"><img src="images_global/img_aptana_throbber.gif" class="inline" align="absmiddle" />'
							+ ' Please wait, we\'re deleting your site</div><div class="size11 line14 top5 center"><em>This should only take a moment...</em></div></div>';
		
        Portal.Modules.MyCloudPortal.deleteDialog = new Control.Modal(deleteContent, 
        {
			closeOnClick: false,
			className: 'modal',
			width: 300,
			overlayOpacity: 0.75,
			fade: true,
			height: null,
			fadeDuration: 0.25,
			iframeshim: false,
			afterOpen: function()
			{
                EventManager.publish('/portal/cloud/sites', 
                {
                    request: 'deleteSite',
                    id: Portal.Modules.MyCloudPortal.siteToDelete
                });
				
			}.bind(this)
		});
		
		Portal.Modules.MyCloudPortal.deleteDialog.open();
	},
	
	browseRemote: function browseRemote(siteId)
	{
		if(!siteId)
		{
			var siteId = this.currentSiteId;
		}
		
		EventManager.publish('/portal/cloud/site/browse', { request: 'showFile', id: siteId });
	},
	
	browseProject: function browseProject(projectName)
	{
		EventManager.publish('/portal/projects/show', { project: projectName });
	},
	
	showSyncExplorer: function showSyncExplorer()
	{
		EventManager.publish('/portal/cloud/site/browse', { request: 'showExplorer', id: this.currentSiteId });
	},
	
	showPhpMyAdmin: function showPhpMyAdmin()
	{
		Portal.API.utils.openUrl(Portal.Data.siteList.sites.get(this.currentSiteId).urls.phpMyAdmin);
	},
	
	showDbManager: function()
	{
		Portal.API.utils.openPerspective('com.aptana.ide.db.PerspectiveFactory', 'zigen.plugin.db.ui.views.TreeView');
	},
	
	browseRemoteFile: function(fileToOpen)
	{
        EventManager.publish('/portal/cloud/site/browse', 
        {
			request: 'showFile',
			id: this.currentSiteId,
			path: fileToOpen
		});
	},
	
	openRemoteFile: function(fileToOpen)
	{
        EventManager.publish('/portal/cloud/site/browse', 
        {
			request: 'openFile',
			id: this.currentSiteId,
			path: fileToOpen
		});
	},
	
	doSync: function doSync(siteId)
	{
		if(!siteId)
		{
			var siteId = this.currentSiteId;
		}
		
		var currentSite = Portal.Data.siteList.sites.get(siteId);
		
		if(!currentSite.project)
		{
			Portal.API.dialogs.alert('There is currently no local project associated with this site.  You cannot sync until you associate a project.  Visit the "Settings" tab to do so.', 'No local project');
			return;
		}
		
		EventManager.publish('/portal/cloud/sync', { request: 'syncSite', id: siteId });
	},
	
	browseSvn: function browseSvn(location)
	{
		if(location == 'web')
		{
			Portal.API.utils.openUrl(Portal.Data.siteList.sites.get(this.currentSiteId).urls.svn);
		}
		else if (location == 'studio')
		{
			EventManager.publish('/portal/cloud/svn', { request: 'showView' });
		}
	},
	
	backups: function backups(action)
	{
		if (action == 'browse')
		{
			this.browseRemoteFile(Portal.Data.siteList.sites.get(this.currentSiteId).files.backups);
		}
		else if (action == 'backup')
		{
			EventManager.publish('/portal/cloud/site/dump', 
	        {
	            request: 'dumpData',
	            id: this.currentSiteId
	        });
			
			Portal.API.dialogs.alert('A backup of your site has been started.  We\'ll drop a zip file in the backups directory of your private ftp root when it\'s done!  This backup will include your site root as well as a database backup.', 'Backup started');
		}
	}
};

var MyCloudViewportManager = 
{
	resizeViewPort: function(recurse)
	{
		if(Portal.API.tabs.currentTab != 'tab_my_cloud')
		{
			return;
		}
		
		if(!this.previousWindowHeight)
		{
			this.previousWindowHeight = 0;
			this.previousWindowWidth = 0;
		}
		
		$('site_content').hide();
		$('site_list_wrap').hide();
		
		var windowHeight = document.viewport.getHeight();
		var windowWidth = document.viewport.getWidth();
		var headerHeight = 76;
		var legendHeight = 0; // 80;
		var utilsHeight = 76;
		var scrollBarSize = this.getScrollBarWidth();
				
		// set the height of the content area and site list
		$('site_list_cage').setStyle({ height: windowHeight - headerHeight - legendHeight - utilsHeight - 2 + 'px', overflow: 'auto' });
		$('site_list_wrap').setStyle({ height: $('site_list_cage').getHeight() + 'px', overflow: 'auto' });
		$('site_content_cage').setStyle({height: windowHeight - headerHeight - utilsHeight - 1 + 'px' });
		$('site_content').setStyle({
			height: $('site_content_cage').getHeight() + 'px'
		});
		
		$('site_list_wrap').show();
		$('site_content').show();
		
		this.previousWindowHeight = windowHeight;
	},
	
		
	getScrollBarWidth: function()
	{
		var inner = document.createElement('p');
		inner.style.width = "100%";
		inner.style.height = "200px";
		
		var outer = document.createElement('div');
		outer.style.position = "absolute";
		outer.style.top = "0px";
		outer.style.left = "0px";
		outer.style.visibility = "hidden";
		outer.style.width = "200px";
		outer.style.height = "150px";
		outer.style.overflow = "hidden";
		outer.appendChild (inner);
		
		document.body.appendChild (outer);
		var w1 = inner.offsetWidth;
		outer.style.overflow = 'scroll';
		var w2 = inner.offsetWidth;
		if (w1 == w2) w2 = outer.clientWidth;
		
		document.body.removeChild (outer);
		
		return (w1 - w2);
	}
};


Object.Event.extend(MyCloudPortalModule);

Portal.API.tabs.registerTab('my_cloud', 2, 
{
	name: 'my_cloud',
	moduleName: 'MyCloudPortal',
	moduleObj: MyCloudPortalModule,
	isDefault: false,
	title: 'My Cloud',
	requireLogin: true
});