var UndeployedProjectsModule = Class.create( 
{
	finishInit: function finishInit()
	{
		Portal.Data.cloudProjects.observe('projectListUpdated', function()
        {
			this.showProjectDrop();
        }.bind(this));
		
		this.showProjectDrop();
	},
	
	showProjectDrop: function()
	{
		if (Portal.Data.cloudProjects.loading) 
		{
			return;
		}
		
		var ProjectListTemplate = new Template('<select name="undeployedProjects" id="undeployedProjects" onchange="Portal.Modules.UndeployedProjects.doDeployProject();" class="text" style="width: 140px; font-size: 11px"><option value="---">Deploy Project...</option>#{projectOptions}</select>');
		var noProjectsTemplate = new Template('&nbsp;');
		var projectOptionTemplate = new Template('<option name="#{project}">#{project}</option>');
		
		var projects = '';
		
		if(Portal.Data.cloudProjects.totalProjects == 0)
		{
			Portal.API.utils.setContent('undeployedProjectCage', noProjectsTemplate.evaluate({}));
			return;
		}
				
		if (Portal.Data.cloudProjects.totalUndeployed == 0) 
		{
			Portal.API.utils.setContent('undeployedProjectCage', noProjectsTemplate.evaluate({}));
			return;
		}
		
        Portal.Data.cloudProjects.undeployedProjects.each(function(item)
        {
            projects += projectOptionTemplate.evaluate(
            {
                project: item.value.name
            });
        });
				
		
		Portal.API.utils.setContent('undeployedProjectCage', ProjectListTemplate.evaluate(
		{
			projectOptions: projects
		}));
	},
	
	doDeployProject: function()
	{
		if($F('undeployedProjects') != '---')
		{
			if($('site_settings') && typeof(Portal.Modules.MyCloudPortal.siteTabs) != 'undefined')
			{
				Portal.Modules.MyCloudPortal.siteTabs.setActiveTab('site_overview');
			}
			
			if($('configuratorCage'))
			{
				$('configuratorCage').remove();
			}
			
			
			try{
            Portal.Modules.DeploymentWizard.showWizard( 
            {
                data: 
                {
                    projectName: $F('undeployedProjects')
                }
            });
			
			$('undeployedProjects').selectedIndex = 0;
			} catch (e) { console.warn(e) }
		}
	}
});
