var NotificationListModule = Class.create(
{
	initialize: function initialize()
	{
		this.firstTime = true;
		this.templateLocation = 'portlets/cloud/templates/notification_list/';
		this.templates = new Hash(
        {
			messageItem:			this.templateLocation + 'message_item.html',
			messageItemMultiline:	this.templateLocation + 'message_item_multiline.html'
		});
	},
	
	finishInit: function finishInit()
	{
        Portal.Data.siteList.observe('siteEventsUpdated', function(siteId)
        {
			if(siteId == Portal.Modules.MyCloudPortal.currentSiteId)
			{
				this.fetchMessages();
			}
        }.bind(this));
		
		Portal.API.templates.load(this.templates, function(templates)
        {
			this.templates = templates;
			
			this.fetchMessages();
			
        }.bind(this));
		
	},
	
	fetchMessages: function fetchMessages()
	{
		if(!$('messageList') && $('eventListCage'))
		{
			$('eventListCage').update('<ul id="messageList" style="margin-bottom: -5px;"></ul>');
		}
		
		var siteMessages = Portal.Data.siteList.sites.get(Portal.Modules.MyCloudPortal.currentSiteId).events;
		
		var lastMessageId = '';
		
		if(siteMessages.messageList.length == 0)
		{
			if ($('eventListCage')) 
			{
				$('eventListCage').update('<div style="padding-top: 5px; padding-bottom: 5px;" class="size12 line16">Events and notifications temporarily unavailable</div>');
			}
			
			return;
		}
		
		siteMessages.messageList.each(function(message)
		{
			if($('message_' + message.id))
			{
				return;	
			}
			
			if(siteMessages.getSeverity(message.severity) == 'debug')
			{
				message.severity = 1;
			}
			
			var messageContents = message.body.escapeHTML().split('\n');
			
			var messageLine1 = messageContents.shift();
			var messageLines = (messageContents.length > 0) ? messageContents.join('<br />') : '';
			
			var messageHtml = '';
			
			try
			{
				if(messageLines != '')
				{
	                messageHtml = this.templates.get('messageItemMultiline').evaluate(
	                {
						id: 			message.id,
						status: 		siteMessages.getSeverity(message.severity),
						messageTime:	message.time,
						messageLine1:	messageLine1,
						messageBody:	messageLines
					});
				}
				else
				{
					messageHtml = this.templates.get('messageItem').evaluate(
	                {
						id:				message.id,
						status:			siteMessages.getSeverity(message.severity),
						messageTime:	message.time,
						messageBody:	messageLine1
					});
				}
			}
			catch (e)
			{
				// catch any errors around the item not being a template... simply move on
				return;
			}
			
			
			if($('messageList'))
			{
				if (this.firstTime) 
				{
					if (lastMessageId == '') 
					{
						$('messageList').insert(
						{
							bottom: messageHtml
						});
					}
					else 
					{
						$('message_' + lastMessageId).insert(
						{
							after: messageHtml
						});
					}
				}
				else
				{
                    $('messageList').insert(
                    {
                        top: messageHtml
                    });
				}
			}
			
			lastMessageId = message.id;
		}.bind(this))
		
		this.firstTime = false;
	},
	
	showFullMessage: function showFullMessage(messageId)
	{
		Effect.toggle('more_' + messageId, 'appear', { duration: 0.25 });
        Effect.toggle('message_full_' + messageId, 'appear', 
        {
            duration: 0.25,
            afterFinish: function()
            {
                // nothing here for the moment (used to be Safari fix)
            }
        });
	}
});